@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property host The host name of the destination to which requests are redirected within ALB.
 * @property path The path to which requests are to be redirected within ALB.
 * @property query The query string of the request to be redirected within ALB.
 */
public data class GetRulesRuleRuleActionRewriteConfig(
    public val host: String,
    public val path: String,
    public val query: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetRulesRuleRuleActionRewriteConfig): GetRulesRuleRuleActionRewriteConfig = GetRulesRuleRuleActionRewriteConfig(
            host = javaType.host(),
            path = javaType.path(),
            query = javaType.query(),
        )
    }
}
