@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cookieConfigs The configuration of the cookie.
 * @property headerConfigs The configuration of the header field.
 * @property hostConfigs The configuration of the host.
 * @property methodConfigs The configuration of the request method.
 * @property pathConfigs The configuration of the path for the request to be forwarded.
 * @property queryStringConfigs The configuration of the query string.
 * @property sourceIpConfigs The Based on source IP traffic matching.
 * @property type The type of the forwarding rule.
 */
public data class GetRulesRuleRuleCondition(
    public val cookieConfigs: List<GetRulesRuleRuleConditionCookieConfig>,
    public val headerConfigs: List<GetRulesRuleRuleConditionHeaderConfig>,
    public val hostConfigs: List<GetRulesRuleRuleConditionHostConfig>,
    public val methodConfigs: List<GetRulesRuleRuleConditionMethodConfig>,
    public val pathConfigs: List<GetRulesRuleRuleConditionPathConfig>,
    public val queryStringConfigs: List<GetRulesRuleRuleConditionQueryStringConfig>,
    public val sourceIpConfigs: List<GetRulesRuleRuleConditionSourceIpConfig>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetRulesRuleRuleCondition): GetRulesRuleRuleCondition = GetRulesRuleRuleCondition(
            cookieConfigs = javaType.cookieConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleConditionCookieConfig.Companion.toKotlin(args0)
                })
            }),
            headerConfigs = javaType.headerConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleConditionHeaderConfig.Companion.toKotlin(args0)
                })
            }),
            hostConfigs = javaType.hostConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleConditionHostConfig.Companion.toKotlin(args0)
                })
            }),
            methodConfigs = javaType.methodConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleConditionMethodConfig.Companion.toKotlin(args0)
                })
            }),
            pathConfigs = javaType.pathConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleConditionPathConfig.Companion.toKotlin(args0)
                })
            }),
            queryStringConfigs = javaType.queryStringConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleConditionQueryStringConfig.Companion.toKotlin(args0)
                })
            }),
            sourceIpConfigs = javaType.sourceIpConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleConditionSourceIpConfig.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
