@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ciphers The supported cipher suites, which are determined by the TLS protocol version.
 * @property id The ID of the Security Policy.
 * @property resourceGroupId The ID of the resource group.
 * @property securityPolicyId The first ID of the resource.
 * @property securityPolicyName The name of the resource. The name must be 2 to 128 characters in length and must start with a letter. It can contain digits, periods (.), underscores (_), and hyphens (-).
 * @property status The status of the resource.
 * @property tlsVersions The TLS protocol versions that are supported. Valid values: TLSv1.0, TLSv1.1, TLSv1.2 and TLSv1.3.
 */
public data class GetSecurityPoliciesPolicy(
    public val ciphers: List<String>,
    public val id: String,
    public val resourceGroupId: String,
    public val securityPolicyId: String,
    public val securityPolicyName: String,
    public val status: String,
    public val tlsVersions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetSecurityPoliciesPolicy): GetSecurityPoliciesPolicy = GetSecurityPoliciesPolicy(
            ciphers = javaType.ciphers().map({ args0 -> args0 }),
            id = javaType.id(),
            resourceGroupId = javaType.resourceGroupId(),
            securityPolicyId = javaType.securityPolicyId(),
            securityPolicyName = javaType.securityPolicyName(),
            status = javaType.status(),
            tlsVersions = javaType.tlsVersions().map({ args0 -> args0 }),
        )
    }
}
