@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property healthCheckConfigs The configuration of health checks.
 * @property id The ID of the Server Group.
 * @property protocol The server protocol. Valid values: `HTTP` and `HTTPS`. Default value: `HTTP`.
 * @property scheduler The scheduling algorithm. Valid values: `Wrr`, `Wlc` and `Sch`.
 * @property serverGroupId The first ID of the res ource.
 * @property serverGroupName The name of the resource.
 * @property servers The backend server.
 * @property status The status of the resource.
 * @property stickySessionConfigs The configuration of the sticky session.
 * @property tags A map of tags assigned to the group.
 * @property vpcId The ID of the VPC that you want to access.
 */
public data class GetServerGroupsGroup(
    public val healthCheckConfigs: List<GetServerGroupsGroupHealthCheckConfig>,
    public val id: String,
    public val protocol: String,
    public val scheduler: String,
    public val serverGroupId: String,
    public val serverGroupName: String,
    public val servers: List<GetServerGroupsGroupServer>,
    public val status: String,
    public val stickySessionConfigs: List<GetServerGroupsGroupStickySessionConfig>,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetServerGroupsGroup): GetServerGroupsGroup = GetServerGroupsGroup(
            healthCheckConfigs = javaType.healthCheckConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetServerGroupsGroupHealthCheckConfig.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            protocol = javaType.protocol(),
            scheduler = javaType.scheduler(),
            serverGroupId = javaType.serverGroupId(),
            serverGroupName = javaType.serverGroupName(),
            servers = javaType.servers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetServerGroupsGroupServer.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            stickySessionConfigs = javaType.stickySessionConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetServerGroupsGroupStickySessionConfig.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
        )
    }
}
