@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property healthCheckCodes The status code for a successful health check. Multiple status codes can be specified as a list. Valid values: `http_2xx`, `http_3xx`, `http_4xx`, and `http_5xx`. Default value: `http_2xx`. **NOTE:** This parameter exists if the `HealthCheckProtocol` parameter is set to `HTTP`.
 * @property healthCheckConnectPort The port of the backend server that is used for health checks. Valid values: `0` to `65535`. Default value: `0`. A value of `0` indicates that a backend server port is used for health checks.
 * @property healthCheckEnabled Indicates whether health checks are enabled. Valid values: `true`, `false`. Default value: `true`.
 * @property healthCheckHost The domain name that is used for health checks.
 * @property healthCheckHttpVersion HTTP protocol version. Valid values: `HTTP1.0` and `HTTP1.1`. Default value: `HTTP1.1`. **NOTE:** This parameter exists if the `HealthCheckProtocol` parameter is set to `HTTP`.
 * @property healthCheckInterval The time interval between two consecutive health checks. Unit: seconds. Valid values: `1` to `50`. Default value: `2`.
 * @property healthCheckMethod Health check method. Valid values: `GET` and `HEAD`. Default: `GET`. **NOTE:** This parameter exists if the `HealthCheckProtocol` parameter is set to `HTTP`.
 * @property healthCheckPath The forwarding rule path of health checks. **NOTE:** This parameter exists if the `HealthCheckProtocol` parameter is set to `HTTP`.
 * @property healthCheckProtocol Health check protocol. Valid values: `HTTP` and `TCP`.
 * @property healthCheckTimeout The timeout period of a health check response. If a backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the ECS instance is considered unhealthy. Unit: seconds. Valid values: `1` to `300`. Default value: `5`. **NOTE:** If the value of the `HealthCHeckTimeout` parameter is smaller than that of the `HealthCheckInterval` parameter, the value of the `HealthCHeckTimeout` parameter is ignored and the value of the `HealthCheckInterval` parameter is regarded as the timeout period.
 * @property healthyThreshold The number of health checks that an unhealthy backend server must pass consecutively before it is declared healthy. In this case, the health check state is changed from fail to success. Valid values: `2` to `10`. Default value: `3`.
 * @property unhealthyThreshold The number of consecutive health checks that a healthy backend server must consecutively fail before it is declared unhealthy. In this case, the health check state is changed from success to fail. Valid values: `2` to `10`. Default value: `3`.
 */
public data class GetServerGroupsGroupHealthCheckConfig(
    public val healthCheckCodes: List<String>,
    public val healthCheckConnectPort: Int,
    public val healthCheckEnabled: Boolean,
    public val healthCheckHost: String,
    public val healthCheckHttpVersion: String,
    public val healthCheckInterval: Int,
    public val healthCheckMethod: String,
    public val healthCheckPath: String,
    public val healthCheckProtocol: String,
    public val healthCheckTimeout: Int,
    public val healthyThreshold: Int,
    public val unhealthyThreshold: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetServerGroupsGroupHealthCheckConfig): GetServerGroupsGroupHealthCheckConfig = GetServerGroupsGroupHealthCheckConfig(
            healthCheckCodes = javaType.healthCheckCodes().map({ args0 -> args0 }),
            healthCheckConnectPort = javaType.healthCheckConnectPort(),
            healthCheckEnabled = javaType.healthCheckEnabled(),
            healthCheckHost = javaType.healthCheckHost(),
            healthCheckHttpVersion = javaType.healthCheckHttpVersion(),
            healthCheckInterval = javaType.healthCheckInterval(),
            healthCheckMethod = javaType.healthCheckMethod(),
            healthCheckPath = javaType.healthCheckPath(),
            healthCheckProtocol = javaType.healthCheckProtocol(),
            healthCheckTimeout = javaType.healthCheckTimeout(),
            healthyThreshold = javaType.healthyThreshold(),
            unhealthyThreshold = javaType.unhealthyThreshold(),
        )
    }
}
