@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the server.
 * @property port The port that is used by the server. Valid values: `1` to `65535`.
 * @property serverId The ID of the ECS instance, ENI instance or ECI instance.
 * @property serverIp The IP address of the ENI instance when it is in the inclusive ENI mode.
 * @property serverType The type of the server. The type of the server. Valid values: `Ecs`, `Eni` and `Eci`.
 * @property status The status of the resource.
 * @property weight The weight of the server.  Valid values: `0` to `100`. Default value: `100`. If the value is set to `0`, no requests are forwarded to the server.
 */
public data class GetServerGroupsGroupServer(
    public val description: String,
    public val port: Int,
    public val serverId: String,
    public val serverIp: String,
    public val serverType: String,
    public val status: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetServerGroupsGroupServer): GetServerGroupsGroupServer = GetServerGroupsGroupServer(
            description = javaType.description(),
            port = javaType.port(),
            serverId = javaType.serverId(),
            serverIp = javaType.serverIp(),
            serverType = javaType.serverType(),
            status = javaType.status(),
            weight = javaType.weight(),
        )
    }
}
