@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cookie the cookie that is configured on the server. **NOTE:** This parameter exists if the `StickySession` parameter is set to `On` and the `StickySessionType` parameter is set to `server`.
 * @property cookieTimeout The timeout period of a cookie. The timeout period of a cookie. Unit: seconds. Valid values: `1` to `86400`. Default value: `1000`.
 * @property stickySessionEnabled Indicates whether sticky session is enabled. Values: `true` and `false`. Default value: `false`.  **NOTE:** This parameter exists if the `StickySession` parameter is set to `On`.
 * @property stickySessionType The method that is used to handle a cookie. Values: `Server` and `Insert`.
 */
public data class GetServerGroupsGroupStickySessionConfig(
    public val cookie: String,
    public val cookieTimeout: Int,
    public val stickySessionEnabled: Boolean,
    public val stickySessionType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetServerGroupsGroupStickySessionConfig): GetServerGroupsGroupStickySessionConfig = GetServerGroupsGroupStickySessionConfig(
            cookie = javaType.cookie(),
            cookieTimeout = javaType.cookieTimeout(),
            stickySessionEnabled = javaType.stickySessionEnabled(),
            stickySessionType = javaType.stickySessionType(),
        )
    }
}
