@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getServerGroups.
 * @property enableDetails
 * @property groups A list of Alb Server Groups. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Server Group names.
 * @property outputFile
 * @property resourceGroupId
 * @property serverGroupIds
 * @property serverGroupName The name of the resource.
 * @property status The status of the resource. Valid values: `Provisioning`, `Available` and `Configuring`.
 * @property tags The tags of the resource.
 * @property vpcId The ID of the VPC that you want to access.
 */
public data class GetServerGroupsResult(
    public val enableDetails: Boolean? = null,
    public val groups: List<GetServerGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val serverGroupIds: List<String>? = null,
    public val serverGroupName: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetServerGroupsResult): GetServerGroupsResult = GetServerGroupsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetServerGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            serverGroupIds = javaType.serverGroupIds().map({ args0 -> args0 }),
            serverGroupName = javaType.serverGroupName().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
