@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ciphers The supported cipher suites, which are determined by the TLS protocol version.
 * @property id The ID of the Security Policy.
 * @property securityPolicyId The first ID of the resource.
 * @property tlsVersions The TLS protocol versions are supported. Valid values: TLSv1.0, TLSv1.1, TLSv1.2 and TLSv1.3.
 */
public data class GetSystemSecurityPoliciesPolicy(
    public val ciphers: List<String>,
    public val id: String,
    public val securityPolicyId: String,
    public val tlsVersions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetSystemSecurityPoliciesPolicy): GetSystemSecurityPoliciesPolicy = GetSystemSecurityPoliciesPolicy(
            ciphers = javaType.ciphers().map({ args0 -> args0 }),
            id = javaType.id(),
            securityPolicyId = javaType.securityPolicyId(),
            tlsVersions = javaType.tlsVersions().map({ args0 -> args0 }),
        )
    }
}
