@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSystemSecurityPolicies.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of System Security Policy IDs.
 * @property outputFile
 * @property policies A list of ALB Security Policies. Each element contains the following attributes:
 * @property tags
 */
public data class GetSystemSecurityPoliciesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val policies: List<GetSystemSecurityPoliciesPolicy>,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetSystemSecurityPoliciesResult): GetSystemSecurityPoliciesResult = GetSystemSecurityPoliciesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetSystemSecurityPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
