@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property tracingEnabled Xtrace Function. Value: `True` Or `False` . Default Value: `False`.
 * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `True`.
 * @property tracingSample Xtrace Sampling Rate. Value: `1` to `10000`.
 * > **NOTE:** This attribute is valid when `tracingenabled` is `true`.
 * @property tracingType Xtrace Type Value Is `Zipkin`.
 * > **NOTE:** This attribute is valid when `tracingenabled` is `true`.
 */
public data class ListenerAccessLogTracingConfig(
    public val tracingEnabled: Boolean? = null,
    public val tracingSample: Int? = null,
    public val tracingType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.ListenerAccessLogTracingConfig): ListenerAccessLogTracingConfig = ListenerAccessLogTracingConfig(
            tracingEnabled = javaType.tracingEnabled().map({ args0 -> args0 }).orElse(null),
            tracingSample = javaType.tracingSample().map({ args0 -> args0 }).orElse(null),
            tracingType = javaType.tracingType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
