@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property quicListenerId There Is a Need to Correlate the QuIC Listener ID. The Https Listener, in Effect at the Time. quicupgradeenabled True When Required.
 * @property quicUpgradeEnabled Indicates Whether to Enable the QuIC Upgrade.
 * > **NOTE:** The attribute is valid when the attribute `ListenerProtocol` is `HTTPS`.
 */
public data class ListenerQuicConfig(
    public val quicListenerId: String? = null,
    public val quicUpgradeEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.ListenerQuicConfig): ListenerQuicConfig = ListenerQuicConfig(
            quicListenerId = javaType.quicListenerId().map({ args0 -> args0 }).orElse(null),
            quicUpgradeEnabled = javaType.quicUpgradeEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
