@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property xForwardedForClientCertClientVerifyAlias The Custom Header Field Names Only When `x_forwarded_for_client_cert_client_verify_enabled` Has a Value of True, this Value Will Not Take Effect until.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
 * @property xForwardedForClientCertClientVerifyEnabled Indicates Whether the `X-Forwarded-Clientcert-clientverify` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate to Verify the Results.
 * @property xForwardedForClientCertFingerPrintAlias The Custom Header Field Names Only When `x_forwarded_for_client_certfingerprint_enabled`, Which Evaluates to True When the Entry into Force of.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
 * @property xForwardedForClientCertFingerPrintEnabled Indicates Whether the `X-Forwarded-client_cert-fingerprint` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate Fingerprint Value.
 * @property xForwardedForClientCertIssuerDnAlias The Custom Header Field Names Only When `x_forwarded_for_client_cert_issuer_dn_enabled`, Which Evaluates to True When the Entry into Force of.
 * @property xForwardedForClientCertIssuerDnEnabled Indicates Whether the `X-Forwarded-Clientcert-issuerdn` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate after the Manifests Are Signed, the Publisher Information.
 * @property xForwardedForClientCertSubjectDnAlias The name of the custom header. This parameter is valid only if `x_forwarded_for_client_certsubjectdn_enabled` is set to true. The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
 * @property xForwardedForClientCertSubjectDnEnabled Specifies whether to use the `X-Forwarded-client_cert-subjectdn` header field to obtain information about the owner of the ALB client certificate. Valid values: true and false. Default value: false.
 * @property xForwardedForClientSourceIpsEnabled Whether to use the X-Forwarded-Client-Ip header to obtain the source IP address of the server load balancer instance. Value: true, false. Note HTTP, HTTPS, and QUIC listeners support this parameter. The function corresponding to this parameter is not open by default. Please contact the account manager if you need to use it.
 * @property xForwardedForClientSourceIpsTrusted Specify the trusted proxy IP. Application-oriented load balancing ALB will traverse the X-Forwarded-For from back to front, and select the first IP that is not in the trusted IP list as the real client IP, which will be used for the source IP speed limit.
 * @property xForwardedForClientSrcPortEnabled Indicates Whether the X-Forwarded-Client-Port Header Field Is Used to Obtain Access to Server Load Balancer Instances to the Client, and Those of the Ports.
 * @property xForwardedForEnabled Whether to Enable by X-Forwarded-For Header Field Is Used to Obtain the Client IP Addresses.
 * @property xForwardedForProtoEnabled Indicates Whether the X-Forwarded-Proto Header Field Is Used to Obtain the Server Load Balancer Instance Snooping Protocols.
 * @property xForwardedForSlbIdEnabled Indicates Whether the SLB-ID Header Field Is Used to Obtain the Load Balancing Instance Id.
 * @property xForwardedForSlbPortEnabled Indicates Whether the X-Forwarded-Port Header Field Is Used to Obtain the Server Load Balancer Instance Listening Port.
 */
public data class ListenerXForwardedForConfig(
    public val xForwardedForClientCertClientVerifyAlias: String? = null,
    public val xForwardedForClientCertClientVerifyEnabled: Boolean? = null,
    public val xForwardedForClientCertFingerPrintAlias: String? = null,
    public val xForwardedForClientCertFingerPrintEnabled: Boolean? = null,
    public val xForwardedForClientCertIssuerDnAlias: String? = null,
    public val xForwardedForClientCertIssuerDnEnabled: Boolean? = null,
    public val xForwardedForClientCertSubjectDnAlias: String? = null,
    public val xForwardedForClientCertSubjectDnEnabled: Boolean? = null,
    public val xForwardedForClientSourceIpsEnabled: Boolean? = null,
    public val xForwardedForClientSourceIpsTrusted: String? = null,
    public val xForwardedForClientSrcPortEnabled: Boolean? = null,
    public val xForwardedForEnabled: Boolean? = null,
    public val xForwardedForProtoEnabled: Boolean? = null,
    public val xForwardedForSlbIdEnabled: Boolean? = null,
    public val xForwardedForSlbPortEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.ListenerXForwardedForConfig): ListenerXForwardedForConfig = ListenerXForwardedForConfig(
            xForwardedForClientCertClientVerifyAlias = javaType.xForwardedForClientCertClientVerifyAlias().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientCertClientVerifyEnabled = javaType.xForwardedForClientCertClientVerifyEnabled().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientCertFingerPrintAlias = javaType.xForwardedForClientCertFingerPrintAlias().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientCertFingerPrintEnabled = javaType.xForwardedForClientCertFingerPrintEnabled().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientCertIssuerDnAlias = javaType.xForwardedForClientCertIssuerDnAlias().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientCertIssuerDnEnabled = javaType.xForwardedForClientCertIssuerDnEnabled().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientCertSubjectDnAlias = javaType.xForwardedForClientCertSubjectDnAlias().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientCertSubjectDnEnabled = javaType.xForwardedForClientCertSubjectDnEnabled().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientSourceIpsEnabled = javaType.xForwardedForClientSourceIpsEnabled().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientSourceIpsTrusted = javaType.xForwardedForClientSourceIpsTrusted().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForClientSrcPortEnabled = javaType.xForwardedForClientSrcPortEnabled().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForEnabled = javaType.xForwardedForEnabled().map({ args0 -> args0 }).orElse(null),
            xForwardedForProtoEnabled = javaType.xForwardedForProtoEnabled().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForSlbIdEnabled = javaType.xForwardedForSlbIdEnabled().map({ args0 ->
                args0
            }).orElse(null),
            xForwardedForSlbPortEnabled = javaType.xForwardedForSlbPortEnabled().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
