@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property logProject The project to which the access log is shipped.
 * @property logStore The Logstore to which the access log is shipped.
 */
public data class LoadBalancerAccessLogConfig(
    public val logProject: String,
    public val logStore: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.LoadBalancerAccessLogConfig): LoadBalancerAccessLogConfig = LoadBalancerAccessLogConfig(
            logProject = javaType.logProject(),
            logStore = javaType.logStore(),
        )
    }
}
