@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property reason The reason for enabling the configuration read-only mode. **NOTE:** `reason` takes effect only if `status` is set to `ConsoleProtection`.
 * @property status Specifies whether to enable the configuration read-only mode. Valid values: `ConsoleProtection`, `NonProtection`.
 */
public data class LoadBalancerModificationProtectionConfig(
    public val reason: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.LoadBalancerModificationProtectionConfig): LoadBalancerModificationProtectionConfig = LoadBalancerModificationProtectionConfig(
            reason = javaType.reason().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
