@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property loadBalancerAddresses The IP address of the ALB instance.
 * @property vswitchId The ID of the VSwitch.
 * @property zoneId The zone ID of the ALB instance.
 */
public data class LoadBalancerZoneMapping(
    public val loadBalancerAddresses: List<LoadBalancerZoneMappingLoadBalancerAddress>? = null,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.LoadBalancerZoneMapping): LoadBalancerZoneMapping = LoadBalancerZoneMapping(
            loadBalancerAddresses = javaType.loadBalancerAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.LoadBalancerZoneMappingLoadBalancerAddress.Companion.toKotlin(args0)
                })
            }),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
