@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address IP address. The Public IP Address, and Private IP Address from the Address Type.
 * @property allocationId The ID of the EIP.
 * @property eipType The type of the EIP.
 * @property ipv6Address Ipv6 address.
 */
public data class LoadBalancerZoneMappingLoadBalancerAddress(
    public val address: String? = null,
    public val allocationId: String? = null,
    public val eipType: String? = null,
    public val ipv6Address: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.LoadBalancerZoneMappingLoadBalancerAddress): LoadBalancerZoneMappingLoadBalancerAddress = LoadBalancerZoneMappingLoadBalancerAddress(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            allocationId = javaType.allocationId().map({ args0 -> args0 }).orElse(null),
            eipType = javaType.eipType().map({ args0 -> args0 }).orElse(null),
            ipv6Address = javaType.ipv6Address().map({ args0 -> args0 }).orElse(null),
        )
    }
}
