@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property corsConfig Request forwarding based on CORS. See `cors_config` below.
 * @property fixedResponseConfig The configuration of the fixed response. See `fixed_response_config` below.
 * @property forwardGroupConfig The forward response action within ALB. See `forward_group_config` below.
 * @property insertHeaderConfig The configuration of the inserted header field. See `insert_header_config` below.
 * @property order The order of the forwarding rule actions. Valid values: `1` to `50000`. The actions are performed in ascending order. You cannot leave this parameter empty. Each value must be unique.
 * @property redirectConfig The configuration of the external redirect action. See `redirect_config` below.
 * @property removeHeaderConfig The configuration of the inserted header field. See `remove_header_config` below.
 * @property rewriteConfig The redirect action within ALB. See `rewrite_config` below.
 * @property trafficLimitConfig The Flow speed limit. See `traffic_limit_config` below.
 * @property trafficMirrorConfig The Traffic mirroring. See `traffic_mirror_config` below.
 * @property type The action type. Valid values: `ForwardGroup`, `Redirect`, `FixedResponse`, `Rewrite`, `InsertHeader`, `RemoveHeader`, `TrafficLimit`, `TrafficMirror` and `Cors`.
 * **Note:** The preceding actions can be classified into two types:  `FinalType`: A forwarding rule can contain only one `FinalType` action, which is executed last. This type of action can contain only one `ForwardGroup`, `Redirect` or `FixedResponse` action. `ExtType`: A forwarding rule can contain one or more `ExtType` actions, which are executed before `FinalType` actions and need to coexist with the `FinalType` actions. This type of action can contain multiple `InsertHeader` actions or one `Rewrite` action.
 * **NOTE:** The `TrafficLimit` and `TrafficMirror` option is available since 1.162.0.
 * **NOTE:** From version 1.205.0, `type` can be set to `Cors`.
 */
public data class RuleRuleAction(
    public val corsConfig: RuleRuleActionCorsConfig? = null,
    public val fixedResponseConfig: RuleRuleActionFixedResponseConfig? = null,
    public val forwardGroupConfig: RuleRuleActionForwardGroupConfig? = null,
    public val insertHeaderConfig: RuleRuleActionInsertHeaderConfig? = null,
    public val order: Int,
    public val redirectConfig: RuleRuleActionRedirectConfig? = null,
    public val removeHeaderConfig: RuleRuleActionRemoveHeaderConfig? = null,
    public val rewriteConfig: RuleRuleActionRewriteConfig? = null,
    public val trafficLimitConfig: RuleRuleActionTrafficLimitConfig? = null,
    public val trafficMirrorConfig: RuleRuleActionTrafficMirrorConfig? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.RuleRuleAction): RuleRuleAction =
            RuleRuleAction(
                corsConfig = javaType.corsConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleActionCorsConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                fixedResponseConfig = javaType.fixedResponseConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleActionFixedResponseConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                forwardGroupConfig = javaType.forwardGroupConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleActionForwardGroupConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                insertHeaderConfig = javaType.insertHeaderConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleActionInsertHeaderConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                order = javaType.order(),
                redirectConfig = javaType.redirectConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleActionRedirectConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                removeHeaderConfig = javaType.removeHeaderConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleActionRemoveHeaderConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                rewriteConfig = javaType.rewriteConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleActionRewriteConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                trafficLimitConfig = javaType.trafficLimitConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleActionTrafficLimitConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                trafficMirrorConfig = javaType.trafficMirrorConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleActionTrafficMirrorConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
            )
    }
}
