@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowCredentials Specifies whether credentials can be passed during CORS operations. Valid values: `on`, `off`.
 * @property allowHeaders The allowed headers for CORS requests.
 * @property allowMethods The allowed HTTP methods for CORS requests. Valid values: `GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `PATCH`.
 * @property allowOrigins The allowed origins of CORS requests.
 * @property exposeHeaders The headers that can be exposed.
 * @property maxAge The maximum cache time of preflight requests in the browser. Unit: seconds. Valid values: `-1` to `172800`.
 */
public data class RuleRuleActionCorsConfig(
    public val allowCredentials: String? = null,
    public val allowHeaders: List<String>? = null,
    public val allowMethods: List<String>? = null,
    public val allowOrigins: List<String>? = null,
    public val exposeHeaders: List<String>? = null,
    public val maxAge: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.RuleRuleActionCorsConfig): RuleRuleActionCorsConfig = RuleRuleActionCorsConfig(
            allowCredentials = javaType.allowCredentials().map({ args0 -> args0 }).orElse(null),
            allowHeaders = javaType.allowHeaders().map({ args0 -> args0 }),
            allowMethods = javaType.allowMethods().map({ args0 -> args0 }),
            allowOrigins = javaType.allowOrigins().map({ args0 -> args0 }),
            exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
            maxAge = javaType.maxAge().map({ args0 -> args0 }).orElse(null),
        )
    }
}
