@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The fixed response. The response cannot exceed 1 KB in size and can contain only ASCII characters.
 * @property contentType The format of the fixed response. Valid values: `text/plain`, `text/css`, `text/html`, `application/javascript`, and `application/json`.
 * @property httpCode The redirect method. Valid values: `301`, `302`, `303`, `307`, and `308`.
 */
public data class RuleRuleActionFixedResponseConfig(
    public val content: String,
    public val contentType: String? = null,
    public val httpCode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.RuleRuleActionFixedResponseConfig): RuleRuleActionFixedResponseConfig = RuleRuleActionFixedResponseConfig(
            content = javaType.content(),
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            httpCode = javaType.httpCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
