@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property serverGroupId The ID of the destination server group to which requests are forwarded.
 * @property weight The Weight of server group. Default value: `100`. **NOTE:** This attribute is required when the number of `server_group_tuples` is greater than 2.
 */
public data class RuleRuleActionForwardGroupConfigServerGroupTuple(
    public val serverGroupId: String? = null,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.RuleRuleActionForwardGroupConfigServerGroupTuple): RuleRuleActionForwardGroupConfigServerGroupTuple =
            RuleRuleActionForwardGroupConfigServerGroupTuple(
                serverGroupId = javaType.serverGroupId().map({ args0 -> args0 }).orElse(null),
                weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
            )
    }
}
