@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key
 * @property value
 * @property valueType The value type of the inserted header field. Valid values:
 * - `UserDefined`: a custom value
 * - `ReferenceHeader`: uses a field of the user request header.
 * - `SystemDefined`: a system value.
 */
public data class RuleRuleActionInsertHeaderConfig(
    public val key: String? = null,
    public val `value`: String? = null,
    public val valueType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.RuleRuleActionInsertHeaderConfig): RuleRuleActionInsertHeaderConfig = RuleRuleActionInsertHeaderConfig(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            valueType = javaType.valueType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
