@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property host The host name of the destination to which requests are redirected within ALB. Valid values:  The host name must be 3 to 128 characters in length, and can contain letters, digits, hyphens (-), periods (.), asterisks (*), and question marks (?). The host name must contain at least one period (.), and cannot start or end with a period (.). The rightmost domain label can contain only letters, asterisks (*) and question marks (?) and cannot contain digits or hyphens (-). Other domain labels cannot start or end with a hyphen (-). You can include asterisks (*) and question marks (?) anywhere in a domain label. Default value: ${host}. You cannot use this value with other characters at the same time.
 * @property httpCode The redirect method. Valid values: `301`, `302`, `303`, `307`, and `308`.
 * @property path The path to which requests are to be redirected within ALB. Valid values: The path must be 1 to 128 characters in length, and start with a forward slash (/). The path can contain letters, digits, asterisks (*), question marks (?)and the following special characters: $ - _ . + / & ~ @ :. It cannot contain the following special characters: " % # ; ! ( ) [ ] ^ , ”. The path is case-sensitive. Default value: ${path}. This value can be used only once. You can use it with a valid string.
 * @property port The port of the destination to which requests are redirected. Valid values: 1 to 63335. Default value: ${port}. You cannot use this value together with other characters at the same time.
 * @property protocol The protocol of the requests to be redirected. Valid values: `HTTP` and `HTTPS`. Default value: `${protocol}`. You cannot use this value together with other characters at the same time. Note HTTPS listeners can redirect only HTTPS requests.
 * @property query The query string of the request to be redirected within ALB. The query string must be 1 to 128 characters in length, can contain letters and printable characters. It cannot contain the following special characters: # [ ] { } \ | < > &. Default value: ${query}. This value can be used only once. You can use it with a valid string.
 */
public data class RuleRuleActionRedirectConfig(
    public val host: String? = null,
    public val httpCode: String? = null,
    public val path: String? = null,
    public val port: String? = null,
    public val protocol: String? = null,
    public val query: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.RuleRuleActionRedirectConfig): RuleRuleActionRedirectConfig = RuleRuleActionRedirectConfig(
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            httpCode = javaType.httpCode().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            query = javaType.query().map({ args0 -> args0 }).orElse(null),
        )
    }
}
