@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property perIpQps The number of requests per second for a single IP address. Value range: 1~1000000. Note: If the QPS parameter is also configured, the value of the PerIpQps parameter must be smaller than the value of the QPS parameter.
 * @property qps The Number of requests per second. Valid values: `1` to `100000`.
 */
public data class RuleRuleActionTrafficLimitConfig(
    public val perIpQps: Int? = null,
    public val qps: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.RuleRuleActionTrafficLimitConfig): RuleRuleActionTrafficLimitConfig = RuleRuleActionTrafficLimitConfig(
            perIpQps = javaType.perIpQps().map({ args0 -> args0 }).orElse(null),
            qps = javaType.qps().map({ args0 -> args0 }).orElse(null),
        )
    }
}
