@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cookieConfig The configuration of the cookie. See See `cookie_config` below.
 * @property headerConfig The configuration of the header field. See `header_config` below.
 * @property hostConfig The configuration of the host field. See `host_config` below.
 * @property methodConfig The configuration of the request method. See `method_config` below.
 * @property pathConfig The configuration of the path for the request to be forwarded. See `path_config` below.
 * @property queryStringConfig The configuration of the query string. See `query_string_config` below.
 * @property responseHeaderConfig The configuration of the header field. See `response_header_config` below.
 * @property responseStatusCodeConfig The configuration of the header field. See `response_status_code_config` below.
 * @property sourceIpConfig The Based on source IP traffic matching. Required and valid when Type is SourceIP. See `source_ip_config` below.
 * @property type The type of the forwarding rule. Valid values:
 * - `Host`: Requests are forwarded based on hosts.
 * - `Path`: Requests are forwarded based on the path.
 * - `Header`: Requests are forwarded based on the HTTP header field.
 * - `QueryString`: Requests are forwarded based on the query string.
 * - `Method`: Request are forwarded based on the request method.
 * - `Cookie`: Requests are forwarded based on the cookie.
 * - `SourceIp`: Requests are forwarded based on the source ip. **NOTE:** The `SourceIp` option is available since 1.162.0.
 * - `ResponseHeader`: Response header. **NOTE:** The `SourceIp` option is available since 1.213.1.
 * - `ResponseStatusCode`: Response status code. **NOTE:** The `SourceIp` option is available since 1.213.1.
 */
public data class RuleRuleCondition(
    public val cookieConfig: RuleRuleConditionCookieConfig? = null,
    public val headerConfig: RuleRuleConditionHeaderConfig? = null,
    public val hostConfig: RuleRuleConditionHostConfig? = null,
    public val methodConfig: RuleRuleConditionMethodConfig? = null,
    public val pathConfig: RuleRuleConditionPathConfig? = null,
    public val queryStringConfig: RuleRuleConditionQueryStringConfig? = null,
    public val responseHeaderConfig: RuleRuleConditionResponseHeaderConfig? = null,
    public val responseStatusCodeConfig: RuleRuleConditionResponseStatusCodeConfig? = null,
    public val sourceIpConfig: RuleRuleConditionSourceIpConfig? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.RuleRuleCondition): RuleRuleCondition = RuleRuleCondition(
            cookieConfig = javaType.cookieConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleConditionCookieConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            headerConfig = javaType.headerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleConditionHeaderConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostConfig = javaType.hostConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleConditionHostConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            methodConfig = javaType.methodConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleConditionMethodConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            pathConfig = javaType.pathConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleConditionPathConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queryStringConfig = javaType.queryStringConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleConditionQueryStringConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            responseHeaderConfig = javaType.responseHeaderConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleConditionResponseHeaderConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            responseStatusCodeConfig = javaType.responseStatusCodeConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleConditionResponseStatusCodeConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceIpConfig = javaType.sourceIpConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleConditionSourceIpConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
