@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property healthCheckCodes The HTTP status codes that are used to indicate whether the backend server passes the health check. Valid values:
 * - If `health_check_protocol` is set to `HTTP` or `HTTPS`. Valid values: `http_2xx`, `http_3xx`, `http_4xx`, and `http_5xx`. Default value: `http_2xx`.
 * - If `health_check_protocol` is set to `gRPC`. Valid values: `0` to `99`. Default value: `0`.
 * @property healthCheckConnectPort The backend port that is used for health checks. Default value: `0`. Valid values: `0` to `65535`. A value of 0 indicates that a backend server port is used for health checks.
 * @property healthCheckEnabled Specifies whether to enable the health check feature. Valid values: `true`, `false`.
 * @property healthCheckHost The domain name that is used for health checks.
 * @property healthCheckHttpVersion The version of the HTTP protocol. Default value: `HTTP1.1`. Valid values: `HTTP1.0` and `HTTP1.1`. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP` or `HTTPS`.
 * @property healthCheckInterval The interval at which health checks are performed. Unit: seconds. Default value: `2`. Valid values: `1` to `50`.
 * @property healthCheckMethod The HTTP method that is used for health checks. Default value: `GET`. Valid values: `GET`, `POST`, `HEAD`. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP`, `HTTPS`, or `gRPC`. From version 1.215.0, `health_check_method` can be set to `POST`.
 * @property healthCheckPath The path that is used for health checks. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP` or `HTTPS`.
 * @property healthCheckProtocol The protocol that is used for health checks. Valid values: `HTTP`, `HTTPS`, `TCP` and `gRPC`.
 * @property healthCheckTimeout The timeout period for a health check response. If a backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the ECS instance is considered unhealthy. Unit: seconds. Default value: `5`. Valid values: `1` to `300`. **NOTE:** If the value of `health_check_timeout` is smaller than the value of `health_check_interval`, the value of `health_check_timeout` is ignored and the value of `health_check_interval` is used.
 * @property healthyThreshold The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. Default value: `3`. Valid values: `2` to `10`.
 * @property unhealthyThreshold The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. Default value: `3`. Valid values: `2` to `10`.
 */
public data class ServerGroupHealthCheckConfig(
    public val healthCheckCodes: List<String>? = null,
    public val healthCheckConnectPort: Int? = null,
    public val healthCheckEnabled: Boolean,
    public val healthCheckHost: String? = null,
    public val healthCheckHttpVersion: String? = null,
    public val healthCheckInterval: Int? = null,
    public val healthCheckMethod: String? = null,
    public val healthCheckPath: String? = null,
    public val healthCheckProtocol: String? = null,
    public val healthCheckTimeout: Int? = null,
    public val healthyThreshold: Int? = null,
    public val unhealthyThreshold: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.ServerGroupHealthCheckConfig): ServerGroupHealthCheckConfig = ServerGroupHealthCheckConfig(
            healthCheckCodes = javaType.healthCheckCodes().map({ args0 -> args0 }),
            healthCheckConnectPort = javaType.healthCheckConnectPort().map({ args0 -> args0 }).orElse(null),
            healthCheckEnabled = javaType.healthCheckEnabled(),
            healthCheckHost = javaType.healthCheckHost().map({ args0 -> args0 }).orElse(null),
            healthCheckHttpVersion = javaType.healthCheckHttpVersion().map({ args0 -> args0 }).orElse(null),
            healthCheckInterval = javaType.healthCheckInterval().map({ args0 -> args0 }).orElse(null),
            healthCheckMethod = javaType.healthCheckMethod().map({ args0 -> args0 }).orElse(null),
            healthCheckPath = javaType.healthCheckPath().map({ args0 -> args0 }).orElse(null),
            healthCheckProtocol = javaType.healthCheckProtocol().map({ args0 -> args0 }).orElse(null),
            healthCheckTimeout = javaType.healthCheckTimeout().map({ args0 -> args0 }).orElse(null),
            healthyThreshold = javaType.healthyThreshold().map({ args0 -> args0 }).orElse(null),
            unhealthyThreshold = javaType.unhealthyThreshold().map({ args0 -> args0 }).orElse(null),
        )
    }
}
