@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the backend server.
 * @property port The port used by the backend server. Valid values: `1` to `65535`. **Note:** This parameter is required if the `server_type` parameter is set to `Ecs`, `Eni`, `Eci`, or `Ip`. You do not need to configure this parameter if you set `server_type` to `Fc`.
 * @property remoteIpEnabled Specifies whether to enable the remote IP address feature. You can specify up to 40 servers in each call. **Note:** If `server_type` is set to `Ip`, this parameter is available.
 * @property serverId The ID of the backend server.
 * - If `server_group_type` is set to `Instance`, set the parameter to the ID of an Elastic Compute Service (ECS) instance, an elastic network interface (ENI), or an elastic container instance. These backend servers are specified by Ecs, Eni, or Eci.
 * - If `server_group_type` is set to `Ip`, set the parameter to an IP address specified in the server group.
 * - If `server_group_type` is set to `Fc`, set the parameter to the Alibaba Cloud Resource Name (ARN) of a function specified in the server group.
 * @property serverIp The IP address of an Elastic Compute Service (ECS) instance, an elastic network interface (ENI), or an elastic container instance. **Note:** If `server_group_type` is set to `Fc`, you do not need to configure parameters, otherwise this attribute is required. If `server_group_type` is set to `Ip`, the value of this property is the same as the `server_id` value.
 * @property serverType The type of the server. The type of the server. Valid values:
 * - `Ecs`: an ECS instance.
 * - `Eni`: an ENI.
 * - `Eci`: an elastic container instance.
 * - `Ip`(Available since v1.194.0): an IP address.
 * - `Fc`(Available since v1.194.0): a function.
 * @property status The status of the backend server.
 * @property weight The weight of the server. Default value: `100`. Valid values: `0` to `100`. If the value is set to `0`, no requests are forwarded to the server. **Note:** You do not need to set this parameter if you set `server_type` to `Fc`.
 */
public data class ServerGroupServer(
    public val description: String? = null,
    public val port: Int? = null,
    public val remoteIpEnabled: Boolean? = null,
    public val serverId: String,
    public val serverIp: String? = null,
    public val serverType: String,
    public val status: String? = null,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.ServerGroupServer): ServerGroupServer = ServerGroupServer(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            remoteIpEnabled = javaType.remoteIpEnabled().map({ args0 -> args0 }).orElse(null),
            serverId = javaType.serverId(),
            serverIp = javaType.serverIp().map({ args0 -> args0 }).orElse(null),
            serverType = javaType.serverType(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
