@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cookie The cookie to be configured on the server. **NOTE:** This parameter takes effect when the `sticky_session_enabled` parameter is set to `true` and the `sticky_session_type` parameter is set to `Server`.
 * @property cookieTimeout The timeout period of a cookie. Unit: seconds. Default value: `1000`. Valid values: `1` to `86400`. **NOTE:** This parameter takes effect when the `sticky_session_enabled` parameter is set to `true` and the `sticky_session_type` parameter is set to `Insert`.
 * @property stickySessionEnabled Specifies whether to enable session persistence. Default value: `false`. Valid values: `true`, `false`. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
 * @property stickySessionType The method that is used to handle a cookie. Valid values: `Server`, `Insert`.
 */
public data class ServerGroupStickySessionConfig(
    public val cookie: String? = null,
    public val cookieTimeout: Int? = null,
    public val stickySessionEnabled: Boolean? = null,
    public val stickySessionType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.ServerGroupStickySessionConfig): ServerGroupStickySessionConfig = ServerGroupStickySessionConfig(
            cookie = javaType.cookie().map({ args0 -> args0 }).orElse(null),
            cookieTimeout = javaType.cookieTimeout().map({ args0 -> args0 }).orElse(null),
            stickySessionEnabled = javaType.stickySessionEnabled().map({ args0 -> args0 }).orElse(null),
            stickySessionType = javaType.stickySessionType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
