@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AuditCallback].
 */
@PulumiTagMarker
public class AuditCallbackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuditCallbackArgs = AuditCallbackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuditCallbackArgsBuilder.() -> Unit) {
        val builder = AuditCallbackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AuditCallback {
        val builtJavaResource = com.pulumi.alicloud.aligreen.AuditCallback(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AuditCallback(builtJavaResource)
    }
}

/**
 * Provides a Aligreen Audit Callback resource.
 * Callback notification after detection is completed.
 * For information about Aligreen Audit Callback and how to use it, see [What is Audit Callback](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const _default = new alicloud.aligreen.AuditCallback("default", {
 *     cryptType: "SM3",
 *     auditCallbackName: name,
 *     url: "https://www.aliyun.com/",
 *     callbackTypes: [
 *         "aliyunAudit",
 *         "selfAduit",
 *         "example",
 *     ],
 *     callbackSuggestions: [
 *         "block",
 *         "review",
 *         "pass",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.aligreen.AuditCallback("default",
 *     crypt_type="SM3",
 *     audit_callback_name=name,
 *     url="https://www.aliyun.com/",
 *     callback_types=[
 *         "aliyunAudit",
 *         "selfAduit",
 *         "example",
 *     ],
 *     callback_suggestions=[
 *         "block",
 *         "review",
 *         "pass",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = new AliCloud.Aligreen.AuditCallback("default", new()
 *     {
 *         CryptType = "SM3",
 *         AuditCallbackName = name,
 *         Url = "https://www.aliyun.com/",
 *         CallbackTypes = new[]
 *         {
 *             "aliyunAudit",
 *             "selfAduit",
 *             "example",
 *         },
 *         CallbackSuggestions = new[]
 *         {
 *             "block",
 *             "review",
 *             "pass",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/aligreen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := aligreen.NewAuditCallback(ctx, "default", &aligreen.AuditCallbackArgs{
 * 			CryptType:         pulumi.String("SM3"),
 * 			AuditCallbackName: pulumi.String(name),
 * 			Url:               pulumi.String("https://www.aliyun.com/"),
 * 			CallbackTypes: pulumi.StringArray{
 * 				pulumi.String("aliyunAudit"),
 * 				pulumi.String("selfAduit"),
 * 				pulumi.String("example"),
 * 			},
 * 			CallbackSuggestions: pulumi.StringArray{
 * 				pulumi.String("block"),
 * 				pulumi.String("review"),
 * 				pulumi.String("pass"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.aligreen.AuditCallback;
 * import com.pulumi.alicloud.aligreen.AuditCallbackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         var default_ = new AuditCallback("default", AuditCallbackArgs.builder()
 *             .cryptType("SM3")
 *             .auditCallbackName(name)
 *             .url("https://www.aliyun.com/")
 *             .callbackTypes(
 *                 "aliyunAudit",
 *                 "selfAduit",
 *                 "example")
 *             .callbackSuggestions(
 *                 "block",
 *                 "review",
 *                 "pass")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   default:
 *     type: alicloud:aligreen:AuditCallback
 *     properties:
 *       cryptType: SM3
 *       auditCallbackName: ${name}
 *       url: https://www.aliyun.com/
 *       callbackTypes:
 *         - aliyunAudit
 *         - selfAduit
 *         - example
 *       callbackSuggestions:
 *         - block
 *         - review
 *         - pass
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aligreen Audit Callback can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/auditCallback:AuditCallback example <id>
 * ```
 */
public class AuditCallback internal constructor(
    override val javaResource: com.pulumi.alicloud.aligreen.AuditCallback,
) : KotlinCustomResource(javaResource, AuditCallbackMapper) {
    /**
     * The AuditCallback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
     */
    public val auditCallbackName: Output<String>
        get() = javaResource.auditCallbackName().applyValue({ args0 -> args0 })

    /**
     * List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    public val callbackSuggestions: Output<List<String>>
        get() = javaResource.callbackSuggestions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    public val callbackTypes: Output<List<String>>
        get() = javaResource.callbackTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The encryption algorithm is used to verify that the callback request is sent by the content security service to your business service. The value is SHA256:SHA256 encryption algorithm and SM3: SM3 encryption algorithm.
     */
    public val cryptType: Output<String>
        get() = javaResource.cryptType().applyValue({ args0 -> args0 })

    /**
     * The detection result will be called back to the url.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object AuditCallbackMapper : ResourceMapper<AuditCallback> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.aligreen.AuditCallback::class == javaResource::class

    override fun map(javaResource: Resource): AuditCallback = AuditCallback(
        javaResource as
            com.pulumi.alicloud.aligreen.AuditCallback,
    )
}

/**
 * @see [AuditCallback].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AuditCallback].
 */
public suspend fun auditCallback(
    name: String,
    block: suspend AuditCallbackResourceBuilder.() -> Unit,
): AuditCallback {
    val builder = AuditCallbackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AuditCallback].
 * @param name The _unique_ name of the resulting resource.
 */
public fun auditCallback(name: String): AuditCallback {
    val builder = AuditCallbackResourceBuilder()
    builder.name(name)
    return builder.build()
}
