@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.alicloud.aligreen.AuditCallbackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Aligreen Audit Callback resource.
 * Callback notification after detection is completed.
 * For information about Aligreen Audit Callback and how to use it, see [What is Audit Callback](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const _default = new alicloud.aligreen.AuditCallback("default", {
 *     cryptType: "SM3",
 *     auditCallbackName: name,
 *     url: "https://www.aliyun.com/",
 *     callbackTypes: [
 *         "aliyunAudit",
 *         "selfAduit",
 *         "example",
 *     ],
 *     callbackSuggestions: [
 *         "block",
 *         "review",
 *         "pass",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.aligreen.AuditCallback("default",
 *     crypt_type="SM3",
 *     audit_callback_name=name,
 *     url="https://www.aliyun.com/",
 *     callback_types=[
 *         "aliyunAudit",
 *         "selfAduit",
 *         "example",
 *     ],
 *     callback_suggestions=[
 *         "block",
 *         "review",
 *         "pass",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = new AliCloud.Aligreen.AuditCallback("default", new()
 *     {
 *         CryptType = "SM3",
 *         AuditCallbackName = name,
 *         Url = "https://www.aliyun.com/",
 *         CallbackTypes = new[]
 *         {
 *             "aliyunAudit",
 *             "selfAduit",
 *             "example",
 *         },
 *         CallbackSuggestions = new[]
 *         {
 *             "block",
 *             "review",
 *             "pass",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/aligreen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := aligreen.NewAuditCallback(ctx, "default", &aligreen.AuditCallbackArgs{
 * 			CryptType:         pulumi.String("SM3"),
 * 			AuditCallbackName: pulumi.String(name),
 * 			Url:               pulumi.String("https://www.aliyun.com/"),
 * 			CallbackTypes: pulumi.StringArray{
 * 				pulumi.String("aliyunAudit"),
 * 				pulumi.String("selfAduit"),
 * 				pulumi.String("example"),
 * 			},
 * 			CallbackSuggestions: pulumi.StringArray{
 * 				pulumi.String("block"),
 * 				pulumi.String("review"),
 * 				pulumi.String("pass"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.aligreen.AuditCallback;
 * import com.pulumi.alicloud.aligreen.AuditCallbackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         var default_ = new AuditCallback("default", AuditCallbackArgs.builder()
 *             .cryptType("SM3")
 *             .auditCallbackName(name)
 *             .url("https://www.aliyun.com/")
 *             .callbackTypes(
 *                 "aliyunAudit",
 *                 "selfAduit",
 *                 "example")
 *             .callbackSuggestions(
 *                 "block",
 *                 "review",
 *                 "pass")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   default:
 *     type: alicloud:aligreen:AuditCallback
 *     properties:
 *       cryptType: SM3
 *       auditCallbackName: ${name}
 *       url: https://www.aliyun.com/
 *       callbackTypes:
 *         - aliyunAudit
 *         - selfAduit
 *         - example
 *       callbackSuggestions:
 *         - block
 *         - review
 *         - pass
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aligreen Audit Callback can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/auditCallback:AuditCallback example <id>
 * ```
 * @property auditCallbackName The AuditCallback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
 * @property callbackSuggestions List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
 * @property callbackTypes A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
 * @property cryptType The encryption algorithm is used to verify that the callback request is sent by the content security service to your business service. The value is SHA256:SHA256 encryption algorithm and SM3: SM3 encryption algorithm.
 * @property url The detection result will be called back to the url.
 */
public data class AuditCallbackArgs(
    public val auditCallbackName: Output<String>? = null,
    public val callbackSuggestions: Output<List<String>>? = null,
    public val callbackTypes: Output<List<String>>? = null,
    public val cryptType: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.aligreen.AuditCallbackArgs> {
    override fun toJava(): com.pulumi.alicloud.aligreen.AuditCallbackArgs =
        com.pulumi.alicloud.aligreen.AuditCallbackArgs.builder()
            .auditCallbackName(auditCallbackName?.applyValue({ args0 -> args0 }))
            .callbackSuggestions(callbackSuggestions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .callbackTypes(callbackTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cryptType(cryptType?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuditCallbackArgs].
 */
@PulumiTagMarker
public class AuditCallbackArgsBuilder internal constructor() {
    private var auditCallbackName: Output<String>? = null

    private var callbackSuggestions: Output<List<String>>? = null

    private var callbackTypes: Output<List<String>>? = null

    private var cryptType: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value The AuditCallback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
     */
    @JvmName("jckdawxfbmsyptmg")
    public suspend fun auditCallbackName(`value`: Output<String>) {
        this.auditCallbackName = value
    }

    /**
     * @param value List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    @JvmName("oogwahcjrmcuyius")
    public suspend fun callbackSuggestions(`value`: Output<List<String>>) {
        this.callbackSuggestions = value
    }

    @JvmName("bfsltopclawuaobk")
    public suspend fun callbackSuggestions(vararg values: Output<String>) {
        this.callbackSuggestions = Output.all(values.asList())
    }

    /**
     * @param values List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    @JvmName("prowmsgijmvqmonq")
    public suspend fun callbackSuggestions(values: List<Output<String>>) {
        this.callbackSuggestions = Output.all(values)
    }

    /**
     * @param value A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    @JvmName("lnytyainiakxgcte")
    public suspend fun callbackTypes(`value`: Output<List<String>>) {
        this.callbackTypes = value
    }

    @JvmName("aplbgmhranfosdhj")
    public suspend fun callbackTypes(vararg values: Output<String>) {
        this.callbackTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    @JvmName("kleddxyktinabnay")
    public suspend fun callbackTypes(values: List<Output<String>>) {
        this.callbackTypes = Output.all(values)
    }

    /**
     * @param value The encryption algorithm is used to verify that the callback request is sent by the content security service to your business service. The value is SHA256:SHA256 encryption algorithm and SM3: SM3 encryption algorithm.
     */
    @JvmName("wecixgjjpyoycaje")
    public suspend fun cryptType(`value`: Output<String>) {
        this.cryptType = value
    }

    /**
     * @param value The detection result will be called back to the url.
     */
    @JvmName("xwlfyhbttghwuedw")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The AuditCallback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
     */
    @JvmName("mmyhlmebklbsfbhe")
    public suspend fun auditCallbackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditCallbackName = mapped
    }

    /**
     * @param value List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    @JvmName("ynhkibhdvswnxbqd")
    public suspend fun callbackSuggestions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callbackSuggestions = mapped
    }

    /**
     * @param values List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    @JvmName("ydgxjfxqfrmgvjrg")
    public suspend fun callbackSuggestions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callbackSuggestions = mapped
    }

    /**
     * @param value A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    @JvmName("rihrtvsrjdncclyq")
    public suspend fun callbackTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callbackTypes = mapped
    }

    /**
     * @param values A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    @JvmName("ulikrxhkrfvfdjan")
    public suspend fun callbackTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callbackTypes = mapped
    }

    /**
     * @param value The encryption algorithm is used to verify that the callback request is sent by the content security service to your business service. The value is SHA256:SHA256 encryption algorithm and SM3: SM3 encryption algorithm.
     */
    @JvmName("hmojccfknptakqnp")
    public suspend fun cryptType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cryptType = mapped
    }

    /**
     * @param value The detection result will be called back to the url.
     */
    @JvmName("bpndpuqpibolsxji")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): AuditCallbackArgs = AuditCallbackArgs(
        auditCallbackName = auditCallbackName,
        callbackSuggestions = callbackSuggestions,
        callbackTypes = callbackTypes,
        cryptType = cryptType,
        url = url,
    )
}
