@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.alicloud.aligreen.BizTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Aligreen Biz Type resource.
 * For information about Aligreen Biz Type and how to use it, see [What is Biz Type](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const _default = new alicloud.aligreen.BizType("default", {
 *     bizTypeName: name,
 *     description: name,
 *     citeTemplate: true,
 *     industryInfo: "社交-注册信息-昵称",
 *     bizTypeImport: "1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.aligreen.BizType("default",
 *     biz_type_name=name,
 *     description=name,
 *     cite_template=True,
 *     industry_info="社交-注册信息-昵称",
 *     biz_type_import="1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = new AliCloud.Aligreen.BizType("default", new()
 *     {
 *         BizTypeName = name,
 *         Description = name,
 *         CiteTemplate = true,
 *         IndustryInfo = "社交-注册信息-昵称",
 *         BizTypeImport = "1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/aligreen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := aligreen.NewBizType(ctx, "default", &aligreen.BizTypeArgs{
 * 			BizTypeName:   pulumi.String(name),
 * 			Description:   pulumi.String(name),
 * 			CiteTemplate:  pulumi.Bool(true),
 * 			IndustryInfo:  pulumi.String("社交-注册信息-昵称"),
 * 			BizTypeImport: pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.aligreen.BizType;
 * import com.pulumi.alicloud.aligreen.BizTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         var default_ = new BizType("default", BizTypeArgs.builder()
 *             .bizTypeName(name)
 *             .description(name)
 *             .citeTemplate(true)
 *             .industryInfo("社交-注册信息-昵称")
 *             .bizTypeImport("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   default:
 *     type: alicloud:aligreen:BizType
 *     properties:
 *       bizTypeName: ${name}
 *       description: ${name}
 *       citeTemplate: true
 *       industryInfo: 社交-注册信息-昵称
 *       bizTypeImport: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aligreen Biz Type can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/bizType:BizType example <id>
 * ```
 * @property bizTypeImport The name of the existing business scenario that was imported from when the business scenario was created.
 * @property bizTypeName The name of the business scenario defined by the customer. It can contain no more than 32 characters in English, numbers, and underscores.
 * @property citeTemplate Specifies whether to import the configuration of an industry template. Default value: false. Valid values: true: imports the configuration of an industry template. false: does not import the configuration of an industry template. If the value is true, you must specify the industryInfo parameter.
 * @property description The description of the business scenario defined by the customer, which is a combination of Chinese and English, numbers, and underscores, and cannot exceed 32 characters.
 * @property industryInfo The industry classification. Valid values: Social-Registration information-Profile picture Social-Registration information-Nickname Social-Registration information-Bio Social-Instant messaging-Chat Social-Instant messaging-Group chat Social-Instant messaging-Chat room Social-Forums&Communities-Post Social-Forums&Communities-Comment Social-Forums&Communities-Tag Social-Forums&Communities-Recommendation Multimedia-Registration information-Profile picture Multimedia-Registration information-Nickname Multimedia-Registration information-Bio Multimedia-Instant messaging-Chat Multimedia-Live streaming-Heading Multimedia-Live streaming-Cover Multimedia-Live streaming-Content Multimedia-Live streaming-Comment Multimedia-Online storage-Storage content Multimedia-Online storage-Shared content Gaming-Registration information-Nickname Gaming-Registration information-Profile picture Gaming-Registration information-Signature Gaming-Instant messaging-Chat Gaming-Instant messaging-Group chat Gaming-Instant messaging-Chat room Gaming-Forums&Communities-Post Gaming-Forums&Communities-Comment Gaming-Forums&Communities-Tag Gaming-Forums&Communities-Recommendation New retail-Goods-Heading New retail-Goods-Description Reading-Books-Title Reading-Books-Heading Reading-Books-Cover Reading-Books-Content Media-News content-News content Education-Registration information-Nickname Education-Registration information-Profile picture Education-Registration information-Bio Gaming-Instant messaging-Chat Gaming-Forums&Communities-Post Education-Forums&Communities-Comment Education-Forums&Communities-Tag Education-Forums&Communities-Recommendation Education-Customer service-Voice call Others
 */
public data class BizTypeArgs(
    public val bizTypeImport: Output<String>? = null,
    public val bizTypeName: Output<String>? = null,
    public val citeTemplate: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val industryInfo: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.aligreen.BizTypeArgs> {
    override fun toJava(): com.pulumi.alicloud.aligreen.BizTypeArgs =
        com.pulumi.alicloud.aligreen.BizTypeArgs.builder()
            .bizTypeImport(bizTypeImport?.applyValue({ args0 -> args0 }))
            .bizTypeName(bizTypeName?.applyValue({ args0 -> args0 }))
            .citeTemplate(citeTemplate?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .industryInfo(industryInfo?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BizTypeArgs].
 */
@PulumiTagMarker
public class BizTypeArgsBuilder internal constructor() {
    private var bizTypeImport: Output<String>? = null

    private var bizTypeName: Output<String>? = null

    private var citeTemplate: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var industryInfo: Output<String>? = null

    /**
     * @param value The name of the existing business scenario that was imported from when the business scenario was created.
     */
    @JvmName("tnjfiqiontltxocc")
    public suspend fun bizTypeImport(`value`: Output<String>) {
        this.bizTypeImport = value
    }

    /**
     * @param value The name of the business scenario defined by the customer. It can contain no more than 32 characters in English, numbers, and underscores.
     */
    @JvmName("slfrjuypijhfkhmv")
    public suspend fun bizTypeName(`value`: Output<String>) {
        this.bizTypeName = value
    }

    /**
     * @param value Specifies whether to import the configuration of an industry template. Default value: false. Valid values: true: imports the configuration of an industry template. false: does not import the configuration of an industry template. If the value is true, you must specify the industryInfo parameter.
     */
    @JvmName("tjxdgkbiutaqadeh")
    public suspend fun citeTemplate(`value`: Output<Boolean>) {
        this.citeTemplate = value
    }

    /**
     * @param value The description of the business scenario defined by the customer, which is a combination of Chinese and English, numbers, and underscores, and cannot exceed 32 characters.
     */
    @JvmName("yggtrhjfymsyjgje")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The industry classification. Valid values: Social-Registration information-Profile picture Social-Registration information-Nickname Social-Registration information-Bio Social-Instant messaging-Chat Social-Instant messaging-Group chat Social-Instant messaging-Chat room Social-Forums&Communities-Post Social-Forums&Communities-Comment Social-Forums&Communities-Tag Social-Forums&Communities-Recommendation Multimedia-Registration information-Profile picture Multimedia-Registration information-Nickname Multimedia-Registration information-Bio Multimedia-Instant messaging-Chat Multimedia-Live streaming-Heading Multimedia-Live streaming-Cover Multimedia-Live streaming-Content Multimedia-Live streaming-Comment Multimedia-Online storage-Storage content Multimedia-Online storage-Shared content Gaming-Registration information-Nickname Gaming-Registration information-Profile picture Gaming-Registration information-Signature Gaming-Instant messaging-Chat Gaming-Instant messaging-Group chat Gaming-Instant messaging-Chat room Gaming-Forums&Communities-Post Gaming-Forums&Communities-Comment Gaming-Forums&Communities-Tag Gaming-Forums&Communities-Recommendation New retail-Goods-Heading New retail-Goods-Description Reading-Books-Title Reading-Books-Heading Reading-Books-Cover Reading-Books-Content Media-News content-News content Education-Registration information-Nickname Education-Registration information-Profile picture Education-Registration information-Bio Gaming-Instant messaging-Chat Gaming-Forums&Communities-Post Education-Forums&Communities-Comment Education-Forums&Communities-Tag Education-Forums&Communities-Recommendation Education-Customer service-Voice call Others
     */
    @JvmName("qaewwxkbnfwinqql")
    public suspend fun industryInfo(`value`: Output<String>) {
        this.industryInfo = value
    }

    /**
     * @param value The name of the existing business scenario that was imported from when the business scenario was created.
     */
    @JvmName("fnrjcjirqtopteop")
    public suspend fun bizTypeImport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizTypeImport = mapped
    }

    /**
     * @param value The name of the business scenario defined by the customer. It can contain no more than 32 characters in English, numbers, and underscores.
     */
    @JvmName("qxwymogploddgqfh")
    public suspend fun bizTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizTypeName = mapped
    }

    /**
     * @param value Specifies whether to import the configuration of an industry template. Default value: false. Valid values: true: imports the configuration of an industry template. false: does not import the configuration of an industry template. If the value is true, you must specify the industryInfo parameter.
     */
    @JvmName("dulnnwcgevtwkshl")
    public suspend fun citeTemplate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.citeTemplate = mapped
    }

    /**
     * @param value The description of the business scenario defined by the customer, which is a combination of Chinese and English, numbers, and underscores, and cannot exceed 32 characters.
     */
    @JvmName("vhxgfnhjfrwuwdhg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The industry classification. Valid values: Social-Registration information-Profile picture Social-Registration information-Nickname Social-Registration information-Bio Social-Instant messaging-Chat Social-Instant messaging-Group chat Social-Instant messaging-Chat room Social-Forums&Communities-Post Social-Forums&Communities-Comment Social-Forums&Communities-Tag Social-Forums&Communities-Recommendation Multimedia-Registration information-Profile picture Multimedia-Registration information-Nickname Multimedia-Registration information-Bio Multimedia-Instant messaging-Chat Multimedia-Live streaming-Heading Multimedia-Live streaming-Cover Multimedia-Live streaming-Content Multimedia-Live streaming-Comment Multimedia-Online storage-Storage content Multimedia-Online storage-Shared content Gaming-Registration information-Nickname Gaming-Registration information-Profile picture Gaming-Registration information-Signature Gaming-Instant messaging-Chat Gaming-Instant messaging-Group chat Gaming-Instant messaging-Chat room Gaming-Forums&Communities-Post Gaming-Forums&Communities-Comment Gaming-Forums&Communities-Tag Gaming-Forums&Communities-Recommendation New retail-Goods-Heading New retail-Goods-Description Reading-Books-Title Reading-Books-Heading Reading-Books-Cover Reading-Books-Content Media-News content-News content Education-Registration information-Nickname Education-Registration information-Profile picture Education-Registration information-Bio Gaming-Instant messaging-Chat Gaming-Forums&Communities-Post Education-Forums&Communities-Comment Education-Forums&Communities-Tag Education-Forums&Communities-Recommendation Education-Customer service-Voice call Others
     */
    @JvmName("siyrcafigwrhqrnp")
    public suspend fun industryInfo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.industryInfo = mapped
    }

    internal fun build(): BizTypeArgs = BizTypeArgs(
        bizTypeImport = bizTypeImport,
        bizTypeName = bizTypeName,
        citeTemplate = citeTemplate,
        description = description,
        industryInfo = industryInfo,
    )
}
