@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Callback].
 */
@PulumiTagMarker
public class CallbackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CallbackArgs = CallbackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CallbackArgsBuilder.() -> Unit) {
        val builder = CallbackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Callback {
        val builtJavaResource = com.pulumi.alicloud.aligreen.Callback(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Callback(builtJavaResource)
    }
}

/**
 * Provides a Aligreen Callback resource.
 * Detection Result Callback.
 * For information about Aligreen Callback and how to use it, see [What is Callback](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const _default = new alicloud.aligreen.Callback("default", {
 *     callbackUrl: "https://www.aliyun.com",
 *     cryptType: 0,
 *     callbackName: name,
 *     callbackTypes: [
 *         "machineScan",
 *         "selfAudit",
 *         "example",
 *     ],
 *     callbackSuggestions: [
 *         "block",
 *         "review",
 *         "pass",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.aligreen.Callback("default",
 *     callback_url="https://www.aliyun.com",
 *     crypt_type=0,
 *     callback_name=name,
 *     callback_types=[
 *         "machineScan",
 *         "selfAudit",
 *         "example",
 *     ],
 *     callback_suggestions=[
 *         "block",
 *         "review",
 *         "pass",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = new AliCloud.Aligreen.Callback("default", new()
 *     {
 *         CallbackUrl = "https://www.aliyun.com",
 *         CryptType = 0,
 *         CallbackName = name,
 *         CallbackTypes = new[]
 *         {
 *             "machineScan",
 *             "selfAudit",
 *             "example",
 *         },
 *         CallbackSuggestions = new[]
 *         {
 *             "block",
 *             "review",
 *             "pass",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/aligreen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := aligreen.NewCallback(ctx, "default", &aligreen.CallbackArgs{
 * 			CallbackUrl:  pulumi.String("https://www.aliyun.com"),
 * 			CryptType:    pulumi.Int(0),
 * 			CallbackName: pulumi.String(name),
 * 			CallbackTypes: pulumi.StringArray{
 * 				pulumi.String("machineScan"),
 * 				pulumi.String("selfAudit"),
 * 				pulumi.String("example"),
 * 			},
 * 			CallbackSuggestions: pulumi.StringArray{
 * 				pulumi.String("block"),
 * 				pulumi.String("review"),
 * 				pulumi.String("pass"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.aligreen.Callback;
 * import com.pulumi.alicloud.aligreen.CallbackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         var default_ = new Callback("default", CallbackArgs.builder()
 *             .callbackUrl("https://www.aliyun.com")
 *             .cryptType("0")
 *             .callbackName(name)
 *             .callbackTypes(
 *                 "machineScan",
 *                 "selfAudit",
 *                 "example")
 *             .callbackSuggestions(
 *                 "block",
 *                 "review",
 *                 "pass")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   default:
 *     type: alicloud:aligreen:Callback
 *     properties:
 *       callbackUrl: https://www.aliyun.com
 *       cryptType: '0'
 *       callbackName: ${name}
 *       callbackTypes:
 *         - machineScan
 *         - selfAudit
 *         - example
 *       callbackSuggestions:
 *         - block
 *         - review
 *         - pass
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aligreen Callback can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/callback:Callback example <id>
 * ```
 */
public class Callback internal constructor(
    override val javaResource: com.pulumi.alicloud.aligreen.Callback,
) : KotlinCustomResource(javaResource, CallbackMapper) {
    /**
     * The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
     */
    public val callbackName: Output<String>
        get() = javaResource.callbackName().applyValue({ args0 -> args0 })

    /**
     * List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    public val callbackSuggestions: Output<List<String>>
        get() = javaResource.callbackSuggestions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    public val callbackTypes: Output<List<String>>
        get() = javaResource.callbackTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The detection result will be called back to the url.
     */
    public val callbackUrl: Output<String>
        get() = javaResource.callbackUrl().applyValue({ args0 -> args0 })

    /**
     * The creation time of the Callback.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
     */
    public val cryptType: Output<Int>?
        get() = javaResource.cryptType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object CallbackMapper : ResourceMapper<Callback> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.aligreen.Callback::class == javaResource::class

    override fun map(javaResource: Resource): Callback = Callback(
        javaResource as
            com.pulumi.alicloud.aligreen.Callback,
    )
}

/**
 * @see [Callback].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Callback].
 */
public suspend fun callback(name: String, block: suspend CallbackResourceBuilder.() -> Unit): Callback {
    val builder = CallbackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Callback].
 * @param name The _unique_ name of the resulting resource.
 */
public fun callback(name: String): Callback {
    val builder = CallbackResourceBuilder()
    builder.name(name)
    return builder.build()
}
