@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.alicloud.aligreen.CallbackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Aligreen Callback resource.
 * Detection Result Callback.
 * For information about Aligreen Callback and how to use it, see [What is Callback](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const _default = new alicloud.aligreen.Callback("default", {
 *     callbackUrl: "https://www.aliyun.com",
 *     cryptType: 0,
 *     callbackName: name,
 *     callbackTypes: [
 *         "machineScan",
 *         "selfAudit",
 *         "example",
 *     ],
 *     callbackSuggestions: [
 *         "block",
 *         "review",
 *         "pass",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.aligreen.Callback("default",
 *     callback_url="https://www.aliyun.com",
 *     crypt_type=0,
 *     callback_name=name,
 *     callback_types=[
 *         "machineScan",
 *         "selfAudit",
 *         "example",
 *     ],
 *     callback_suggestions=[
 *         "block",
 *         "review",
 *         "pass",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = new AliCloud.Aligreen.Callback("default", new()
 *     {
 *         CallbackUrl = "https://www.aliyun.com",
 *         CryptType = 0,
 *         CallbackName = name,
 *         CallbackTypes = new[]
 *         {
 *             "machineScan",
 *             "selfAudit",
 *             "example",
 *         },
 *         CallbackSuggestions = new[]
 *         {
 *             "block",
 *             "review",
 *             "pass",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/aligreen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := aligreen.NewCallback(ctx, "default", &aligreen.CallbackArgs{
 * 			CallbackUrl:  pulumi.String("https://www.aliyun.com"),
 * 			CryptType:    pulumi.Int(0),
 * 			CallbackName: pulumi.String(name),
 * 			CallbackTypes: pulumi.StringArray{
 * 				pulumi.String("machineScan"),
 * 				pulumi.String("selfAudit"),
 * 				pulumi.String("example"),
 * 			},
 * 			CallbackSuggestions: pulumi.StringArray{
 * 				pulumi.String("block"),
 * 				pulumi.String("review"),
 * 				pulumi.String("pass"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.aligreen.Callback;
 * import com.pulumi.alicloud.aligreen.CallbackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         var default_ = new Callback("default", CallbackArgs.builder()
 *             .callbackUrl("https://www.aliyun.com")
 *             .cryptType("0")
 *             .callbackName(name)
 *             .callbackTypes(
 *                 "machineScan",
 *                 "selfAudit",
 *                 "example")
 *             .callbackSuggestions(
 *                 "block",
 *                 "review",
 *                 "pass")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   default:
 *     type: alicloud:aligreen:Callback
 *     properties:
 *       callbackUrl: https://www.aliyun.com
 *       cryptType: '0'
 *       callbackName: ${name}
 *       callbackTypes:
 *         - machineScan
 *         - selfAudit
 *         - example
 *       callbackSuggestions:
 *         - block
 *         - review
 *         - pass
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aligreen Callback can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/callback:Callback example <id>
 * ```
 * @property callbackName The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
 * @property callbackSuggestions List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
 * @property callbackTypes A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
 * @property callbackUrl The detection result will be called back to the url.
 * @property cryptType The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
 */
public data class CallbackArgs(
    public val callbackName: Output<String>? = null,
    public val callbackSuggestions: Output<List<String>>? = null,
    public val callbackTypes: Output<List<String>>? = null,
    public val callbackUrl: Output<String>? = null,
    public val cryptType: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.aligreen.CallbackArgs> {
    override fun toJava(): com.pulumi.alicloud.aligreen.CallbackArgs =
        com.pulumi.alicloud.aligreen.CallbackArgs.builder()
            .callbackName(callbackName?.applyValue({ args0 -> args0 }))
            .callbackSuggestions(callbackSuggestions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .callbackTypes(callbackTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .callbackUrl(callbackUrl?.applyValue({ args0 -> args0 }))
            .cryptType(cryptType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CallbackArgs].
 */
@PulumiTagMarker
public class CallbackArgsBuilder internal constructor() {
    private var callbackName: Output<String>? = null

    private var callbackSuggestions: Output<List<String>>? = null

    private var callbackTypes: Output<List<String>>? = null

    private var callbackUrl: Output<String>? = null

    private var cryptType: Output<Int>? = null

    /**
     * @param value The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
     */
    @JvmName("vaiwmunybbqbqbqp")
    public suspend fun callbackName(`value`: Output<String>) {
        this.callbackName = value
    }

    /**
     * @param value List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    @JvmName("oqbwwnswkfonidli")
    public suspend fun callbackSuggestions(`value`: Output<List<String>>) {
        this.callbackSuggestions = value
    }

    @JvmName("ffsrqthpuxrgackd")
    public suspend fun callbackSuggestions(vararg values: Output<String>) {
        this.callbackSuggestions = Output.all(values.asList())
    }

    /**
     * @param values List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    @JvmName("qlofvyiuokokselh")
    public suspend fun callbackSuggestions(values: List<Output<String>>) {
        this.callbackSuggestions = Output.all(values)
    }

    /**
     * @param value A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    @JvmName("jpyqusgruceaelhd")
    public suspend fun callbackTypes(`value`: Output<List<String>>) {
        this.callbackTypes = value
    }

    @JvmName("npugpyihrrfvdaed")
    public suspend fun callbackTypes(vararg values: Output<String>) {
        this.callbackTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    @JvmName("ttxdaewoqpsmaqxg")
    public suspend fun callbackTypes(values: List<Output<String>>) {
        this.callbackTypes = Output.all(values)
    }

    /**
     * @param value The detection result will be called back to the url.
     */
    @JvmName("glanjoywxpjpxisy")
    public suspend fun callbackUrl(`value`: Output<String>) {
        this.callbackUrl = value
    }

    /**
     * @param value The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
     */
    @JvmName("wleqasdhtptfavqa")
    public suspend fun cryptType(`value`: Output<Int>) {
        this.cryptType = value
    }

    /**
     * @param value The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
     */
    @JvmName("itdeydfvjqiuratu")
    public suspend fun callbackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callbackName = mapped
    }

    /**
     * @param value List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    @JvmName("rsnbubqodycerhgh")
    public suspend fun callbackSuggestions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callbackSuggestions = mapped
    }

    /**
     * @param values List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
     */
    @JvmName("edydhxwemstedroq")
    public suspend fun callbackSuggestions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callbackSuggestions = mapped
    }

    /**
     * @param value A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    @JvmName("jxpikgdgecnxbllk")
    public suspend fun callbackTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callbackTypes = mapped
    }

    /**
     * @param values A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
     */
    @JvmName("irudnylxlhiuajbp")
    public suspend fun callbackTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callbackTypes = mapped
    }

    /**
     * @param value The detection result will be called back to the url.
     */
    @JvmName("lcwgyggjyixidvai")
    public suspend fun callbackUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callbackUrl = mapped
    }

    /**
     * @param value The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
     */
    @JvmName("nmfjhivvjkswrvyp")
    public suspend fun cryptType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cryptType = mapped
    }

    internal fun build(): CallbackArgs = CallbackArgs(
        callbackName = callbackName,
        callbackSuggestions = callbackSuggestions,
        callbackTypes = callbackTypes,
        callbackUrl = callbackUrl,
        cryptType = cryptType,
    )
}
