@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ImageLib].
 */
@PulumiTagMarker
public class ImageLibResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageLibArgs = ImageLibArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageLibArgsBuilder.() -> Unit) {
        val builder = ImageLibArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ImageLib {
        val builtJavaResource = com.pulumi.alicloud.aligreen.ImageLib(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ImageLib(builtJavaResource)
    }
}

/**
 * Provides a Aligreen Image Lib resource.
 * Image library for image detection.
 * For information about Aligreen Image Lib and how to use it, see [What is Image Lib](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform";
 * const defaultUalunB = new alicloud.aligreen.BizType("defaultUalunB", {bizTypeName: name});
 * const _default = new alicloud.aligreen.ImageLib("default", {
 *     category: "BLACK",
 *     enable: true,
 *     scene: "PORN",
 *     imageLibName: name,
 *     bizTypes: [defaultUalunB&#46;bizTypeName],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform"
 * default_ualun_b = alicloud.aligreen.BizType("defaultUalunB", biz_type_name=name)
 * default = alicloud.aligreen.ImageLib("default",
 *     category="BLACK",
 *     enable=True,
 *     scene="PORN",
 *     image_lib_name=name,
 *     biz_types=[default_ualun_b&#46;biz_type_name])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform";
 *     var defaultUalunB = new AliCloud.Aligreen.BizType("defaultUalunB", new()
 *     {
 *         BizTypeName = name,
 *     });
 *     var @default = new AliCloud.Aligreen.ImageLib("default", new()
 *     {
 *         Category = "BLACK",
 *         Enable = true,
 *         Scene = "PORN",
 *         ImageLibName = name,
 *         BizTypes = new[]
 *         {
 *             defaultUalunB.BizTypeName,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/aligreen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultUalunB, err := aligreen.NewBizType(ctx, "defaultUalunB", &aligreen.BizTypeArgs{
 * 			BizTypeName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = aligreen.NewImageLib(ctx, "default", &aligreen.ImageLibArgs{
 * 			Category:     pulumi.String("BLACK"),
 * 			Enable:       pulumi.Bool(true),
 * 			Scene:        pulumi.String("PORN"),
 * 			ImageLibName: pulumi.String(name),
 * 			BizTypes: pulumi.StringArray{
 * 				defaultUalunB.BizTypeName,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.aligreen.BizType;
 * import com.pulumi.alicloud.aligreen.BizTypeArgs;
 * import com.pulumi.alicloud.aligreen.ImageLib;
 * import com.pulumi.alicloud.aligreen.ImageLibArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform");
 *         var defaultUalunB = new BizType("defaultUalunB", BizTypeArgs.builder()
 *             .bizTypeName(name)
 *             .build());
 *         var default_ = new ImageLib("default", ImageLibArgs.builder()
 *             .category("BLACK")
 *             .enable(true)
 *             .scene("PORN")
 *             .imageLibName(name)
 *             .bizTypes(defaultUalunB.bizTypeName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform
 * resources:
 *   defaultUalunB:
 *     type: alicloud:aligreen:BizType
 *     properties:
 *       bizTypeName: ${name}
 *   default:
 *     type: alicloud:aligreen:ImageLib
 *     properties:
 *       category: BLACK
 *       enable: true
 *       scene: PORN
 *       imageLibName: ${name}
 *       bizTypes:
 *         - ${defaultUalunB.bizTypeName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aligreen Image Lib can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/imageLib:ImageLib example <id>
 * ```
 */
public class ImageLib internal constructor(
    override val javaResource: com.pulumi.alicloud.aligreen.ImageLib,
) : KotlinCustomResource(javaResource, ImageLibMapper) {
    /**
     * List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
     */
    public val bizTypes: Output<List<String>>?
        get() = javaResource.bizTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
     */
    public val enable: Output<Boolean>
        get() = javaResource.enable().applyValue({ args0 -> args0 })

    /**
     * The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
     */
    public val imageLibName: Output<String>
        get() = javaResource.imageLibName().applyValue({ args0 -> args0 })

    /**
     * The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
     */
    public val scene: Output<String>
        get() = javaResource.scene().applyValue({ args0 -> args0 })
}

public object ImageLibMapper : ResourceMapper<ImageLib> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.aligreen.ImageLib::class == javaResource::class

    override fun map(javaResource: Resource): ImageLib = ImageLib(
        javaResource as
            com.pulumi.alicloud.aligreen.ImageLib,
    )
}

/**
 * @see [ImageLib].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImageLib].
 */
public suspend fun imageLib(name: String, block: suspend ImageLibResourceBuilder.() -> Unit): ImageLib {
    val builder = ImageLibResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImageLib].
 * @param name The _unique_ name of the resulting resource.
 */
public fun imageLib(name: String): ImageLib {
    val builder = ImageLibResourceBuilder()
    builder.name(name)
    return builder.build()
}
