@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.alicloud.aligreen.ImageLibArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Aligreen Image Lib resource.
 * Image library for image detection.
 * For information about Aligreen Image Lib and how to use it, see [What is Image Lib](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform";
 * const defaultUalunB = new alicloud.aligreen.BizType("defaultUalunB", {bizTypeName: name});
 * const _default = new alicloud.aligreen.ImageLib("default", {
 *     category: "BLACK",
 *     enable: true,
 *     scene: "PORN",
 *     imageLibName: name,
 *     bizTypes: [defaultUalunB&#46;bizTypeName],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform"
 * default_ualun_b = alicloud.aligreen.BizType("defaultUalunB", biz_type_name=name)
 * default = alicloud.aligreen.ImageLib("default",
 *     category="BLACK",
 *     enable=True,
 *     scene="PORN",
 *     image_lib_name=name,
 *     biz_types=[default_ualun_b&#46;biz_type_name])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform";
 *     var defaultUalunB = new AliCloud.Aligreen.BizType("defaultUalunB", new()
 *     {
 *         BizTypeName = name,
 *     });
 *     var @default = new AliCloud.Aligreen.ImageLib("default", new()
 *     {
 *         Category = "BLACK",
 *         Enable = true,
 *         Scene = "PORN",
 *         ImageLibName = name,
 *         BizTypes = new[]
 *         {
 *             defaultUalunB.BizTypeName,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/aligreen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultUalunB, err := aligreen.NewBizType(ctx, "defaultUalunB", &aligreen.BizTypeArgs{
 * 			BizTypeName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = aligreen.NewImageLib(ctx, "default", &aligreen.ImageLibArgs{
 * 			Category:     pulumi.String("BLACK"),
 * 			Enable:       pulumi.Bool(true),
 * 			Scene:        pulumi.String("PORN"),
 * 			ImageLibName: pulumi.String(name),
 * 			BizTypes: pulumi.StringArray{
 * 				defaultUalunB.BizTypeName,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.aligreen.BizType;
 * import com.pulumi.alicloud.aligreen.BizTypeArgs;
 * import com.pulumi.alicloud.aligreen.ImageLib;
 * import com.pulumi.alicloud.aligreen.ImageLibArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform");
 *         var defaultUalunB = new BizType("defaultUalunB", BizTypeArgs.builder()
 *             .bizTypeName(name)
 *             .build());
 *         var default_ = new ImageLib("default", ImageLibArgs.builder()
 *             .category("BLACK")
 *             .enable(true)
 *             .scene("PORN")
 *             .imageLibName(name)
 *             .bizTypes(defaultUalunB.bizTypeName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform
 * resources:
 *   defaultUalunB:
 *     type: alicloud:aligreen:BizType
 *     properties:
 *       bizTypeName: ${name}
 *   default:
 *     type: alicloud:aligreen:ImageLib
 *     properties:
 *       category: BLACK
 *       enable: true
 *       scene: PORN
 *       imageLibName: ${name}
 *       bizTypes:
 *         - ${defaultUalunB.bizTypeName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aligreen Image Lib can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/imageLib:ImageLib example <id>
 * ```
 * @property bizTypes List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
 * @property category The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
 * @property enable Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
 * @property imageLibName The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
 * @property scene The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
 */
public data class ImageLibArgs(
    public val bizTypes: Output<List<String>>? = null,
    public val category: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val imageLibName: Output<String>? = null,
    public val scene: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.aligreen.ImageLibArgs> {
    override fun toJava(): com.pulumi.alicloud.aligreen.ImageLibArgs =
        com.pulumi.alicloud.aligreen.ImageLibArgs.builder()
            .bizTypes(bizTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .category(category?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .imageLibName(imageLibName?.applyValue({ args0 -> args0 }))
            .scene(scene?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageLibArgs].
 */
@PulumiTagMarker
public class ImageLibArgsBuilder internal constructor() {
    private var bizTypes: Output<List<String>>? = null

    private var category: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var imageLibName: Output<String>? = null

    private var scene: Output<String>? = null

    /**
     * @param value List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
     */
    @JvmName("awbuvobydtmemuiy")
    public suspend fun bizTypes(`value`: Output<List<String>>) {
        this.bizTypes = value
    }

    @JvmName("smbyyavfuphuafea")
    public suspend fun bizTypes(vararg values: Output<String>) {
        this.bizTypes = Output.all(values.asList())
    }

    /**
     * @param values List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
     */
    @JvmName("lfeckqsitpgxkeru")
    public suspend fun bizTypes(values: List<Output<String>>) {
        this.bizTypes = Output.all(values)
    }

    /**
     * @param value The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
     */
    @JvmName("vcydxhukgkisxhpm")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
     */
    @JvmName("orefrfabictvglnp")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
     */
    @JvmName("kwmnsmcojevodunx")
    public suspend fun imageLibName(`value`: Output<String>) {
        this.imageLibName = value
    }

    /**
     * @param value The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
     */
    @JvmName("bkxvwxaspcqcngdh")
    public suspend fun scene(`value`: Output<String>) {
        this.scene = value
    }

    /**
     * @param value List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
     */
    @JvmName("ggdcmwywvpkiwoik")
    public suspend fun bizTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizTypes = mapped
    }

    /**
     * @param values List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
     */
    @JvmName("tydifrdubpjnmjna")
    public suspend fun bizTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bizTypes = mapped
    }

    /**
     * @param value The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
     */
    @JvmName("bcqoxaejdniixrao")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
     */
    @JvmName("hkcjwowsjpoltlas")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
     */
    @JvmName("nnqsbfmpeifgwhbe")
    public suspend fun imageLibName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageLibName = mapped
    }

    /**
     * @param value The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
     */
    @JvmName("wkiaptkvjkaaqsmr")
    public suspend fun scene(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scene = mapped
    }

    internal fun build(): ImageLibArgs = ImageLibArgs(
        bizTypes = bizTypes,
        category = category,
        enable = enable,
        imageLibName = imageLibName,
        scene = scene,
    )
}
