@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [KeywordLib].
 */
@PulumiTagMarker
public class KeywordLibResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeywordLibArgs = KeywordLibArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeywordLibArgsBuilder.() -> Unit) {
        val builder = KeywordLibArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeywordLib {
        val builtJavaResource = com.pulumi.alicloud.aligreen.KeywordLib(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeywordLib(builtJavaResource)
    }
}

/**
 * Provides a Aligreen Keyword Lib resource.
 * Keyword library for text detection.
 * For information about Aligreen Keyword Lib and how to use it, see [What is Keyword Lib](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultMn8sVK = new alicloud.aligreen.BizType("defaultMn8sVK", {
 *     bizTypeName: `${name}${_default.result}`,
 *     citeTemplate: true,
 *     industryInfo: "社交-注册信息-昵称",
 * });
 * const defaultKeywordLib = new alicloud.aligreen.KeywordLib("default", {
 *     category: "BLACK",
 *     resourceType: "TEXT",
 *     libType: "textKeyword",
 *     keywordLibName: name,
 *     matchMode: "fuzzy",
 *     language: "cn",
 *     bizTypes: ["example_007"],
 *     lang: "cn",
 *     enable: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_mn8s_vk = alicloud.aligreen.BizType("defaultMn8sVK",
 *     biz_type_name=f"{name}{default['result']}",
 *     cite_template=True,
 *     industry_info="社交-注册信息-昵称")
 * default_keyword_lib = alicloud.aligreen.KeywordLib("default",
 *     category="BLACK",
 *     resource_type="TEXT",
 *     lib_type="textKeyword",
 *     keyword_lib_name=name,
 *     match_mode="fuzzy",
 *     language="cn",
 *     biz_types=["example_007"],
 *     lang="cn",
 *     enable=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultMn8sVK = new AliCloud.Aligreen.BizType("defaultMn8sVK", new()
 *     {
 *         BizTypeName = $"{name}{@default.Result}",
 *         CiteTemplate = true,
 *         IndustryInfo = "社交-注册信息-昵称",
 *     });
 *     var defaultKeywordLib = new AliCloud.Aligreen.KeywordLib("default", new()
 *     {
 *         Category = "BLACK",
 *         ResourceType = "TEXT",
 *         LibType = "textKeyword",
 *         KeywordLibName = name,
 *         MatchMode = "fuzzy",
 *         Language = "cn",
 *         BizTypes = new[]
 *         {
 *             "example_007",
 *         },
 *         Lang = "cn",
 *         Enable = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/aligreen"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = aligreen.NewBizType(ctx, "defaultMn8sVK", &aligreen.BizTypeArgs{
 * 			BizTypeName:  pulumi.Sprintf("%v%v", name, _default.Result),
 * 			CiteTemplate: pulumi.Bool(true),
 * 			IndustryInfo: pulumi.String("社交-注册信息-昵称"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = aligreen.NewKeywordLib(ctx, "default", &aligreen.KeywordLibArgs{
 * 			Category:       pulumi.String("BLACK"),
 * 			ResourceType:   pulumi.String("TEXT"),
 * 			LibType:        pulumi.String("textKeyword"),
 * 			KeywordLibName: pulumi.String(name),
 * 			MatchMode:      pulumi.String("fuzzy"),
 * 			Language:       pulumi.String("cn"),
 * 			BizTypes: pulumi.StringArray{
 * 				pulumi.String("example_007"),
 * 			},
 * 			Lang:   pulumi.String("cn"),
 * 			Enable: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.aligreen.BizType;
 * import com.pulumi.alicloud.aligreen.BizTypeArgs;
 * import com.pulumi.alicloud.aligreen.KeywordLib;
 * import com.pulumi.alicloud.aligreen.KeywordLibArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultMn8sVK = new BizType("defaultMn8sVK", BizTypeArgs.builder()
 *             .bizTypeName(String.format("%s%s", name,default_.result()))
 *             .citeTemplate(true)
 *             .industryInfo("社交-注册信息-昵称")
 *             .build());
 *         var defaultKeywordLib = new KeywordLib("defaultKeywordLib", KeywordLibArgs.builder()
 *             .category("BLACK")
 *             .resourceType("TEXT")
 *             .libType("textKeyword")
 *             .keywordLibName(name)
 *             .matchMode("fuzzy")
 *             .language("cn")
 *             .bizTypes("example_007")
 *             .lang("cn")
 *             .enable(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultMn8sVK:
 *     type: alicloud:aligreen:BizType
 *     properties:
 *       bizTypeName: ${name}${default.result}
 *       citeTemplate: true
 *       industryInfo: 社交-注册信息-昵称
 *   defaultKeywordLib:
 *     type: alicloud:aligreen:KeywordLib
 *     name: default
 *     properties:
 *       category: BLACK
 *       resourceType: TEXT
 *       libType: textKeyword
 *       keywordLibName: ${name}
 *       matchMode: fuzzy
 *       language: cn
 *       bizTypes:
 *         - example_007
 *       lang: cn
 *       enable: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aligreen Keyword Lib can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/keywordLib:KeywordLib example <id>
 * ```
 */
public class KeywordLib internal constructor(
    override val javaResource: com.pulumi.alicloud.aligreen.KeywordLib,
) : KotlinCustomResource(javaResource, KeywordLibMapper) {
    /**
     * The business scenario. Example:["bizTypeA","bizTypeB"]
     */
    public val bizTypes: Output<List<String>>?
        get() = javaResource.bizTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
     */
    public val enable: Output<Boolean>
        get() = javaResource.enable().applyValue({ args0 -> args0 })

    /**
     * The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
     */
    public val keywordLibName: Output<String>
        get() = javaResource.keywordLibName().applyValue({ args0 -> args0 })

    /**
     * Language.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Language used by the text Library
     */
    public val language: Output<String>
        get() = javaResource.language().applyValue({ args0 -> args0 })

    /**
     * The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
     */
    public val libType: Output<String>
        get() = javaResource.libType().applyValue({ args0 -> args0 })

    /**
     * The matching method. Valid values:fuzzy: fuzzy match precise: exact match
     */
    public val matchMode: Output<String>
        get() = javaResource.matchMode().applyValue({ args0 -> args0 })

    /**
     * The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })
}

public object KeywordLibMapper : ResourceMapper<KeywordLib> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.aligreen.KeywordLib::class == javaResource::class

    override fun map(javaResource: Resource): KeywordLib = KeywordLib(
        javaResource as
            com.pulumi.alicloud.aligreen.KeywordLib,
    )
}

/**
 * @see [KeywordLib].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeywordLib].
 */
public suspend fun keywordLib(name: String, block: suspend KeywordLibResourceBuilder.() -> Unit): KeywordLib {
    val builder = KeywordLibResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeywordLib].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keywordLib(name: String): KeywordLib {
    val builder = KeywordLibResourceBuilder()
    builder.name(name)
    return builder.build()
}
