@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.alicloud.aligreen.KeywordLibArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Aligreen Keyword Lib resource.
 * Keyword library for text detection.
 * For information about Aligreen Keyword Lib and how to use it, see [What is Keyword Lib](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultMn8sVK = new alicloud.aligreen.BizType("defaultMn8sVK", {
 *     bizTypeName: `${name}${_default.result}`,
 *     citeTemplate: true,
 *     industryInfo: "社交-注册信息-昵称",
 * });
 * const defaultKeywordLib = new alicloud.aligreen.KeywordLib("default", {
 *     category: "BLACK",
 *     resourceType: "TEXT",
 *     libType: "textKeyword",
 *     keywordLibName: name,
 *     matchMode: "fuzzy",
 *     language: "cn",
 *     bizTypes: ["example_007"],
 *     lang: "cn",
 *     enable: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_mn8s_vk = alicloud.aligreen.BizType("defaultMn8sVK",
 *     biz_type_name=f"{name}{default['result']}",
 *     cite_template=True,
 *     industry_info="社交-注册信息-昵称")
 * default_keyword_lib = alicloud.aligreen.KeywordLib("default",
 *     category="BLACK",
 *     resource_type="TEXT",
 *     lib_type="textKeyword",
 *     keyword_lib_name=name,
 *     match_mode="fuzzy",
 *     language="cn",
 *     biz_types=["example_007"],
 *     lang="cn",
 *     enable=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultMn8sVK = new AliCloud.Aligreen.BizType("defaultMn8sVK", new()
 *     {
 *         BizTypeName = $"{name}{@default.Result}",
 *         CiteTemplate = true,
 *         IndustryInfo = "社交-注册信息-昵称",
 *     });
 *     var defaultKeywordLib = new AliCloud.Aligreen.KeywordLib("default", new()
 *     {
 *         Category = "BLACK",
 *         ResourceType = "TEXT",
 *         LibType = "textKeyword",
 *         KeywordLibName = name,
 *         MatchMode = "fuzzy",
 *         Language = "cn",
 *         BizTypes = new[]
 *         {
 *             "example_007",
 *         },
 *         Lang = "cn",
 *         Enable = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/aligreen"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = aligreen.NewBizType(ctx, "defaultMn8sVK", &aligreen.BizTypeArgs{
 * 			BizTypeName:  pulumi.Sprintf("%v%v", name, _default.Result),
 * 			CiteTemplate: pulumi.Bool(true),
 * 			IndustryInfo: pulumi.String("社交-注册信息-昵称"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = aligreen.NewKeywordLib(ctx, "default", &aligreen.KeywordLibArgs{
 * 			Category:       pulumi.String("BLACK"),
 * 			ResourceType:   pulumi.String("TEXT"),
 * 			LibType:        pulumi.String("textKeyword"),
 * 			KeywordLibName: pulumi.String(name),
 * 			MatchMode:      pulumi.String("fuzzy"),
 * 			Language:       pulumi.String("cn"),
 * 			BizTypes: pulumi.StringArray{
 * 				pulumi.String("example_007"),
 * 			},
 * 			Lang:   pulumi.String("cn"),
 * 			Enable: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.aligreen.BizType;
 * import com.pulumi.alicloud.aligreen.BizTypeArgs;
 * import com.pulumi.alicloud.aligreen.KeywordLib;
 * import com.pulumi.alicloud.aligreen.KeywordLibArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultMn8sVK = new BizType("defaultMn8sVK", BizTypeArgs.builder()
 *             .bizTypeName(String.format("%s%s", name,default_.result()))
 *             .citeTemplate(true)
 *             .industryInfo("社交-注册信息-昵称")
 *             .build());
 *         var defaultKeywordLib = new KeywordLib("defaultKeywordLib", KeywordLibArgs.builder()
 *             .category("BLACK")
 *             .resourceType("TEXT")
 *             .libType("textKeyword")
 *             .keywordLibName(name)
 *             .matchMode("fuzzy")
 *             .language("cn")
 *             .bizTypes("example_007")
 *             .lang("cn")
 *             .enable(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultMn8sVK:
 *     type: alicloud:aligreen:BizType
 *     properties:
 *       bizTypeName: ${name}${default.result}
 *       citeTemplate: true
 *       industryInfo: 社交-注册信息-昵称
 *   defaultKeywordLib:
 *     type: alicloud:aligreen:KeywordLib
 *     name: default
 *     properties:
 *       category: BLACK
 *       resourceType: TEXT
 *       libType: textKeyword
 *       keywordLibName: ${name}
 *       matchMode: fuzzy
 *       language: cn
 *       bizTypes:
 *         - example_007
 *       lang: cn
 *       enable: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aligreen Keyword Lib can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/keywordLib:KeywordLib example <id>
 * ```
 * @property bizTypes The business scenario. Example:["bizTypeA","bizTypeB"]
 * @property category The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
 * @property enable Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
 * @property keywordLibName The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
 * @property lang Language.
 * @property language Language used by the text Library
 * @property libType The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
 * @property matchMode The matching method. Valid values:fuzzy: fuzzy match precise: exact match
 * @property resourceType The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
 */
public data class KeywordLibArgs(
    public val bizTypes: Output<List<String>>? = null,
    public val category: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val keywordLibName: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val language: Output<String>? = null,
    public val libType: Output<String>? = null,
    public val matchMode: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.aligreen.KeywordLibArgs> {
    override fun toJava(): com.pulumi.alicloud.aligreen.KeywordLibArgs =
        com.pulumi.alicloud.aligreen.KeywordLibArgs.builder()
            .bizTypes(bizTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .category(category?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .keywordLibName(keywordLibName?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .language(language?.applyValue({ args0 -> args0 }))
            .libType(libType?.applyValue({ args0 -> args0 }))
            .matchMode(matchMode?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeywordLibArgs].
 */
@PulumiTagMarker
public class KeywordLibArgsBuilder internal constructor() {
    private var bizTypes: Output<List<String>>? = null

    private var category: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var keywordLibName: Output<String>? = null

    private var lang: Output<String>? = null

    private var language: Output<String>? = null

    private var libType: Output<String>? = null

    private var matchMode: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value The business scenario. Example:["bizTypeA","bizTypeB"]
     */
    @JvmName("hkscppxbedmpanof")
    public suspend fun bizTypes(`value`: Output<List<String>>) {
        this.bizTypes = value
    }

    @JvmName("qeygquubitkugyuq")
    public suspend fun bizTypes(vararg values: Output<String>) {
        this.bizTypes = Output.all(values.asList())
    }

    /**
     * @param values The business scenario. Example:["bizTypeA","bizTypeB"]
     */
    @JvmName("bmghculhkopparxh")
    public suspend fun bizTypes(values: List<Output<String>>) {
        this.bizTypes = Output.all(values)
    }

    /**
     * @param value The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
     */
    @JvmName("ynpraeydpefygqxd")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
     */
    @JvmName("ehntdlugmcygdmxb")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
     */
    @JvmName("prnpxmanmncyyiky")
    public suspend fun keywordLibName(`value`: Output<String>) {
        this.keywordLibName = value
    }

    /**
     * @param value Language.
     */
    @JvmName("ywlvwhhrawlshugp")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value Language used by the text Library
     */
    @JvmName("cxkmnxraohstlcyj")
    public suspend fun language(`value`: Output<String>) {
        this.language = value
    }

    /**
     * @param value The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
     */
    @JvmName("bdctkguhpbmerhxi")
    public suspend fun libType(`value`: Output<String>) {
        this.libType = value
    }

    /**
     * @param value The matching method. Valid values:fuzzy: fuzzy match precise: exact match
     */
    @JvmName("ipwwfpemtceygxjf")
    public suspend fun matchMode(`value`: Output<String>) {
        this.matchMode = value
    }

    /**
     * @param value The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
     */
    @JvmName("tqspiffshmnsdksp")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The business scenario. Example:["bizTypeA","bizTypeB"]
     */
    @JvmName("wifgplksvvmgnrwo")
    public suspend fun bizTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizTypes = mapped
    }

    /**
     * @param values The business scenario. Example:["bizTypeA","bizTypeB"]
     */
    @JvmName("vxmatcbatwmwagyq")
    public suspend fun bizTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bizTypes = mapped
    }

    /**
     * @param value The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
     */
    @JvmName("udtvwknbydxqpaom")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
     */
    @JvmName("rovttxltuosspbqi")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
     */
    @JvmName("vcktsatmkpmuushb")
    public suspend fun keywordLibName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keywordLibName = mapped
    }

    /**
     * @param value Language.
     */
    @JvmName("vmmmwuwqcyaaprga")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value Language used by the text Library
     */
    @JvmName("jowtxahoichvueck")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
     */
    @JvmName("iykvtnudynnlqktd")
    public suspend fun libType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.libType = mapped
    }

    /**
     * @param value The matching method. Valid values:fuzzy: fuzzy match precise: exact match
     */
    @JvmName("vffithmfettsnyfm")
    public suspend fun matchMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchMode = mapped
    }

    /**
     * @param value The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
     */
    @JvmName("feanfjigqxeoxvod")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): KeywordLibArgs = KeywordLibArgs(
        bizTypes = bizTypes,
        category = category,
        enable = enable,
        keywordLibName = keywordLibName,
        lang = lang,
        language = language,
        libType = libType,
        matchMode = matchMode,
        resourceType = resourceType,
    )
}
