@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [OssStockTask].
 */
@PulumiTagMarker
public class OssStockTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OssStockTaskArgs = OssStockTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OssStockTaskArgsBuilder.() -> Unit) {
        val builder = OssStockTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OssStockTask {
        val builtJavaResource = com.pulumi.alicloud.aligreen.OssStockTask(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OssStockTask(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Aligreen Oss Stock Task can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/ossStockTask:OssStockTask example <id>
 * ```
 */
public class OssStockTask internal constructor(
    override val javaResource: com.pulumi.alicloud.aligreen.OssStockTask,
) : KotlinCustomResource(javaResource, OssStockTaskMapper) {
    /**
     * Voice auto freeze configuration. Example:{"type":"suggestion","value":"block,review"}. The results are frozen according to the suggestion in the speech detection results.
     */
    public val audioAntispamFreezeConfig: Output<String>?
        get() = javaResource.audioAntispamFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Audio detection auto freeze switch. Value: true: automatically freeze, false: not automatically freeze.
     */
    public val audioAutoFreezeOpened: Output<Boolean>?
        get() = javaResource.audioAutoFreezeOpened().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource property field representing the maximum size of a single audio. 1~2048MB, the default is 200MB, more than not detected.
     */
    public val audioMaxSize: Output<Int>?
        get() = javaResource.audioMaxSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * oss stock scan task detect audio. true: scan audio, false: do not scan audio
     */
    public val audioOpened: Output<Boolean>?
        get() = javaResource.audioOpened().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The upper limit of voice scan in the oss stock scan task. The default value is 1000/Bucket.
     */
    public val audioScanLimit: Output<Int>?
        get() = javaResource.audioScanLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The audio detection scenarios included in the oss stock scan task. Set the value to antispam.
     */
    public val audioScenes: Output<String>?
        get() = javaResource.audioScenes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Automatic freeze type. Value: acl: modify permissions, copy: Move files
     */
    public val autoFreezeType: Output<String>?
        get() = javaResource.autoFreezeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Business scenarios used by the oss stock scan task
     */
    public val bizType: Output<String>?
        get() = javaResource.bizType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The bucket configuration list of the oss stock scan task. Example:[{"Bucket":"bucket_01","Selected":true,"Prefixes":["img/test_"],"Type":"exclude"}]
     */
    public val buckets: Output<String>?
        get() = javaResource.buckets().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the primary key of the notification message bound to the oss stock scan task.
     */
    public val callbackId: Output<Int>?
        get() = javaResource.callbackId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The end time of the file upload time range indicates the scanning of files uploaded before this time point.
     */
    public val endDate: Output<String>?
        get() = javaResource.endDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Picture automatically freezes the configuration of ad scenes. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    public val imageAdFreezeConfig: Output<String>?
        get() = javaResource.imageAdFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Picture detection auto freeze switch. Value: true: auto freeze, false: not auto freeze.
     */
    public val imageAutoFreezeOpened: Output<Boolean>?
        get() = javaResource.imageAutoFreezeOpened().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Picture automatic freezing live scene configuration. Example:{"type":"suggestion","value":"block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    public val imageLiveFreezeConfig: Output<String>?
        get() = javaResource.imageLiveFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * oss stock scan task detect images. true: scan images, false: do not scan images
     */
    public val imageOpened: Output<Boolean>?
        get() = javaResource.imageOpened().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Picture automatic freezing porn scene configuration. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    public val imagePornFreezeConfig: Output<String>?
        get() = javaResource.imagePornFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The upper limit for scanning images in the oss stock scan task. The default value is 10000 images per Bucket.
     */
    public val imageScanLimit: Output<Int>?
        get() = javaResource.imageScanLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The image moderation scenario included in the oss stock scan task.Valid values: porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection
     */
    public val imageScenes: Output<List<String>>?
        get() = javaResource.imageScenes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The picture automatically freezes the configuration of terrorism scenes. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    public val imageTerrorismFreezeConfig: Output<String>?
        get() = javaResource.imageTerrorismFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the oss stock scan task detects images with file names without suffixes. true: Detect pictures with file names without suffixes, false: Do not detect pictures with file names without suffixes
     */
    public val scanImageNoFileType: Output<Boolean>?
        get() = javaResource.scanImageNoFileType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The start time of the file upload time range represents the files uploaded after scanning this time point.
     */
    public val startDate: Output<String>?
        get() = javaResource.startDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The video automatically freezes the configuration of ad scenarios. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    public val videoAdFreezeConfig: Output<String>?
        get() = javaResource.videoAdFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Video detection auto freeze switch. Value: true: automatically freeze, false: not automatically freeze.
     */
    public val videoAutoFreezeOpened: Output<Boolean>?
        get() = javaResource.videoAutoFreezeOpened().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource attribute field representing the framing frequency. 1~60 seconds/frame, the default is 1 second/frame
     */
    public val videoFrameInterval: Output<Int>?
        get() = javaResource.videoFrameInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Video automatic freeze live scene configuration. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    public val videoLiveFreezeConfig: Output<String>?
        get() = javaResource.videoLiveFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A resource attribute field that represents the upper limit of a single video frame cut. 5 to 20000 frames, the default is 200 frames
     */
    public val videoMaxFrames: Output<Int>?
        get() = javaResource.videoMaxFrames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource property field representing the maximum size of a single video. 1~2048MB, the default is 500MB, more than not detected.
     */
    public val videoMaxSize: Output<Int>?
        get() = javaResource.videoMaxSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * oss stock scan task detect video. true: scan video, false: do not scan video
     */
    public val videoOpened: Output<Boolean>?
        get() = javaResource.videoOpened().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Video automatic freezing porn scene configuration. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the video detection result.
     */
    public val videoPornFreezeConfig: Output<String>?
        get() = javaResource.videoPornFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The upper limit of video scanning in the oss stock scan task. The default value is 1000/Bucket.
     */
    public val videoScanLimit: Output<Int>?
        get() = javaResource.videoScanLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The video detection scenarios included in the oss stock scan task. porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection antispam: Video voice antispam
     */
    public val videoScenes: Output<String>?
        get() = javaResource.videoScenes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The video automatically freezes the configuration of terrorism scenes. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    public val videoTerrorismFreezeConfig: Output<String>?
        get() = javaResource.videoTerrorismFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Voice auto freeze configuration in video. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    public val videoVoiceAntispamFreezeConfig: Output<String>?
        get() = javaResource.videoVoiceAntispamFreezeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object OssStockTaskMapper : ResourceMapper<OssStockTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.aligreen.OssStockTask::class == javaResource::class

    override fun map(javaResource: Resource): OssStockTask = OssStockTask(
        javaResource as
            com.pulumi.alicloud.aligreen.OssStockTask,
    )
}

/**
 * @see [OssStockTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OssStockTask].
 */
public suspend fun ossStockTask(
    name: String,
    block: suspend OssStockTaskResourceBuilder.() -> Unit,
): OssStockTask {
    val builder = OssStockTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OssStockTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ossStockTask(name: String): OssStockTask {
    val builder = OssStockTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
