@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.aligreen.kotlin

import com.pulumi.alicloud.aligreen.OssStockTaskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Aligreen Oss Stock Task can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:aligreen/ossStockTask:OssStockTask example <id>
 * ```
 * @property audioAntispamFreezeConfig Voice auto freeze configuration. Example:{"type":"suggestion","value":"block,review"}. The results are frozen according to the suggestion in the speech detection results.
 * @property audioAutoFreezeOpened Audio detection auto freeze switch. Value: true: automatically freeze, false: not automatically freeze.
 * @property audioMaxSize Resource property field representing the maximum size of a single audio. 1~2048MB, the default is 200MB, more than not detected.
 * @property audioOpened oss stock scan task detect audio. true: scan audio, false: do not scan audio
 * @property audioScanLimit The upper limit of voice scan in the oss stock scan task. The default value is 1000/Bucket.
 * @property audioScenes The audio detection scenarios included in the oss stock scan task. Set the value to antispam.
 * @property autoFreezeType Automatic freeze type. Value: acl: modify permissions, copy: Move files
 * @property bizType Business scenarios used by the oss stock scan task
 * @property buckets The bucket configuration list of the oss stock scan task. Example:[{"Bucket":"bucket_01","Selected":true,"Prefixes":["img/test_"],"Type":"exclude"}]
 * @property callbackId The ID of the primary key of the notification message bound to the oss stock scan task.
 * @property endDate The end time of the file upload time range indicates the scanning of files uploaded before this time point.
 * @property imageAdFreezeConfig Picture automatically freezes the configuration of ad scenes. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
 * @property imageAutoFreezeOpened Picture detection auto freeze switch. Value: true: auto freeze, false: not auto freeze.
 * @property imageLiveFreezeConfig Picture automatic freezing live scene configuration. Example:{"type":"suggestion","value":"block,review"}. The result will be frozen according to the suggestion in the picture detection result.
 * @property imageOpened oss stock scan task detect images. true: scan images, false: do not scan images
 * @property imagePornFreezeConfig Picture automatic freezing porn scene configuration. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
 * @property imageScanLimit The upper limit for scanning images in the oss stock scan task. The default value is 10000 images per Bucket.
 * @property imageScenes The image moderation scenario included in the oss stock scan task.Valid values: porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection
 * @property imageTerrorismFreezeConfig The picture automatically freezes the configuration of terrorism scenes. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
 * @property scanImageNoFileType Whether the oss stock scan task detects images with file names without suffixes. true: Detect pictures with file names without suffixes, false: Do not detect pictures with file names without suffixes
 * @property startDate The start time of the file upload time range represents the files uploaded after scanning this time point.
 * @property videoAdFreezeConfig The video automatically freezes the configuration of ad scenarios. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
 * @property videoAutoFreezeOpened Video detection auto freeze switch. Value: true: automatically freeze, false: not automatically freeze.
 * @property videoFrameInterval Resource attribute field representing the framing frequency. 1~60 seconds/frame, the default is 1 second/frame
 * @property videoLiveFreezeConfig Video automatic freeze live scene configuration. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
 * @property videoMaxFrames A resource attribute field that represents the upper limit of a single video frame cut. 5 to 20000 frames, the default is 200 frames
 * @property videoMaxSize Resource property field representing the maximum size of a single video. 1~2048MB, the default is 500MB, more than not detected.
 * @property videoOpened oss stock scan task detect video. true: scan video, false: do not scan video
 * @property videoPornFreezeConfig Video automatic freezing porn scene configuration. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the video detection result.
 * @property videoScanLimit The upper limit of video scanning in the oss stock scan task. The default value is 1000/Bucket.
 * @property videoScenes The video detection scenarios included in the oss stock scan task. porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection antispam: Video voice antispam
 * @property videoTerrorismFreezeConfig The video automatically freezes the configuration of terrorism scenes. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
 * @property videoVoiceAntispamFreezeConfig Voice auto freeze configuration in video. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
 */
public data class OssStockTaskArgs(
    public val audioAntispamFreezeConfig: Output<String>? = null,
    public val audioAutoFreezeOpened: Output<Boolean>? = null,
    public val audioMaxSize: Output<Int>? = null,
    public val audioOpened: Output<Boolean>? = null,
    public val audioScanLimit: Output<Int>? = null,
    public val audioScenes: Output<String>? = null,
    public val autoFreezeType: Output<String>? = null,
    public val bizType: Output<String>? = null,
    public val buckets: Output<String>? = null,
    public val callbackId: Output<Int>? = null,
    public val endDate: Output<String>? = null,
    public val imageAdFreezeConfig: Output<String>? = null,
    public val imageAutoFreezeOpened: Output<Boolean>? = null,
    public val imageLiveFreezeConfig: Output<String>? = null,
    public val imageOpened: Output<Boolean>? = null,
    public val imagePornFreezeConfig: Output<String>? = null,
    public val imageScanLimit: Output<Int>? = null,
    public val imageScenes: Output<List<String>>? = null,
    public val imageTerrorismFreezeConfig: Output<String>? = null,
    public val scanImageNoFileType: Output<Boolean>? = null,
    public val startDate: Output<String>? = null,
    public val videoAdFreezeConfig: Output<String>? = null,
    public val videoAutoFreezeOpened: Output<Boolean>? = null,
    public val videoFrameInterval: Output<Int>? = null,
    public val videoLiveFreezeConfig: Output<String>? = null,
    public val videoMaxFrames: Output<Int>? = null,
    public val videoMaxSize: Output<Int>? = null,
    public val videoOpened: Output<Boolean>? = null,
    public val videoPornFreezeConfig: Output<String>? = null,
    public val videoScanLimit: Output<Int>? = null,
    public val videoScenes: Output<String>? = null,
    public val videoTerrorismFreezeConfig: Output<String>? = null,
    public val videoVoiceAntispamFreezeConfig: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.aligreen.OssStockTaskArgs> {
    override fun toJava(): com.pulumi.alicloud.aligreen.OssStockTaskArgs =
        com.pulumi.alicloud.aligreen.OssStockTaskArgs.builder()
            .audioAntispamFreezeConfig(audioAntispamFreezeConfig?.applyValue({ args0 -> args0 }))
            .audioAutoFreezeOpened(audioAutoFreezeOpened?.applyValue({ args0 -> args0 }))
            .audioMaxSize(audioMaxSize?.applyValue({ args0 -> args0 }))
            .audioOpened(audioOpened?.applyValue({ args0 -> args0 }))
            .audioScanLimit(audioScanLimit?.applyValue({ args0 -> args0 }))
            .audioScenes(audioScenes?.applyValue({ args0 -> args0 }))
            .autoFreezeType(autoFreezeType?.applyValue({ args0 -> args0 }))
            .bizType(bizType?.applyValue({ args0 -> args0 }))
            .buckets(buckets?.applyValue({ args0 -> args0 }))
            .callbackId(callbackId?.applyValue({ args0 -> args0 }))
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .imageAdFreezeConfig(imageAdFreezeConfig?.applyValue({ args0 -> args0 }))
            .imageAutoFreezeOpened(imageAutoFreezeOpened?.applyValue({ args0 -> args0 }))
            .imageLiveFreezeConfig(imageLiveFreezeConfig?.applyValue({ args0 -> args0 }))
            .imageOpened(imageOpened?.applyValue({ args0 -> args0 }))
            .imagePornFreezeConfig(imagePornFreezeConfig?.applyValue({ args0 -> args0 }))
            .imageScanLimit(imageScanLimit?.applyValue({ args0 -> args0 }))
            .imageScenes(imageScenes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .imageTerrorismFreezeConfig(imageTerrorismFreezeConfig?.applyValue({ args0 -> args0 }))
            .scanImageNoFileType(scanImageNoFileType?.applyValue({ args0 -> args0 }))
            .startDate(startDate?.applyValue({ args0 -> args0 }))
            .videoAdFreezeConfig(videoAdFreezeConfig?.applyValue({ args0 -> args0 }))
            .videoAutoFreezeOpened(videoAutoFreezeOpened?.applyValue({ args0 -> args0 }))
            .videoFrameInterval(videoFrameInterval?.applyValue({ args0 -> args0 }))
            .videoLiveFreezeConfig(videoLiveFreezeConfig?.applyValue({ args0 -> args0 }))
            .videoMaxFrames(videoMaxFrames?.applyValue({ args0 -> args0 }))
            .videoMaxSize(videoMaxSize?.applyValue({ args0 -> args0 }))
            .videoOpened(videoOpened?.applyValue({ args0 -> args0 }))
            .videoPornFreezeConfig(videoPornFreezeConfig?.applyValue({ args0 -> args0 }))
            .videoScanLimit(videoScanLimit?.applyValue({ args0 -> args0 }))
            .videoScenes(videoScenes?.applyValue({ args0 -> args0 }))
            .videoTerrorismFreezeConfig(videoTerrorismFreezeConfig?.applyValue({ args0 -> args0 }))
            .videoVoiceAntispamFreezeConfig(
                videoVoiceAntispamFreezeConfig?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [OssStockTaskArgs].
 */
@PulumiTagMarker
public class OssStockTaskArgsBuilder internal constructor() {
    private var audioAntispamFreezeConfig: Output<String>? = null

    private var audioAutoFreezeOpened: Output<Boolean>? = null

    private var audioMaxSize: Output<Int>? = null

    private var audioOpened: Output<Boolean>? = null

    private var audioScanLimit: Output<Int>? = null

    private var audioScenes: Output<String>? = null

    private var autoFreezeType: Output<String>? = null

    private var bizType: Output<String>? = null

    private var buckets: Output<String>? = null

    private var callbackId: Output<Int>? = null

    private var endDate: Output<String>? = null

    private var imageAdFreezeConfig: Output<String>? = null

    private var imageAutoFreezeOpened: Output<Boolean>? = null

    private var imageLiveFreezeConfig: Output<String>? = null

    private var imageOpened: Output<Boolean>? = null

    private var imagePornFreezeConfig: Output<String>? = null

    private var imageScanLimit: Output<Int>? = null

    private var imageScenes: Output<List<String>>? = null

    private var imageTerrorismFreezeConfig: Output<String>? = null

    private var scanImageNoFileType: Output<Boolean>? = null

    private var startDate: Output<String>? = null

    private var videoAdFreezeConfig: Output<String>? = null

    private var videoAutoFreezeOpened: Output<Boolean>? = null

    private var videoFrameInterval: Output<Int>? = null

    private var videoLiveFreezeConfig: Output<String>? = null

    private var videoMaxFrames: Output<Int>? = null

    private var videoMaxSize: Output<Int>? = null

    private var videoOpened: Output<Boolean>? = null

    private var videoPornFreezeConfig: Output<String>? = null

    private var videoScanLimit: Output<Int>? = null

    private var videoScenes: Output<String>? = null

    private var videoTerrorismFreezeConfig: Output<String>? = null

    private var videoVoiceAntispamFreezeConfig: Output<String>? = null

    /**
     * @param value Voice auto freeze configuration. Example:{"type":"suggestion","value":"block,review"}. The results are frozen according to the suggestion in the speech detection results.
     */
    @JvmName("sehbfaawqsybrusj")
    public suspend fun audioAntispamFreezeConfig(`value`: Output<String>) {
        this.audioAntispamFreezeConfig = value
    }

    /**
     * @param value Audio detection auto freeze switch. Value: true: automatically freeze, false: not automatically freeze.
     */
    @JvmName("aevgdpmysecimxvx")
    public suspend fun audioAutoFreezeOpened(`value`: Output<Boolean>) {
        this.audioAutoFreezeOpened = value
    }

    /**
     * @param value Resource property field representing the maximum size of a single audio. 1~2048MB, the default is 200MB, more than not detected.
     */
    @JvmName("cxwhxqncrsrsyvwa")
    public suspend fun audioMaxSize(`value`: Output<Int>) {
        this.audioMaxSize = value
    }

    /**
     * @param value oss stock scan task detect audio. true: scan audio, false: do not scan audio
     */
    @JvmName("hquqiunmnvmtrabx")
    public suspend fun audioOpened(`value`: Output<Boolean>) {
        this.audioOpened = value
    }

    /**
     * @param value The upper limit of voice scan in the oss stock scan task. The default value is 1000/Bucket.
     */
    @JvmName("xjfxwbfwjjfhxdeu")
    public suspend fun audioScanLimit(`value`: Output<Int>) {
        this.audioScanLimit = value
    }

    /**
     * @param value The audio detection scenarios included in the oss stock scan task. Set the value to antispam.
     */
    @JvmName("wrqbxrpgqeeoegvi")
    public suspend fun audioScenes(`value`: Output<String>) {
        this.audioScenes = value
    }

    /**
     * @param value Automatic freeze type. Value: acl: modify permissions, copy: Move files
     */
    @JvmName("amoqnfnarhukraux")
    public suspend fun autoFreezeType(`value`: Output<String>) {
        this.autoFreezeType = value
    }

    /**
     * @param value Business scenarios used by the oss stock scan task
     */
    @JvmName("rsdnhboaqkvbyxab")
    public suspend fun bizType(`value`: Output<String>) {
        this.bizType = value
    }

    /**
     * @param value The bucket configuration list of the oss stock scan task. Example:[{"Bucket":"bucket_01","Selected":true,"Prefixes":["img/test_"],"Type":"exclude"}]
     */
    @JvmName("wxidthfctxbiadwp")
    public suspend fun buckets(`value`: Output<String>) {
        this.buckets = value
    }

    /**
     * @param value The ID of the primary key of the notification message bound to the oss stock scan task.
     */
    @JvmName("jptbxqkjbbgblucr")
    public suspend fun callbackId(`value`: Output<Int>) {
        this.callbackId = value
    }

    /**
     * @param value The end time of the file upload time range indicates the scanning of files uploaded before this time point.
     */
    @JvmName("hcckfmmaysndwjhu")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value Picture automatically freezes the configuration of ad scenes. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    @JvmName("qfbjutexuguecdqi")
    public suspend fun imageAdFreezeConfig(`value`: Output<String>) {
        this.imageAdFreezeConfig = value
    }

    /**
     * @param value Picture detection auto freeze switch. Value: true: auto freeze, false: not auto freeze.
     */
    @JvmName("yvruxpmkpxkkyqjk")
    public suspend fun imageAutoFreezeOpened(`value`: Output<Boolean>) {
        this.imageAutoFreezeOpened = value
    }

    /**
     * @param value Picture automatic freezing live scene configuration. Example:{"type":"suggestion","value":"block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    @JvmName("baaksbdrhaxdoiog")
    public suspend fun imageLiveFreezeConfig(`value`: Output<String>) {
        this.imageLiveFreezeConfig = value
    }

    /**
     * @param value oss stock scan task detect images. true: scan images, false: do not scan images
     */
    @JvmName("cgqgstbfyocomfsp")
    public suspend fun imageOpened(`value`: Output<Boolean>) {
        this.imageOpened = value
    }

    /**
     * @param value Picture automatic freezing porn scene configuration. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    @JvmName("qbursoxtsggspvbg")
    public suspend fun imagePornFreezeConfig(`value`: Output<String>) {
        this.imagePornFreezeConfig = value
    }

    /**
     * @param value The upper limit for scanning images in the oss stock scan task. The default value is 10000 images per Bucket.
     */
    @JvmName("pnrdynwhxjgoedxj")
    public suspend fun imageScanLimit(`value`: Output<Int>) {
        this.imageScanLimit = value
    }

    /**
     * @param value The image moderation scenario included in the oss stock scan task.Valid values: porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection
     */
    @JvmName("kfjnrptehrenprix")
    public suspend fun imageScenes(`value`: Output<List<String>>) {
        this.imageScenes = value
    }

    @JvmName("mxeiybipqaaboubt")
    public suspend fun imageScenes(vararg values: Output<String>) {
        this.imageScenes = Output.all(values.asList())
    }

    /**
     * @param values The image moderation scenario included in the oss stock scan task.Valid values: porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection
     */
    @JvmName("pxqkglsdqreubvpk")
    public suspend fun imageScenes(values: List<Output<String>>) {
        this.imageScenes = Output.all(values)
    }

    /**
     * @param value The picture automatically freezes the configuration of terrorism scenes. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    @JvmName("qmsljhurntyorwqw")
    public suspend fun imageTerrorismFreezeConfig(`value`: Output<String>) {
        this.imageTerrorismFreezeConfig = value
    }

    /**
     * @param value Whether the oss stock scan task detects images with file names without suffixes. true: Detect pictures with file names without suffixes, false: Do not detect pictures with file names without suffixes
     */
    @JvmName("xlyiuwplfhynumkw")
    public suspend fun scanImageNoFileType(`value`: Output<Boolean>) {
        this.scanImageNoFileType = value
    }

    /**
     * @param value The start time of the file upload time range represents the files uploaded after scanning this time point.
     */
    @JvmName("awnxsytnanhtqtbd")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value The video automatically freezes the configuration of ad scenarios. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    @JvmName("cbpnrnucgdqrldxt")
    public suspend fun videoAdFreezeConfig(`value`: Output<String>) {
        this.videoAdFreezeConfig = value
    }

    /**
     * @param value Video detection auto freeze switch. Value: true: automatically freeze, false: not automatically freeze.
     */
    @JvmName("qhcpwoibhqlvpxdr")
    public suspend fun videoAutoFreezeOpened(`value`: Output<Boolean>) {
        this.videoAutoFreezeOpened = value
    }

    /**
     * @param value Resource attribute field representing the framing frequency. 1~60 seconds/frame, the default is 1 second/frame
     */
    @JvmName("kiomyfysxtekpixh")
    public suspend fun videoFrameInterval(`value`: Output<Int>) {
        this.videoFrameInterval = value
    }

    /**
     * @param value Video automatic freeze live scene configuration. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    @JvmName("wbncnjnubflavlfo")
    public suspend fun videoLiveFreezeConfig(`value`: Output<String>) {
        this.videoLiveFreezeConfig = value
    }

    /**
     * @param value A resource attribute field that represents the upper limit of a single video frame cut. 5 to 20000 frames, the default is 200 frames
     */
    @JvmName("xlkontxldqwaiefg")
    public suspend fun videoMaxFrames(`value`: Output<Int>) {
        this.videoMaxFrames = value
    }

    /**
     * @param value Resource property field representing the maximum size of a single video. 1~2048MB, the default is 500MB, more than not detected.
     */
    @JvmName("helyqhisfifchhbs")
    public suspend fun videoMaxSize(`value`: Output<Int>) {
        this.videoMaxSize = value
    }

    /**
     * @param value oss stock scan task detect video. true: scan video, false: do not scan video
     */
    @JvmName("qydrucrslbkvkhxj")
    public suspend fun videoOpened(`value`: Output<Boolean>) {
        this.videoOpened = value
    }

    /**
     * @param value Video automatic freezing porn scene configuration. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the video detection result.
     */
    @JvmName("kshtdhiefuskfblh")
    public suspend fun videoPornFreezeConfig(`value`: Output<String>) {
        this.videoPornFreezeConfig = value
    }

    /**
     * @param value The upper limit of video scanning in the oss stock scan task. The default value is 1000/Bucket.
     */
    @JvmName("rdahojeacbkkjmya")
    public suspend fun videoScanLimit(`value`: Output<Int>) {
        this.videoScanLimit = value
    }

    /**
     * @param value The video detection scenarios included in the oss stock scan task. porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection antispam: Video voice antispam
     */
    @JvmName("iigscvtoolhuuyxx")
    public suspend fun videoScenes(`value`: Output<String>) {
        this.videoScenes = value
    }

    /**
     * @param value The video automatically freezes the configuration of terrorism scenes. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    @JvmName("knwvkyuwobmwynvm")
    public suspend fun videoTerrorismFreezeConfig(`value`: Output<String>) {
        this.videoTerrorismFreezeConfig = value
    }

    /**
     * @param value Voice auto freeze configuration in video. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    @JvmName("fsfnprhwgmcqnhlr")
    public suspend fun videoVoiceAntispamFreezeConfig(`value`: Output<String>) {
        this.videoVoiceAntispamFreezeConfig = value
    }

    /**
     * @param value Voice auto freeze configuration. Example:{"type":"suggestion","value":"block,review"}. The results are frozen according to the suggestion in the speech detection results.
     */
    @JvmName("lfppvawvdgohrwop")
    public suspend fun audioAntispamFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioAntispamFreezeConfig = mapped
    }

    /**
     * @param value Audio detection auto freeze switch. Value: true: automatically freeze, false: not automatically freeze.
     */
    @JvmName("yetjgtcwfdbbqgvp")
    public suspend fun audioAutoFreezeOpened(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioAutoFreezeOpened = mapped
    }

    /**
     * @param value Resource property field representing the maximum size of a single audio. 1~2048MB, the default is 200MB, more than not detected.
     */
    @JvmName("fvjwtkgnfdrdxtcr")
    public suspend fun audioMaxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioMaxSize = mapped
    }

    /**
     * @param value oss stock scan task detect audio. true: scan audio, false: do not scan audio
     */
    @JvmName("ycpjmgoaqupkcbph")
    public suspend fun audioOpened(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioOpened = mapped
    }

    /**
     * @param value The upper limit of voice scan in the oss stock scan task. The default value is 1000/Bucket.
     */
    @JvmName("cmjnoyekxgaofvfj")
    public suspend fun audioScanLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioScanLimit = mapped
    }

    /**
     * @param value The audio detection scenarios included in the oss stock scan task. Set the value to antispam.
     */
    @JvmName("eabseydfvycltulj")
    public suspend fun audioScenes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioScenes = mapped
    }

    /**
     * @param value Automatic freeze type. Value: acl: modify permissions, copy: Move files
     */
    @JvmName("dkeebmnanvqmvswi")
    public suspend fun autoFreezeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoFreezeType = mapped
    }

    /**
     * @param value Business scenarios used by the oss stock scan task
     */
    @JvmName("bjqrrxheqocjmjhx")
    public suspend fun bizType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizType = mapped
    }

    /**
     * @param value The bucket configuration list of the oss stock scan task. Example:[{"Bucket":"bucket_01","Selected":true,"Prefixes":["img/test_"],"Type":"exclude"}]
     */
    @JvmName("kpmhwsoavkjsomon")
    public suspend fun buckets(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buckets = mapped
    }

    /**
     * @param value The ID of the primary key of the notification message bound to the oss stock scan task.
     */
    @JvmName("nptqcuggockypcgg")
    public suspend fun callbackId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callbackId = mapped
    }

    /**
     * @param value The end time of the file upload time range indicates the scanning of files uploaded before this time point.
     */
    @JvmName("kjiylngudqlqftya")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value Picture automatically freezes the configuration of ad scenes. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    @JvmName("qxghkyxwmombwort")
    public suspend fun imageAdFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageAdFreezeConfig = mapped
    }

    /**
     * @param value Picture detection auto freeze switch. Value: true: auto freeze, false: not auto freeze.
     */
    @JvmName("brpnhggnfivfppou")
    public suspend fun imageAutoFreezeOpened(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageAutoFreezeOpened = mapped
    }

    /**
     * @param value Picture automatic freezing live scene configuration. Example:{"type":"suggestion","value":"block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    @JvmName("jtmxbphehlbkrtua")
    public suspend fun imageLiveFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageLiveFreezeConfig = mapped
    }

    /**
     * @param value oss stock scan task detect images. true: scan images, false: do not scan images
     */
    @JvmName("ekllwwboimyfrtnx")
    public suspend fun imageOpened(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageOpened = mapped
    }

    /**
     * @param value Picture automatic freezing porn scene configuration. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    @JvmName("vmaqdvbyycsdahqg")
    public suspend fun imagePornFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePornFreezeConfig = mapped
    }

    /**
     * @param value The upper limit for scanning images in the oss stock scan task. The default value is 10000 images per Bucket.
     */
    @JvmName("fwsjbgqhgpjrqefu")
    public suspend fun imageScanLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageScanLimit = mapped
    }

    /**
     * @param value The image moderation scenario included in the oss stock scan task.Valid values: porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection
     */
    @JvmName("fvhsgopuvilmhauh")
    public suspend fun imageScenes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageScenes = mapped
    }

    /**
     * @param values The image moderation scenario included in the oss stock scan task.Valid values: porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection
     */
    @JvmName("iqpbdaxwcmgxrhxd")
    public suspend fun imageScenes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageScenes = mapped
    }

    /**
     * @param value The picture automatically freezes the configuration of terrorism scenes. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the picture detection result.
     */
    @JvmName("uwxfbxsidjtbxfwj")
    public suspend fun imageTerrorismFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTerrorismFreezeConfig = mapped
    }

    /**
     * @param value Whether the oss stock scan task detects images with file names without suffixes. true: Detect pictures with file names without suffixes, false: Do not detect pictures with file names without suffixes
     */
    @JvmName("qnvsgnglnsuijcuf")
    public suspend fun scanImageNoFileType(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanImageNoFileType = mapped
    }

    /**
     * @param value The start time of the file upload time range represents the files uploaded after scanning this time point.
     */
    @JvmName("dkfmfughhoogvqep")
    public suspend fun startDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    /**
     * @param value The video automatically freezes the configuration of ad scenarios. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    @JvmName("qljjuyplobfuqwpo")
    public suspend fun videoAdFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoAdFreezeConfig = mapped
    }

    /**
     * @param value Video detection auto freeze switch. Value: true: automatically freeze, false: not automatically freeze.
     */
    @JvmName("klxtitvfqcwjlpmv")
    public suspend fun videoAutoFreezeOpened(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoAutoFreezeOpened = mapped
    }

    /**
     * @param value Resource attribute field representing the framing frequency. 1~60 seconds/frame, the default is 1 second/frame
     */
    @JvmName("gbhmjpuebgugefpf")
    public suspend fun videoFrameInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoFrameInterval = mapped
    }

    /**
     * @param value Video automatic freeze live scene configuration. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    @JvmName("gnpwpkgsjosniqel")
    public suspend fun videoLiveFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoLiveFreezeConfig = mapped
    }

    /**
     * @param value A resource attribute field that represents the upper limit of a single video frame cut. 5 to 20000 frames, the default is 200 frames
     */
    @JvmName("chetrudxiidcueha")
    public suspend fun videoMaxFrames(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoMaxFrames = mapped
    }

    /**
     * @param value Resource property field representing the maximum size of a single video. 1~2048MB, the default is 500MB, more than not detected.
     */
    @JvmName("bihngtmgtewodtit")
    public suspend fun videoMaxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoMaxSize = mapped
    }

    /**
     * @param value oss stock scan task detect video. true: scan video, false: do not scan video
     */
    @JvmName("angolgisglglviuj")
    public suspend fun videoOpened(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoOpened = mapped
    }

    /**
     * @param value Video automatic freezing porn scene configuration. Example: {"type": "suggestion", "value": "block,review"}. The result will be frozen according to the suggestion in the video detection result.
     */
    @JvmName("hmfxihywvjoqihtc")
    public suspend fun videoPornFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoPornFreezeConfig = mapped
    }

    /**
     * @param value The upper limit of video scanning in the oss stock scan task. The default value is 1000/Bucket.
     */
    @JvmName("oduhbcfbmubtlvki")
    public suspend fun videoScanLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoScanLimit = mapped
    }

    /**
     * @param value The video detection scenarios included in the oss stock scan task. porn: pornography detection terrorism: terrorist content detection ad: ad violation detection live: undesirable scene detection antispam: Video voice antispam
     */
    @JvmName("vmjxvqqcrrfksegb")
    public suspend fun videoScenes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoScenes = mapped
    }

    /**
     * @param value The video automatically freezes the configuration of terrorism scenes. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    @JvmName("qhuamimfuhkyfbnx")
    public suspend fun videoTerrorismFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoTerrorismFreezeConfig = mapped
    }

    /**
     * @param value Voice auto freeze configuration in video. Example:{"type":"suggestion","value":"block,review"}. The results will be frozen according to the suggestion in the video detection results.
     */
    @JvmName("hxbcpnkcalbjpbbb")
    public suspend fun videoVoiceAntispamFreezeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoVoiceAntispamFreezeConfig = mapped
    }

    internal fun build(): OssStockTaskArgs = OssStockTaskArgs(
        audioAntispamFreezeConfig = audioAntispamFreezeConfig,
        audioAutoFreezeOpened = audioAutoFreezeOpened,
        audioMaxSize = audioMaxSize,
        audioOpened = audioOpened,
        audioScanLimit = audioScanLimit,
        audioScenes = audioScenes,
        autoFreezeType = autoFreezeType,
        bizType = bizType,
        buckets = buckets,
        callbackId = callbackId,
        endDate = endDate,
        imageAdFreezeConfig = imageAdFreezeConfig,
        imageAutoFreezeOpened = imageAutoFreezeOpened,
        imageLiveFreezeConfig = imageLiveFreezeConfig,
        imageOpened = imageOpened,
        imagePornFreezeConfig = imagePornFreezeConfig,
        imageScanLimit = imageScanLimit,
        imageScenes = imageScenes,
        imageTerrorismFreezeConfig = imageTerrorismFreezeConfig,
        scanImageNoFileType = scanImageNoFileType,
        startDate = startDate,
        videoAdFreezeConfig = videoAdFreezeConfig,
        videoAutoFreezeOpened = videoAutoFreezeOpened,
        videoFrameInterval = videoFrameInterval,
        videoLiveFreezeConfig = videoLiveFreezeConfig,
        videoMaxFrames = videoMaxFrames,
        videoMaxSize = videoMaxSize,
        videoOpened = videoOpened,
        videoPornFreezeConfig = videoPornFreezeConfig,
        videoScanLimit = videoScanLimit,
        videoScenes = videoScenes,
        videoTerrorismFreezeConfig = videoTerrorismFreezeConfig,
        videoVoiceAntispamFreezeConfig = videoVoiceAntispamFreezeConfig,
    )
}
