@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alikafka.kotlin

import com.pulumi.alicloud.alikafka.ConsumerGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ALIKAFKA consumer group resource, see [What is alikafka consumer group](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/api-alikafka-2019-09-16-createconsumergroup).
 * > **NOTE:** Available since v1.56.0.
 * > **NOTE:**  Only the following regions support create alikafka consumer group.
 * [`cn-hangzhou`,`cn-beijing`,`cn-shenzhen`,`cn-shanghai`,`cn-qingdao`,`cn-hongkong`,`cn-huhehaote`,`cn-zhangjiakou`,`cn-chengdu`,`cn-heyuan`,`ap-southeast-1`,`ap-southeast-3`,`ap-southeast-5`,`ap-northeast-1`,`eu-central-1`,`eu-west-1`,`us-west-1`,`us-east-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {cidrBlock: "172.16.0.0/12"});
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: defaultNetwork.id});
 * const defaultInstance = new alicloud.alikafka.Instance("default", {
 *     name: `${name}-${defaultInteger.result}`,
 *     partitionNum: 50,
 *     diskType: 1,
 *     diskSize: 500,
 *     deployType: 5,
 *     ioMax: 20,
 *     vswitchId: defaultSwitch.id,
 *     securityGroup: defaultSecurityGroup.id,
 * });
 * const defaultConsumerGroup = new alicloud.alikafka.ConsumerGroup("default", {
 *     consumerId: name,
 *     instanceId: defaultInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default", cidr_block="172.16.0.0/12")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
 * default_instance = alicloud.alikafka.Instance("default",
 *     name=f"{name}-{default_integer['result']}",
 *     partition_num=50,
 *     disk_type=1,
 *     disk_size=500,
 *     deploy_type=5,
 *     io_max=20,
 *     vswitch_id=default_switch.id,
 *     security_group=default_security_group.id)
 * default_consumer_group = alicloud.alikafka.ConsumerGroup("default",
 *     consumer_id=name,
 *     instance_id=default_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstance = new AliCloud.AliKafka.Instance("default", new()
 *     {
 *         Name = $"{name}-{defaultInteger.Result}",
 *         PartitionNum = 50,
 *         DiskType = 1,
 *         DiskSize = 500,
 *         DeployType = 5,
 *         IoMax = 20,
 *         VswitchId = defaultSwitch.Id,
 *         SecurityGroup = defaultSecurityGroup.Id,
 *     });
 *     var defaultConsumerGroup = new AliCloud.AliKafka.ConsumerGroup("default", new()
 *     {
 *         ConsumerId = name,
 *         InstanceId = defaultInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alikafka"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:     defaultNetwork.ID(),
 * 			CidrBlock: pulumi.String("172.16.0.0/24"),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := alikafka.NewInstance(ctx, "default", &alikafka.InstanceArgs{
 * 			Name:          pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			PartitionNum:  pulumi.Int(50),
 * 			DiskType:      pulumi.Int(1),
 * 			DiskSize:      pulumi.Int(500),
 * 			DeployType:    pulumi.Int(5),
 * 			IoMax:         pulumi.Int(20),
 * 			VswitchId:     defaultSwitch.ID(),
 * 			SecurityGroup: defaultSecurityGroup.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = alikafka.NewConsumerGroup(ctx, "default", &alikafka.ConsumerGroupArgs{
 * 			ConsumerId: pulumi.String(name),
 * 			InstanceId: defaultInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.alikafka.Instance;
 * import com.pulumi.alicloud.alikafka.InstanceArgs;
 * import com.pulumi.alicloud.alikafka.ConsumerGroup;
 * import com.pulumi.alicloud.alikafka.ConsumerGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .name(String.format("%s-%s", name,defaultInteger.result()))
 *             .partitionNum("50")
 *             .diskType("1")
 *             .diskSize("500")
 *             .deployType("5")
 *             .ioMax("20")
 *             .vswitchId(defaultSwitch.id())
 *             .securityGroup(defaultSecurityGroup.id())
 *             .build());
 *         var defaultConsumerGroup = new ConsumerGroup("defaultConsumerGroup", ConsumerGroupArgs.builder()
 *             .consumerId(name)
 *             .instanceId(defaultInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *   defaultInstance:
 *     type: alicloud:alikafka:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${defaultInteger.result}
 *       partitionNum: '50'
 *       diskType: '1'
 *       diskSize: '500'
 *       deployType: '5'
 *       ioMax: '20'
 *       vswitchId: ${defaultSwitch.id}
 *       securityGroup: ${defaultSecurityGroup.id}
 *   defaultConsumerGroup:
 *     type: alicloud:alikafka:ConsumerGroup
 *     name: default
 *     properties:
 *       consumerId: ${name}
 *       instanceId: ${defaultInstance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ALIKAFKA GROUP can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alikafka/consumerGroup:ConsumerGroup group alikafka_post-cn-123455abc:consumerId
 * ```
 * @property consumerId ID of the consumer group. The length cannot exceed 64 characters.
 * @property description The description of the resource.
 * @property instanceId ID of the ALIKAFKA Instance that owns the groups.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class ConsumerGroupArgs(
    public val consumerId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alikafka.ConsumerGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.alikafka.ConsumerGroupArgs =
        com.pulumi.alicloud.alikafka.ConsumerGroupArgs.builder()
            .consumerId(consumerId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConsumerGroupArgs].
 */
@PulumiTagMarker
public class ConsumerGroupArgsBuilder internal constructor() {
    private var consumerId: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ID of the consumer group. The length cannot exceed 64 characters.
     */
    @JvmName("isoxnrdilrchlsqd")
    public suspend fun consumerId(`value`: Output<String>) {
        this.consumerId = value
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("wnhxvgrxrvtwywoq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ID of the ALIKAFKA Instance that owns the groups.
     */
    @JvmName("ftmfuftbcrfibtkk")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("pkqpwhstrsboyyso")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the consumer group. The length cannot exceed 64 characters.
     */
    @JvmName("erqdohxlqkkqdras")
    public suspend fun consumerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerId = mapped
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("ftfdopkdqtrdgwei")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ID of the ALIKAFKA Instance that owns the groups.
     */
    @JvmName("nbdkrnvajwgyypbn")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("didcpnmdochswuqk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("klcndenlyfomkuou")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConsumerGroupArgs = ConsumerGroupArgs(
        consumerId = consumerId,
        description = description,
        instanceId = instanceId,
        tags = tags,
    )
}
