@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alikafka.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.alikafka.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * AliKafka instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alikafka/instance:Instance instance <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.alikafka.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
     * * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
     */
    public val config: Output<String>
        get() = javaResource.config().applyValue({ args0 -> args0 })

    /**
     * The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
     * - 4: eip/vpc instance
     * - 5: vpc instance.
     */
    public val deployType: Output<Int>
        get() = javaResource.deployType().applyValue({ args0 -> args0 })

    /**
     * The disk size of the instance. When modify this value, it only supports adjust to a greater value.
     */
    public val diskSize: Output<Int>
        get() = javaResource.diskSize().applyValue({ args0 -> args0 })

    /**
     * The disk type of the instance. 0: efficient cloud disk , 1: SSD.
     */
    public val diskType: Output<Int>
        get() = javaResource.diskType().applyValue({ args0 -> args0 })

    /**
     * The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
     */
    public val eipMax: Output<Int>
        get() = javaResource.eipMax().applyValue({ args0 -> args0 })

    /**
     * The EndPoint to access the kafka instance.
     */
    public val endPoint: Output<String>
        get() = javaResource.endPoint().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.214.1) The number of available groups.
     */
    public val groupLeft: Output<Int>
        get() = javaResource.groupLeft().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.214.1) The number of used groups.
     */
    public val groupUsed: Output<Int>
        get() = javaResource.groupUsed().applyValue({ args0 -> args0 })

    /**
     * The max value of io of the instance. When modify this value, it only support adjust to a greater value.
     */
    public val ioMax: Output<Int>
        get() = javaResource.ioMax().applyValue({ args0 -> args0 })

    /**
     * The traffic specification of the instance. We recommend that you configure this parameter.
     * - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
     * - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
     */
    public val ioMaxSpec: Output<String>
        get() = javaResource.ioMaxSpec().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.214.1) The method that you use to purchase partitions.
     */
    public val isPartitionBuy: Output<Int>
        get() = javaResource.isPartitionBuy().applyValue({ args0 -> args0 })

    /**
     * The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
     */
    public val paidType: Output<String>?
        get() = javaResource.paidType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * (Available since v1.214.1) The number of available partitions.
     */
    public val partitionLeft: Output<Int>
        get() = javaResource.partitionLeft().applyValue({ args0 -> args0 })

    /**
     * The number of partitions.
     */
    public val partitionNum: Output<Int>?
        get() = javaResource.partitionNum().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * (Available since v1.214.1) The number of used partitions.
     */
    public val partitionUsed: Output<Int>
        get() = javaResource.partitionUsed().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of security group for this instance. If the security group is empty, system will create a default one.
     */
    public val securityGroup: Output<String>
        get() = javaResource.securityGroup().applyValue({ args0 -> args0 })

    /**
     * The zones among which you want to deploy the instance.
     * > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
     * | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
     * |------|-------------|:----:|:-----:|
     * |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
     * |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
     * |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
     * |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
     * |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
     */
    public val selectedZones: Output<List<String>>?
        get() = javaResource.selectedZones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The version of the ApsaraMQ for Kafka instance. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
     */
    public val serviceVersion: Output<String>
        get() = javaResource.serviceVersion().applyValue({ args0 -> args0 })

    /**
     * The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
     */
    public val specType: Output<String>?
        get() = javaResource.specType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the instance.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * (Available since v1.214.1) The number of available topics.
     */
    public val topicLeft: Output<Int>
        get() = javaResource.topicLeft().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.214.1) The number of purchased topics.
     */
    public val topicNumOfBuy: Output<Int>
        get() = javaResource.topicNumOfBuy().applyValue({ args0 -> args0 })

    /**
     * The max num of topic can be creation of the instance.
     * It has been deprecated since version 1.194.0 and using `partition_num` instead.
     * Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
     * Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
     */
    @Deprecated(
        message = """
  Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next
      future. Using new attribute `partition_num` instead.
  """,
    )
    public val topicQuota: Output<Int>
        get() = javaResource.topicQuota().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.214.1) The number of used topics.
     */
    public val topicUsed: Output<Int>
        get() = javaResource.topicUsed().applyValue({ args0 -> args0 })

    /**
     * The VPC ID of the instance.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of attaching vswitch to instance.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alikafka.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.alikafka.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
