@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alikafka.kotlin

import com.pulumi.alicloud.alikafka.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * AliKafka instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alikafka/instance:Instance instance <id>
 * ```
 * @property config The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
 * * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
 * @property deployType The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
 * - 4: eip/vpc instance
 * - 5: vpc instance.
 * @property diskSize The disk size of the instance. When modify this value, it only supports adjust to a greater value.
 * @property diskType The disk type of the instance. 0: efficient cloud disk , 1: SSD.
 * @property eipMax The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
 * @property ioMax The max value of io of the instance. When modify this value, it only support adjust to a greater value.
 * @property ioMaxSpec The traffic specification of the instance. We recommend that you configure this parameter.
 * - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
 * - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
 * @property kmsKeyId The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
 * @property name Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
 * @property paidType The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
 * @property partitionNum The number of partitions.
 * @property resourceGroupId The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
 * @property securityGroup The ID of security group for this instance. If the security group is empty, system will create a default one.
 * @property selectedZones The zones among which you want to deploy the instance.
 * > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
 * | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
 * |------|-------------|:----:|:-----:|
 * |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
 * |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
 * |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
 * |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
 * |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
 * @property serviceVersion The version of the ApsaraMQ for Kafka instance. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
 * @property specType The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
 * @property tags A mapping of tags to assign to the resource.
 * @property topicQuota The max num of topic can be creation of the instance.
 * It has been deprecated since version 1.194.0 and using `partition_num` instead.
 * Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
 * Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
 * @property vpcId The VPC ID of the instance.
 * @property vswitchId The ID of attaching vswitch to instance.
 * @property zoneId The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
 */
public data class InstanceArgs(
    public val config: Output<String>? = null,
    public val deployType: Output<Int>? = null,
    public val diskSize: Output<Int>? = null,
    public val diskType: Output<Int>? = null,
    public val eipMax: Output<Int>? = null,
    public val ioMax: Output<Int>? = null,
    public val ioMaxSpec: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val paidType: Output<String>? = null,
    public val partitionNum: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityGroup: Output<String>? = null,
    public val selectedZones: Output<List<String>>? = null,
    public val serviceVersion: Output<String>? = null,
    public val specType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    @Deprecated(
        message = """
  Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next
      future. Using new attribute `partition_num` instead.
  """,
    )
    public val topicQuota: Output<Int>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alikafka.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.alikafka.InstanceArgs =
        com.pulumi.alicloud.alikafka.InstanceArgs.builder()
            .config(config?.applyValue({ args0 -> args0 }))
            .deployType(deployType?.applyValue({ args0 -> args0 }))
            .diskSize(diskSize?.applyValue({ args0 -> args0 }))
            .diskType(diskType?.applyValue({ args0 -> args0 }))
            .eipMax(eipMax?.applyValue({ args0 -> args0 }))
            .ioMax(ioMax?.applyValue({ args0 -> args0 }))
            .ioMaxSpec(ioMaxSpec?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .paidType(paidType?.applyValue({ args0 -> args0 }))
            .partitionNum(partitionNum?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityGroup(securityGroup?.applyValue({ args0 -> args0 }))
            .selectedZones(selectedZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceVersion(serviceVersion?.applyValue({ args0 -> args0 }))
            .specType(specType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topicQuota(topicQuota?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var config: Output<String>? = null

    private var deployType: Output<Int>? = null

    private var diskSize: Output<Int>? = null

    private var diskType: Output<Int>? = null

    private var eipMax: Output<Int>? = null

    private var ioMax: Output<Int>? = null

    private var ioMaxSpec: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var paidType: Output<String>? = null

    private var partitionNum: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityGroup: Output<String>? = null

    private var selectedZones: Output<List<String>>? = null

    private var serviceVersion: Output<String>? = null

    private var specType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topicQuota: Output<Int>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
     * * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
     */
    @JvmName("awyqovwuqtfiiuer")
    public suspend fun config(`value`: Output<String>) {
        this.config = value
    }

    /**
     * @param value The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
     * - 4: eip/vpc instance
     * - 5: vpc instance.
     */
    @JvmName("mdbywbvfajdsrcld")
    public suspend fun deployType(`value`: Output<Int>) {
        this.deployType = value
    }

    /**
     * @param value The disk size of the instance. When modify this value, it only supports adjust to a greater value.
     */
    @JvmName("mankvybbgioxqjxj")
    public suspend fun diskSize(`value`: Output<Int>) {
        this.diskSize = value
    }

    /**
     * @param value The disk type of the instance. 0: efficient cloud disk , 1: SSD.
     */
    @JvmName("yaoqevchjryutegx")
    public suspend fun diskType(`value`: Output<Int>) {
        this.diskType = value
    }

    /**
     * @param value The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
     */
    @JvmName("wjfwdbfukwfsardf")
    public suspend fun eipMax(`value`: Output<Int>) {
        this.eipMax = value
    }

    /**
     * @param value The max value of io of the instance. When modify this value, it only support adjust to a greater value.
     */
    @JvmName("eftmabshsnxnpnhd")
    public suspend fun ioMax(`value`: Output<Int>) {
        this.ioMax = value
    }

    /**
     * @param value The traffic specification of the instance. We recommend that you configure this parameter.
     * - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
     * - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
     */
    @JvmName("oejqrybxgwfcpioo")
    public suspend fun ioMaxSpec(`value`: Output<String>) {
        this.ioMaxSpec = value
    }

    /**
     * @param value The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
     */
    @JvmName("oxrgmlapcyignphs")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
     */
    @JvmName("lnphfdrhgkeijyki")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
     */
    @JvmName("oitvpigsxilocvfi")
    public suspend fun paidType(`value`: Output<String>) {
        this.paidType = value
    }

    /**
     * @param value The number of partitions.
     */
    @JvmName("tyrpqnlphscwfepg")
    public suspend fun partitionNum(`value`: Output<Int>) {
        this.partitionNum = value
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("sapkkwmyllipxyrw")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The ID of security group for this instance. If the security group is empty, system will create a default one.
     */
    @JvmName("alarjdlywcqyyrpn")
    public suspend fun securityGroup(`value`: Output<String>) {
        this.securityGroup = value
    }

    /**
     * @param value The zones among which you want to deploy the instance.
     * > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
     * | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
     * |------|-------------|:----:|:-----:|
     * |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
     * |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
     * |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
     * |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
     * |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
     */
    @JvmName("qfhjliieibxifoww")
    public suspend fun selectedZones(`value`: Output<List<String>>) {
        this.selectedZones = value
    }

    @JvmName("aheicglamgdjtqxp")
    public suspend fun selectedZones(vararg values: Output<String>) {
        this.selectedZones = Output.all(values.asList())
    }

    /**
     * @param values The zones among which you want to deploy the instance.
     * > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
     * | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
     * |------|-------------|:----:|:-----:|
     * |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
     * |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
     * |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
     * |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
     * |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
     */
    @JvmName("vpkhimxlpbuvqbcs")
    public suspend fun selectedZones(values: List<Output<String>>) {
        this.selectedZones = Output.all(values)
    }

    /**
     * @param value The version of the ApsaraMQ for Kafka instance. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
     */
    @JvmName("cynkckmvpsemfikg")
    public suspend fun serviceVersion(`value`: Output<String>) {
        this.serviceVersion = value
    }

    /**
     * @param value The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
     */
    @JvmName("iumkosdbxfudnact")
    public suspend fun specType(`value`: Output<String>) {
        this.specType = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("wggjhffmytatrpgi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The max num of topic can be creation of the instance.
     * It has been deprecated since version 1.194.0 and using `partition_num` instead.
     * Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
     * Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
     */
    @Deprecated(
        message = """
  Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next
      future. Using new attribute `partition_num` instead.
  """,
    )
    @JvmName("sfxaijtfaaqojcwq")
    public suspend fun topicQuota(`value`: Output<Int>) {
        this.topicQuota = value
    }

    /**
     * @param value The VPC ID of the instance.
     */
    @JvmName("utjlmvbkggooxptf")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of attaching vswitch to instance.
     */
    @JvmName("exyxxnmiwdaqiqpc")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
     */
    @JvmName("mlnrpnoukyyctaaw")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
     * * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
     */
    @JvmName("jnwlehbnfnhxifoh")
    public suspend fun config(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
     * - 4: eip/vpc instance
     * - 5: vpc instance.
     */
    @JvmName("lloxtsafghrbbpcv")
    public suspend fun deployType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployType = mapped
    }

    /**
     * @param value The disk size of the instance. When modify this value, it only supports adjust to a greater value.
     */
    @JvmName("pdfknxrsevfudtqe")
    public suspend fun diskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSize = mapped
    }

    /**
     * @param value The disk type of the instance. 0: efficient cloud disk , 1: SSD.
     */
    @JvmName("yiasrxsjqtbugefd")
    public suspend fun diskType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
     */
    @JvmName("iugeyjdacgceoodh")
    public suspend fun eipMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipMax = mapped
    }

    /**
     * @param value The max value of io of the instance. When modify this value, it only support adjust to a greater value.
     */
    @JvmName("hvrqawbmjprpmjsp")
    public suspend fun ioMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioMax = mapped
    }

    /**
     * @param value The traffic specification of the instance. We recommend that you configure this parameter.
     * - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
     * - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
     */
    @JvmName("iksrjakkuivsqtet")
    public suspend fun ioMaxSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioMaxSpec = mapped
    }

    /**
     * @param value The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
     */
    @JvmName("ohqounihyhrlbwan")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
     */
    @JvmName("cocpebdbrkndhcde")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
     */
    @JvmName("gljcusvbqpuetfei")
    public suspend fun paidType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paidType = mapped
    }

    /**
     * @param value The number of partitions.
     */
    @JvmName("ygisanyrrpoityjj")
    public suspend fun partitionNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionNum = mapped
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("micdiiwcexuayyyv")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The ID of security group for this instance. If the security group is empty, system will create a default one.
     */
    @JvmName("espbturvthhnhbwb")
    public suspend fun securityGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroup = mapped
    }

    /**
     * @param value The zones among which you want to deploy the instance.
     * > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
     * | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
     * |------|-------------|:----:|:-----:|
     * |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
     * |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
     * |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
     * |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
     * |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
     */
    @JvmName("vfyvyojukqlqegnh")
    public suspend fun selectedZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectedZones = mapped
    }

    /**
     * @param values The zones among which you want to deploy the instance.
     * > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
     * | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
     * |------|-------------|:----:|:-----:|
     * |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
     * |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
     * |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
     * |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
     * |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
     */
    @JvmName("hakkxmgdvtdcsqyx")
    public suspend fun selectedZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedZones = mapped
    }

    /**
     * @param value The version of the ApsaraMQ for Kafka instance. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
     */
    @JvmName("xiysilfiqutynykk")
    public suspend fun serviceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceVersion = mapped
    }

    /**
     * @param value The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
     */
    @JvmName("agkvxfjavowbejmg")
    public suspend fun specType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specType = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("slbncvdoqlkxrbtv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("qemctbcthnlqkhcv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The max num of topic can be creation of the instance.
     * It has been deprecated since version 1.194.0 and using `partition_num` instead.
     * Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
     * Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
     */
    @Deprecated(
        message = """
  Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next
      future. Using new attribute `partition_num` instead.
  """,
    )
    @JvmName("airnakpoxdpndpxx")
    public suspend fun topicQuota(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicQuota = mapped
    }

    /**
     * @param value The VPC ID of the instance.
     */
    @JvmName("jqujpkgavcxfhveq")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of attaching vswitch to instance.
     */
    @JvmName("fsdxisgfqlweawml")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
     */
    @JvmName("uyugisaspeonpdod")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        config = config,
        deployType = deployType,
        diskSize = diskSize,
        diskType = diskType,
        eipMax = eipMax,
        ioMax = ioMax,
        ioMaxSpec = ioMaxSpec,
        kmsKeyId = kmsKeyId,
        name = name,
        paidType = paidType,
        partitionNum = partitionNum,
        resourceGroupId = resourceGroupId,
        securityGroup = securityGroup,
        selectedZones = selectedZones,
        serviceVersion = serviceVersion,
        specType = specType,
        tags = tags,
        topicQuota = topicQuota,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
