@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alikafka.kotlin

import com.pulumi.alicloud.alikafka.SaslAclArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an ALIKAFKA sasl acl resource, see [What is alikafka sasl acl](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/api-alikafka-2019-09-16-createacl).
 * > **NOTE:** Available since v1.66.0.
 * > **NOTE:**  Only the following regions support create alikafka sasl user.
 * [`cn-hangzhou`,`cn-beijing`,`cn-shenzhen`,`cn-shanghai`,`cn-qingdao`,`cn-hongkong`,`cn-huhehaote`,`cn-zhangjiakou`,`cn-chengdu`,`cn-heyuan`,`ap-southeast-1`,`ap-southeast-3`,`ap-southeast-5`,`ap-northeast-1`,`eu-central-1`,`eu-west-1`,`us-west-1`,`us-east-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: defaultNetwork.id});
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.alikafka.Instance("default", {
 *     name: `${name}-${defaultInteger.result}`,
 *     partitionNum: 50,
 *     diskType: 1,
 *     diskSize: 500,
 *     deployType: 5,
 *     ioMax: 20,
 *     specType: "professional",
 *     serviceVersion: "2.2.0",
 *     config: "{\"enable.acl\":\"true\"}",
 *     vswitchId: defaultSwitch.id,
 *     securityGroup: defaultSecurityGroup.id,
 * });
 * const defaultTopic = new alicloud.alikafka.Topic("default", {
 *     instanceId: defaultInstance.id,
 *     topic: "example-topic",
 *     remark: "topic-remark",
 * });
 * const defaultSaslUser = new alicloud.alikafka.SaslUser("default", {
 *     instanceId: defaultInstance.id,
 *     username: name,
 *     password: "tf_example123",
 * });
 * const defaultSaslAcl = new alicloud.alikafka.SaslAcl("default", {
 *     instanceId: defaultInstance.id,
 *     username: defaultSaslUser.username,
 *     aclResourceType: "Topic",
 *     aclResourceName: defaultTopic.topic,
 *     aclResourcePatternType: "LITERAL",
 *     aclOperationType: "Write",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.alikafka.Instance("default",
 *     name=f"{name}-{default_integer['result']}",
 *     partition_num=50,
 *     disk_type=1,
 *     disk_size=500,
 *     deploy_type=5,
 *     io_max=20,
 *     spec_type="professional",
 *     service_version="2.2.0",
 *     config="{\"enable.acl\":\"true\"}",
 *     vswitch_id=default_switch.id,
 *     security_group=default_security_group.id)
 * default_topic = alicloud.alikafka.Topic("default",
 *     instance_id=default_instance.id,
 *     topic="example-topic",
 *     remark="topic-remark")
 * default_sasl_user = alicloud.alikafka.SaslUser("default",
 *     instance_id=default_instance.id,
 *     username=name,
 *     password="tf_example123")
 * default_sasl_acl = alicloud.alikafka.SaslAcl("default",
 *     instance_id=default_instance.id,
 *     username=default_sasl_user.username,
 *     acl_resource_type="Topic",
 *     acl_resource_name=default_topic.topic,
 *     acl_resource_pattern_type="LITERAL",
 *     acl_operation_type="Write")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.AliKafka.Instance("default", new()
 *     {
 *         Name = $"{name}-{defaultInteger.Result}",
 *         PartitionNum = 50,
 *         DiskType = 1,
 *         DiskSize = 500,
 *         DeployType = 5,
 *         IoMax = 20,
 *         SpecType = "professional",
 *         ServiceVersion = "2.2.0",
 *         Config = "{\"enable.acl\":\"true\"}",
 *         VswitchId = defaultSwitch.Id,
 *         SecurityGroup = defaultSecurityGroup.Id,
 *     });
 *     var defaultTopic = new AliCloud.AliKafka.Topic("default", new()
 *     {
 *         InstanceId = defaultInstance.Id,
 *         TopicName = "example-topic",
 *         Remark = "topic-remark",
 *     });
 *     var defaultSaslUser = new AliCloud.AliKafka.SaslUser("default", new()
 *     {
 *         InstanceId = defaultInstance.Id,
 *         Username = name,
 *         Password = "tf_example123",
 *     });
 *     var defaultSaslAcl = new AliCloud.AliKafka.SaslAcl("default", new()
 *     {
 *         InstanceId = defaultInstance.Id,
 *         Username = defaultSaslUser.Username,
 *         AclResourceType = "Topic",
 *         AclResourceName = defaultTopic.TopicName,
 *         AclResourcePatternType = "LITERAL",
 *         AclOperationType = "Write",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alikafka"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := alikafka.NewInstance(ctx, "default", &alikafka.InstanceArgs{
 * 			Name:           pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			PartitionNum:   pulumi.Int(50),
 * 			DiskType:       pulumi.Int(1),
 * 			DiskSize:       pulumi.Int(500),
 * 			DeployType:     pulumi.Int(5),
 * 			IoMax:          pulumi.Int(20),
 * 			SpecType:       pulumi.String("professional"),
 * 			ServiceVersion: pulumi.String("2.2.0"),
 * 			Config:         pulumi.String("{\"enable.acl\":\"true\"}"),
 * 			VswitchId:      defaultSwitch.ID(),
 * 			SecurityGroup:  defaultSecurityGroup.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTopic, err := alikafka.NewTopic(ctx, "default", &alikafka.TopicArgs{
 * 			InstanceId: defaultInstance.ID(),
 * 			Topic:      pulumi.String("example-topic"),
 * 			Remark:     pulumi.String("topic-remark"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSaslUser, err := alikafka.NewSaslUser(ctx, "default", &alikafka.SaslUserArgs{
 * 			InstanceId: defaultInstance.ID(),
 * 			Username:   pulumi.String(name),
 * 			Password:   pulumi.String("tf_example123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = alikafka.NewSaslAcl(ctx, "default", &alikafka.SaslAclArgs{
 * 			InstanceId:             defaultInstance.ID(),
 * 			Username:               defaultSaslUser.Username,
 * 			AclResourceType:        pulumi.String("Topic"),
 * 			AclResourceName:        defaultTopic.Topic,
 * 			AclResourcePatternType: pulumi.String("LITERAL"),
 * 			AclOperationType:       pulumi.String("Write"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.alikafka.Instance;
 * import com.pulumi.alicloud.alikafka.InstanceArgs;
 * import com.pulumi.alicloud.alikafka.Topic;
 * import com.pulumi.alicloud.alikafka.TopicArgs;
 * import com.pulumi.alicloud.alikafka.SaslUser;
 * import com.pulumi.alicloud.alikafka.SaslUserArgs;
 * import com.pulumi.alicloud.alikafka.SaslAcl;
 * import com.pulumi.alicloud.alikafka.SaslAclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .name(String.format("%s-%s", name,defaultInteger.result()))
 *             .partitionNum(50)
 *             .diskType("1")
 *             .diskSize("500")
 *             .deployType("5")
 *             .ioMax("20")
 *             .specType("professional")
 *             .serviceVersion("2.2.0")
 *             .config("{\"enable.acl\":\"true\"}")
 *             .vswitchId(defaultSwitch.id())
 *             .securityGroup(defaultSecurityGroup.id())
 *             .build());
 *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
 *             .instanceId(defaultInstance.id())
 *             .topic("example-topic")
 *             .remark("topic-remark")
 *             .build());
 *         var defaultSaslUser = new SaslUser("defaultSaslUser", SaslUserArgs.builder()
 *             .instanceId(defaultInstance.id())
 *             .username(name)
 *             .password("tf_example123")
 *             .build());
 *         var defaultSaslAcl = new SaslAcl("defaultSaslAcl", SaslAclArgs.builder()
 *             .instanceId(defaultInstance.id())
 *             .username(defaultSaslUser.username())
 *             .aclResourceType("Topic")
 *             .aclResourceName(defaultTopic.topic())
 *             .aclResourcePatternType("LITERAL")
 *             .aclOperationType("Write")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:alikafka:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${defaultInteger.result}
 *       partitionNum: 50
 *       diskType: '1'
 *       diskSize: '500'
 *       deployType: '5'
 *       ioMax: '20'
 *       specType: professional
 *       serviceVersion: 2.2.0
 *       config: '{"enable.acl":"true"}'
 *       vswitchId: ${defaultSwitch.id}
 *       securityGroup: ${defaultSecurityGroup.id}
 *   defaultTopic:
 *     type: alicloud:alikafka:Topic
 *     name: default
 *     properties:
 *       instanceId: ${defaultInstance.id}
 *       topic: example-topic
 *       remark: topic-remark
 *   defaultSaslUser:
 *     type: alicloud:alikafka:SaslUser
 *     name: default
 *     properties:
 *       instanceId: ${defaultInstance.id}
 *       username: ${name}
 *       password: tf_example123
 *   defaultSaslAcl:
 *     type: alicloud:alikafka:SaslAcl
 *     name: default
 *     properties:
 *       instanceId: ${defaultInstance.id}
 *       username: ${defaultSaslUser.username}
 *       aclResourceType: Topic
 *       aclResourceName: ${defaultTopic.topic}
 *       aclResourcePatternType: LITERAL
 *       aclOperationType: Write
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ALIKAFKA GROUP can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alikafka/saslAcl:SaslAcl acl alikafka_post-cn-123455abc:username:Topic:test-topic:LITERAL:Write
 * ```
 * @property aclOperationType Operation type for this acl. The operation type can only be "Write" and "Read".
 * @property aclResourceName Resource name for this acl. The resource name should be a topic or consumer group name.
 * @property aclResourcePatternType Resource pattern type for this acl. The resource pattern support two types "LITERAL" and "PREFIXED". "LITERAL": A literal name defines the full name of a resource. The special wildcard character "*" can be used to represent a resource with any name. "PREFIXED": A prefixed name defines a prefix for a resource.
 * @property aclResourceType Resource type for this acl. The resource type can only be "Topic" and "Group".
 * @property instanceId ID of the ALIKAFKA Instance that owns the groups.
 * @property username Username for the sasl user. The length should between 1 to 64 characters. The user should be an existed sasl user.
 */
public data class SaslAclArgs(
    public val aclOperationType: Output<String>? = null,
    public val aclResourceName: Output<String>? = null,
    public val aclResourcePatternType: Output<String>? = null,
    public val aclResourceType: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alikafka.SaslAclArgs> {
    override fun toJava(): com.pulumi.alicloud.alikafka.SaslAclArgs =
        com.pulumi.alicloud.alikafka.SaslAclArgs.builder()
            .aclOperationType(aclOperationType?.applyValue({ args0 -> args0 }))
            .aclResourceName(aclResourceName?.applyValue({ args0 -> args0 }))
            .aclResourcePatternType(aclResourcePatternType?.applyValue({ args0 -> args0 }))
            .aclResourceType(aclResourceType?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SaslAclArgs].
 */
@PulumiTagMarker
public class SaslAclArgsBuilder internal constructor() {
    private var aclOperationType: Output<String>? = null

    private var aclResourceName: Output<String>? = null

    private var aclResourcePatternType: Output<String>? = null

    private var aclResourceType: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Operation type for this acl. The operation type can only be "Write" and "Read".
     */
    @JvmName("jojlbihpssjdeobe")
    public suspend fun aclOperationType(`value`: Output<String>) {
        this.aclOperationType = value
    }

    /**
     * @param value Resource name for this acl. The resource name should be a topic or consumer group name.
     */
    @JvmName("sctuddqadavtoaml")
    public suspend fun aclResourceName(`value`: Output<String>) {
        this.aclResourceName = value
    }

    /**
     * @param value Resource pattern type for this acl. The resource pattern support two types "LITERAL" and "PREFIXED". "LITERAL": A literal name defines the full name of a resource. The special wildcard character "*" can be used to represent a resource with any name. "PREFIXED": A prefixed name defines a prefix for a resource.
     */
    @JvmName("yvqdaihienstrpka")
    public suspend fun aclResourcePatternType(`value`: Output<String>) {
        this.aclResourcePatternType = value
    }

    /**
     * @param value Resource type for this acl. The resource type can only be "Topic" and "Group".
     */
    @JvmName("phrvghncqfwhaxqt")
    public suspend fun aclResourceType(`value`: Output<String>) {
        this.aclResourceType = value
    }

    /**
     * @param value ID of the ALIKAFKA Instance that owns the groups.
     */
    @JvmName("ylgtfieeehdohabu")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Username for the sasl user. The length should between 1 to 64 characters. The user should be an existed sasl user.
     */
    @JvmName("hpwdaqwjmloafjvm")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Operation type for this acl. The operation type can only be "Write" and "Read".
     */
    @JvmName("kuitqxcfgvkcjoao")
    public suspend fun aclOperationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclOperationType = mapped
    }

    /**
     * @param value Resource name for this acl. The resource name should be a topic or consumer group name.
     */
    @JvmName("agaatcaeqgcaexsg")
    public suspend fun aclResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclResourceName = mapped
    }

    /**
     * @param value Resource pattern type for this acl. The resource pattern support two types "LITERAL" and "PREFIXED". "LITERAL": A literal name defines the full name of a resource. The special wildcard character "*" can be used to represent a resource with any name. "PREFIXED": A prefixed name defines a prefix for a resource.
     */
    @JvmName("jcewutsvxkboaqwr")
    public suspend fun aclResourcePatternType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclResourcePatternType = mapped
    }

    /**
     * @param value Resource type for this acl. The resource type can only be "Topic" and "Group".
     */
    @JvmName("hbiyaagmmtmxtvfg")
    public suspend fun aclResourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclResourceType = mapped
    }

    /**
     * @param value ID of the ALIKAFKA Instance that owns the groups.
     */
    @JvmName("osssrgsfmylsdvlt")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Username for the sasl user. The length should between 1 to 64 characters. The user should be an existed sasl user.
     */
    @JvmName("aciqqeybajsdwlgc")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): SaslAclArgs = SaslAclArgs(
        aclOperationType = aclOperationType,
        aclResourceName = aclResourceName,
        aclResourcePatternType = aclResourcePatternType,
        aclResourceType = aclResourceType,
        instanceId = instanceId,
        username = username,
    )
}
