@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alikafka.kotlin

import com.pulumi.alicloud.alikafka.TopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ALIKAFKA topic resource, see [What is Alikafka topic ](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/api-alikafka-2019-09-16-createtopic).
 * > **NOTE:** Available since v1.56.0.
 * > **NOTE:**  Only the following regions support create alikafka topic.
 * [`cn-hangzhou`,`cn-beijing`,`cn-shenzhen`,`cn-shanghai`,`cn-qingdao`,`cn-hongkong`,`cn-huhehaote`,`cn-zhangjiakou`,`cn-chengdu`,`cn-heyuan`,`ap-southeast-1`,`ap-southeast-3`,`ap-southeast-5`,`ap-northeast-1`,`eu-central-1`,`eu-west-1`,`us-west-1`,`us-east-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const instanceName = config.get("instanceName") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {cidrBlock: "172.16.0.0/12"});
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: defaultNetwork.id});
 * const defaultInstance = new alicloud.alikafka.Instance("default", {
 *     name: `${instanceName}-${defaultInteger.result}`,
 *     partitionNum: 50,
 *     diskType: 1,
 *     diskSize: 500,
 *     deployType: 5,
 *     ioMax: 20,
 *     vswitchId: defaultSwitch.id,
 *     securityGroup: defaultSecurityGroup.id,
 * });
 * const defaultTopic = new alicloud.alikafka.Topic("default", {
 *     instanceId: defaultInstance.id,
 *     topic: "example-topic",
 *     localTopic: false,
 *     compactTopic: false,
 *     partitionNum: 12,
 *     remark: "dafault_kafka_topic_remark",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * instance_name = config.get("instanceName")
 * if instance_name is None:
 *     instance_name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_network = alicloud.vpc.Network("default", cidr_block="172.16.0.0/12")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
 * default_instance = alicloud.alikafka.Instance("default",
 *     name=f"{instance_name}-{default_integer['result']}",
 *     partition_num=50,
 *     disk_type=1,
 *     disk_size=500,
 *     deploy_type=5,
 *     io_max=20,
 *     vswitch_id=default_switch.id,
 *     security_group=default_security_group.id)
 * default_topic = alicloud.alikafka.Topic("default",
 *     instance_id=default_instance.id,
 *     topic="example-topic",
 *     local_topic=False,
 *     compact_topic=False,
 *     partition_num=12,
 *     remark="dafault_kafka_topic_remark")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var instanceName = config.Get("instanceName") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstance = new AliCloud.AliKafka.Instance("default", new()
 *     {
 *         Name = $"{instanceName}-{defaultInteger.Result}",
 *         PartitionNum = 50,
 *         DiskType = 1,
 *         DiskSize = 500,
 *         DeployType = 5,
 *         IoMax = 20,
 *         VswitchId = defaultSwitch.Id,
 *         SecurityGroup = defaultSecurityGroup.Id,
 *     });
 *     var defaultTopic = new AliCloud.AliKafka.Topic("default", new()
 *     {
 *         InstanceId = defaultInstance.Id,
 *         TopicName = "example-topic",
 *         LocalTopic = false,
 *         CompactTopic = false,
 *         PartitionNum = 12,
 *         Remark = "dafault_kafka_topic_remark",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alikafka"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		instanceName := "tf-example"
 * 		if param := cfg.Get("instanceName"); param != "" {
 * 			instanceName = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:     defaultNetwork.ID(),
 * 			CidrBlock: pulumi.String("172.16.0.0/24"),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := alikafka.NewInstance(ctx, "default", &alikafka.InstanceArgs{
 * 			Name:          pulumi.Sprintf("%v-%v", instanceName, defaultInteger.Result),
 * 			PartitionNum:  pulumi.Int(50),
 * 			DiskType:      pulumi.Int(1),
 * 			DiskSize:      pulumi.Int(500),
 * 			DeployType:    pulumi.Int(5),
 * 			IoMax:         pulumi.Int(20),
 * 			VswitchId:     defaultSwitch.ID(),
 * 			SecurityGroup: defaultSecurityGroup.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = alikafka.NewTopic(ctx, "default", &alikafka.TopicArgs{
 * 			InstanceId:   defaultInstance.ID(),
 * 			Topic:        pulumi.String("example-topic"),
 * 			LocalTopic:   pulumi.Bool(false),
 * 			CompactTopic: pulumi.Bool(false),
 * 			PartitionNum: pulumi.Int(12),
 * 			Remark:       pulumi.String("dafault_kafka_topic_remark"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.alikafka.Instance;
 * import com.pulumi.alicloud.alikafka.InstanceArgs;
 * import com.pulumi.alicloud.alikafka.Topic;
 * import com.pulumi.alicloud.alikafka.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var instanceName = config.get("instanceName").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .name(String.format("%s-%s", instanceName,defaultInteger.result()))
 *             .partitionNum("50")
 *             .diskType("1")
 *             .diskSize("500")
 *             .deployType("5")
 *             .ioMax("20")
 *             .vswitchId(defaultSwitch.id())
 *             .securityGroup(defaultSecurityGroup.id())
 *             .build());
 *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
 *             .instanceId(defaultInstance.id())
 *             .topic("example-topic")
 *             .localTopic("false")
 *             .compactTopic("false")
 *             .partitionNum("12")
 *             .remark("dafault_kafka_topic_remark")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   instanceName:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *   defaultInstance:
 *     type: alicloud:alikafka:Instance
 *     name: default
 *     properties:
 *       name: ${instanceName}-${defaultInteger.result}
 *       partitionNum: '50'
 *       diskType: '1'
 *       diskSize: '500'
 *       deployType: '5'
 *       ioMax: '20'
 *       vswitchId: ${defaultSwitch.id}
 *       securityGroup: ${defaultSecurityGroup.id}
 *   defaultTopic:
 *     type: alicloud:alikafka:Topic
 *     name: default
 *     properties:
 *       instanceId: ${defaultInstance.id}
 *       topic: example-topic
 *       localTopic: 'false'
 *       compactTopic: 'false'
 *       partitionNum: '12'
 *       remark: dafault_kafka_topic_remark
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ALIKAFKA TOPIC can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alikafka/topic:Topic topic alikafka_post-cn-123455abc:topicName
 * ```
 * @property compactTopic Whether the topic is compactTopic or not. Compact topic must be a localTopic.
 * @property instanceId InstanceId of your Kafka resource, the topic will create in this instance.
 * @property localTopic Whether the topic is localTopic or not.
 * @property partitionNum The number of partitions of the topic. The number should between 1 and 48.
 * @property remark This attribute is a concise description of topic. The length cannot exceed 64.
 * @property tags A mapping of tags to assign to the resource.
 * @property topic Name of the topic. Two topics on a single instance cannot have the same name. The length cannot exceed 249 characters.
 */
public data class TopicArgs(
    public val compactTopic: Output<Boolean>? = null,
    public val instanceId: Output<String>? = null,
    public val localTopic: Output<Boolean>? = null,
    public val partitionNum: Output<Int>? = null,
    public val remark: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alikafka.TopicArgs> {
    override fun toJava(): com.pulumi.alicloud.alikafka.TopicArgs =
        com.pulumi.alicloud.alikafka.TopicArgs.builder()
            .compactTopic(compactTopic?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .localTopic(localTopic?.applyValue({ args0 -> args0 }))
            .partitionNum(partitionNum?.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topic(topic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicArgs].
 */
@PulumiTagMarker
public class TopicArgsBuilder internal constructor() {
    private var compactTopic: Output<Boolean>? = null

    private var instanceId: Output<String>? = null

    private var localTopic: Output<Boolean>? = null

    private var partitionNum: Output<Int>? = null

    private var remark: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topic: Output<String>? = null

    /**
     * @param value Whether the topic is compactTopic or not. Compact topic must be a localTopic.
     */
    @JvmName("xfhvwhbqiscjxeoy")
    public suspend fun compactTopic(`value`: Output<Boolean>) {
        this.compactTopic = value
    }

    /**
     * @param value InstanceId of your Kafka resource, the topic will create in this instance.
     */
    @JvmName("fpadusjddqugxitq")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Whether the topic is localTopic or not.
     */
    @JvmName("obbsrnoefpekogve")
    public suspend fun localTopic(`value`: Output<Boolean>) {
        this.localTopic = value
    }

    /**
     * @param value The number of partitions of the topic. The number should between 1 and 48.
     */
    @JvmName("jucnlxtwbkoqhcpp")
    public suspend fun partitionNum(`value`: Output<Int>) {
        this.partitionNum = value
    }

    /**
     * @param value This attribute is a concise description of topic. The length cannot exceed 64.
     */
    @JvmName("pwvidpwahvkomhxu")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("llfopwvvghnbjjpw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the topic. Two topics on a single instance cannot have the same name. The length cannot exceed 249 characters.
     */
    @JvmName("mfdmoapnjefaehrs")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Whether the topic is compactTopic or not. Compact topic must be a localTopic.
     */
    @JvmName("yvrshvgypygtnmes")
    public suspend fun compactTopic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compactTopic = mapped
    }

    /**
     * @param value InstanceId of your Kafka resource, the topic will create in this instance.
     */
    @JvmName("resqghoykobxscjl")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Whether the topic is localTopic or not.
     */
    @JvmName("xedlpchbprggmrcy")
    public suspend fun localTopic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localTopic = mapped
    }

    /**
     * @param value The number of partitions of the topic. The number should between 1 and 48.
     */
    @JvmName("euawcpcbbkfjskxk")
    public suspend fun partitionNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionNum = mapped
    }

    /**
     * @param value This attribute is a concise description of topic. The length cannot exceed 64.
     */
    @JvmName("iprvsocflctjvsta")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("jpibqpvqywqtitse")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("pmyrycaeexmheddv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the topic. Two topics on a single instance cannot have the same name. The length cannot exceed 249 characters.
     */
    @JvmName("wtxyfuosggwkaluf")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): TopicArgs = TopicArgs(
        compactTopic = compactTopic,
        instanceId = instanceId,
        localTopic = localTopic,
        partitionNum = partitionNum,
        remark = remark,
        tags = tags,
        topic = topic,
    )
}
