@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin

import com.pulumi.alicloud.amqp.AmqpFunctions.getBindingsPlain
import com.pulumi.alicloud.amqp.AmqpFunctions.getExchangesPlain
import com.pulumi.alicloud.amqp.AmqpFunctions.getInstancesPlain
import com.pulumi.alicloud.amqp.AmqpFunctions.getQueuesPlain
import com.pulumi.alicloud.amqp.AmqpFunctions.getStaticAccountsPlain
import com.pulumi.alicloud.amqp.AmqpFunctions.getVirtualHostsPlain
import com.pulumi.alicloud.amqp.kotlin.inputs.GetBindingsPlainArgs
import com.pulumi.alicloud.amqp.kotlin.inputs.GetBindingsPlainArgsBuilder
import com.pulumi.alicloud.amqp.kotlin.inputs.GetExchangesPlainArgs
import com.pulumi.alicloud.amqp.kotlin.inputs.GetExchangesPlainArgsBuilder
import com.pulumi.alicloud.amqp.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.amqp.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.amqp.kotlin.inputs.GetQueuesPlainArgs
import com.pulumi.alicloud.amqp.kotlin.inputs.GetQueuesPlainArgsBuilder
import com.pulumi.alicloud.amqp.kotlin.inputs.GetStaticAccountsPlainArgs
import com.pulumi.alicloud.amqp.kotlin.inputs.GetStaticAccountsPlainArgsBuilder
import com.pulumi.alicloud.amqp.kotlin.inputs.GetVirtualHostsPlainArgs
import com.pulumi.alicloud.amqp.kotlin.inputs.GetVirtualHostsPlainArgsBuilder
import com.pulumi.alicloud.amqp.kotlin.outputs.GetBindingsResult
import com.pulumi.alicloud.amqp.kotlin.outputs.GetExchangesResult
import com.pulumi.alicloud.amqp.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.amqp.kotlin.outputs.GetQueuesResult
import com.pulumi.alicloud.amqp.kotlin.outputs.GetStaticAccountsResult
import com.pulumi.alicloud.amqp.kotlin.outputs.GetVirtualHostsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.amqp.kotlin.outputs.GetBindingsResult.Companion.toKotlin as getBindingsResultToKotlin
import com.pulumi.alicloud.amqp.kotlin.outputs.GetExchangesResult.Companion.toKotlin as getExchangesResultToKotlin
import com.pulumi.alicloud.amqp.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.amqp.kotlin.outputs.GetQueuesResult.Companion.toKotlin as getQueuesResultToKotlin
import com.pulumi.alicloud.amqp.kotlin.outputs.GetStaticAccountsResult.Companion.toKotlin as getStaticAccountsResultToKotlin
import com.pulumi.alicloud.amqp.kotlin.outputs.GetVirtualHostsResult.Companion.toKotlin as getVirtualHostsResultToKotlin

public object AmqpFunctions {
    /**
     * This data source provides the Amqp Bindings of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const examples = alicloud.amqp.getBindings({
     *     instanceId: "amqp-cn-xxxxx",
     *     virtualHostName: "my-vh",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * examples = alicloud.amqp.get_bindings(instance_id="amqp-cn-xxxxx",
     *     virtual_host_name="my-vh")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var examples = AliCloud.Amqp.GetBindings.Invoke(new()
     *     {
     *         InstanceId = "amqp-cn-xxxxx",
     *         VirtualHostName = "my-vh",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := amqp.GetBindings(ctx, &amqp.GetBindingsArgs{
     * 			InstanceId:      "amqp-cn-xxxxx",
     * 			VirtualHostName: "my-vh",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.amqp.AmqpFunctions;
     * import com.pulumi.alicloud.amqp.inputs.GetBindingsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var examples = AmqpFunctions.getBindings(GetBindingsArgs.builder()
     *             .instanceId("amqp-cn-xxxxx")
     *             .virtualHostName("my-vh")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   examples:
     *     fn::invoke:
     *       Function: alicloud:amqp:getBindings
     *       Arguments:
     *         instanceId: amqp-cn-xxxxx
     *         virtualHostName: my-vh
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBindings.
     * @return A collection of values returned by getBindings.
     */
    public suspend fun getBindings(argument: GetBindingsPlainArgs): GetBindingsResult =
        getBindingsResultToKotlin(getBindingsPlain(argument.toJava()).await())

    /**
     * @see [getBindings].
     * @param instanceId Instance Id.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param virtualHostName Virtualhost Name.
     * @return A collection of values returned by getBindings.
     */
    public suspend fun getBindings(
        instanceId: String,
        outputFile: String? = null,
        virtualHostName: String,
    ): GetBindingsResult {
        val argument = GetBindingsPlainArgs(
            instanceId = instanceId,
            outputFile = outputFile,
            virtualHostName = virtualHostName,
        )
        return getBindingsResultToKotlin(getBindingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBindings].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;amqp&#46;kotlin&#46;inputs&#46;GetBindingsPlainArgs].
     * @return A collection of values returned by getBindings.
     */
    public suspend fun getBindings(argument: suspend GetBindingsPlainArgsBuilder.() -> Unit): GetBindingsResult {
        val builder = GetBindingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBindingsResultToKotlin(getBindingsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Amqp Exchanges of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.128.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.amqp.getExchanges({
     *     instanceId: "amqp-abc12345",
     *     virtualHostName: "my-VirtualHost",
     *     ids: [
     *         "my-Exchange-1",
     *         "my-Exchange-2",
     *     ],
     * });
     * export const amqpExchangeId1 = ids.then(ids => ids.exchanges?.[0]?.id);
     * const nameRegex = alicloud.amqp.getExchanges({
     *     instanceId: "amqp-abc12345",
     *     virtualHostName: "my-VirtualHost",
     *     nameRegex: "^my-Exchange",
     * });
     * export const amqpExchangeId2 = nameRegex.then(nameRegex => nameRegex.exchanges?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.amqp.get_exchanges(instance_id="amqp-abc12345",
     *     virtual_host_name="my-VirtualHost",
     *     ids=[
     *         "my-Exchange-1",
     *         "my-Exchange-2",
     *     ])
     * pulumi.export("amqpExchangeId1", ids.exchanges[0].id)
     * name_regex = alicloud.amqp.get_exchanges(instance_id="amqp-abc12345",
     *     virtual_host_name="my-VirtualHost",
     *     name_regex="^my-Exchange")
     * pulumi.export("amqpExchangeId2", name_regex.exchanges[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Amqp.GetExchanges.Invoke(new()
     *     {
     *         InstanceId = "amqp-abc12345",
     *         VirtualHostName = "my-VirtualHost",
     *         Ids = new[]
     *         {
     *             "my-Exchange-1",
     *             "my-Exchange-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Amqp.GetExchanges.Invoke(new()
     *     {
     *         InstanceId = "amqp-abc12345",
     *         VirtualHostName = "my-VirtualHost",
     *         NameRegex = "^my-Exchange",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["amqpExchangeId1"] = ids&#46;Apply(getExchangesResult => getExchangesResult&#46;Exchanges[0]?.Id),
     *         ["amqpExchangeId2"] = nameRegex&#46;Apply(getExchangesResult => getExchangesResult&#46;Exchanges[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := amqp.GetExchanges(ctx, &amqp.GetExchangesArgs{
     * 			InstanceId:      "amqp-abc12345",
     * 			VirtualHostName: "my-VirtualHost",
     * 			Ids: []string{
     * 				"my-Exchange-1",
     * 				"my-Exchange-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("amqpExchangeId1", ids.Exchanges[0].Id)
     * 		nameRegex, err := amqp.GetExchanges(ctx, &amqp.GetExchangesArgs{
     * 			InstanceId:      "amqp-abc12345",
     * 			VirtualHostName: "my-VirtualHost",
     * 			NameRegex:       pulumi.StringRef("^my-Exchange"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("amqpExchangeId2", nameRegex.Exchanges[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.amqp.AmqpFunctions;
     * import com.pulumi.alicloud.amqp.inputs.GetExchangesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AmqpFunctions.getExchanges(GetExchangesArgs.builder()
     *             .instanceId("amqp-abc12345")
     *             .virtualHostName("my-VirtualHost")
     *             .ids(
     *                 "my-Exchange-1",
     *                 "my-Exchange-2")
     *             .build());
     *         ctx.export("amqpExchangeId1", ids.applyValue(getExchangesResult -> getExchangesResult.exchanges()[0].id()));
     *         final var nameRegex = AmqpFunctions.getExchanges(GetExchangesArgs.builder()
     *             .instanceId("amqp-abc12345")
     *             .virtualHostName("my-VirtualHost")
     *             .nameRegex("^my-Exchange")
     *             .build());
     *         ctx.export("amqpExchangeId2", nameRegex.applyValue(getExchangesResult -> getExchangesResult.exchanges()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:amqp:getExchanges
     *       Arguments:
     *         instanceId: amqp-abc12345
     *         virtualHostName: my-VirtualHost
     *         ids:
     *           - my-Exchange-1
     *           - my-Exchange-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:amqp:getExchanges
     *       Arguments:
     *         instanceId: amqp-abc12345
     *         virtualHostName: my-VirtualHost
     *         nameRegex: ^my-Exchange
     * outputs:
     *   amqpExchangeId1: ${ids.exchanges[0].id}
     *   amqpExchangeId2: ${nameRegex.exchanges[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getExchanges.
     * @return A collection of values returned by getExchanges.
     */
    public suspend fun getExchanges(argument: GetExchangesPlainArgs): GetExchangesResult =
        getExchangesResultToKotlin(getExchangesPlain(argument.toJava()).await())

    /**
     * @see [getExchanges].
     * @param ids A list of Exchange IDs. Its element value is same as Exchange Name.
     * @param instanceId The ID of the instance.
     * @param nameRegex A regex string to filter results by Exchange name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param virtualHostName The name of virtual host where an exchange resides.
     * @return A collection of values returned by getExchanges.
     */
    public suspend fun getExchanges(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        virtualHostName: String,
    ): GetExchangesResult {
        val argument = GetExchangesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            virtualHostName = virtualHostName,
        )
        return getExchangesResultToKotlin(getExchangesPlain(argument.toJava()).await())
    }

    /**
     * @see [getExchanges].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;amqp&#46;kotlin&#46;inputs&#46;GetExchangesPlainArgs].
     * @return A collection of values returned by getExchanges.
     */
    public suspend fun getExchanges(argument: suspend GetExchangesPlainArgsBuilder.() -> Unit): GetExchangesResult {
        val builder = GetExchangesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExchangesResultToKotlin(getExchangesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Amqp Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.128.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.amqp.getInstances({
     *     ids: [
     *         "amqp-abc12345",
     *         "amqp-abc34567",
     *     ],
     * });
     * export const amqpInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * const nameRegex = alicloud.amqp.getInstances({
     *     nameRegex: "^my-Instance",
     * });
     * export const amqpInstanceId2 = nameRegex.then(nameRegex => nameRegex.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.amqp.get_instances(ids=[
     *     "amqp-abc12345",
     *     "amqp-abc34567",
     * ])
     * pulumi.export("amqpInstanceId1", ids.instances[0].id)
     * name_regex = alicloud.amqp.get_instances(name_regex="^my-Instance")
     * pulumi.export("amqpInstanceId2", name_regex.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Amqp.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "amqp-abc12345",
     *             "amqp-abc34567",
     *         },
     *     });
     *     var nameRegex = AliCloud.Amqp.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "^my-Instance",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["amqpInstanceId1"] = ids&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *         ["amqpInstanceId2"] = nameRegex&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := amqp.GetInstances(ctx, &amqp.GetInstancesArgs{
     * 			Ids: []string{
     * 				"amqp-abc12345",
     * 				"amqp-abc34567",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("amqpInstanceId1", ids.Instances[0].Id)
     * 		nameRegex, err := amqp.GetInstances(ctx, &amqp.GetInstancesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Instance"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("amqpInstanceId2", nameRegex.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.amqp.AmqpFunctions;
     * import com.pulumi.alicloud.amqp.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AmqpFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids(
     *                 "amqp-abc12345",
     *                 "amqp-abc34567")
     *             .build());
     *         ctx.export("amqpInstanceId1", ids.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *         final var nameRegex = AmqpFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("^my-Instance")
     *             .build());
     *         ctx.export("amqpInstanceId2", nameRegex.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:amqp:getInstances
     *       Arguments:
     *         ids:
     *           - amqp-abc12345
     *           - amqp-abc34567
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:amqp:getInstances
     *       Arguments:
     *         nameRegex: ^my-Instance
     * outputs:
     *   amqpInstanceId1: ${ids.instances[0].id}
     *   amqpInstanceId2: ${nameRegex.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Instance IDs.
     * @param nameRegex A regex string to filter results by Instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: "DEPLOYING", "EXPIRED", "RELEASED", "SERVING".
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;amqp&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Amqp Queues of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.127.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.amqp.getQueues({
     *     instanceId: "amqp-abc12345",
     *     virtualHostName: "my-VirtualHost",
     *     ids: [
     *         "my-Queue-1",
     *         "my-Queue-2",
     *     ],
     * });
     * export const amqpQueueId1 = ids.then(ids => ids.queues?.[0]?.id);
     * const nameRegex = alicloud.amqp.getQueues({
     *     instanceId: "amqp-abc12345",
     *     virtualHostName: "my-VirtualHost",
     *     nameRegex: "^my-Queue",
     * });
     * export const amqpQueueId2 = nameRegex.then(nameRegex => nameRegex.queues?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.amqp.get_queues(instance_id="amqp-abc12345",
     *     virtual_host_name="my-VirtualHost",
     *     ids=[
     *         "my-Queue-1",
     *         "my-Queue-2",
     *     ])
     * pulumi.export("amqpQueueId1", ids.queues[0].id)
     * name_regex = alicloud.amqp.get_queues(instance_id="amqp-abc12345",
     *     virtual_host_name="my-VirtualHost",
     *     name_regex="^my-Queue")
     * pulumi.export("amqpQueueId2", name_regex.queues[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Amqp.GetQueues.Invoke(new()
     *     {
     *         InstanceId = "amqp-abc12345",
     *         VirtualHostName = "my-VirtualHost",
     *         Ids = new[]
     *         {
     *             "my-Queue-1",
     *             "my-Queue-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Amqp.GetQueues.Invoke(new()
     *     {
     *         InstanceId = "amqp-abc12345",
     *         VirtualHostName = "my-VirtualHost",
     *         NameRegex = "^my-Queue",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["amqpQueueId1"] = ids&#46;Apply(getQueuesResult => getQueuesResult&#46;Queues[0]?.Id),
     *         ["amqpQueueId2"] = nameRegex&#46;Apply(getQueuesResult => getQueuesResult&#46;Queues[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := amqp.GetQueues(ctx, &amqp.GetQueuesArgs{
     * 			InstanceId:      "amqp-abc12345",
     * 			VirtualHostName: "my-VirtualHost",
     * 			Ids: []string{
     * 				"my-Queue-1",
     * 				"my-Queue-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("amqpQueueId1", ids.Queues[0].Id)
     * 		nameRegex, err := amqp.GetQueues(ctx, &amqp.GetQueuesArgs{
     * 			InstanceId:      "amqp-abc12345",
     * 			VirtualHostName: "my-VirtualHost",
     * 			NameRegex:       pulumi.StringRef("^my-Queue"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("amqpQueueId2", nameRegex.Queues[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.amqp.AmqpFunctions;
     * import com.pulumi.alicloud.amqp.inputs.GetQueuesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AmqpFunctions.getQueues(GetQueuesArgs.builder()
     *             .instanceId("amqp-abc12345")
     *             .virtualHostName("my-VirtualHost")
     *             .ids(
     *                 "my-Queue-1",
     *                 "my-Queue-2")
     *             .build());
     *         ctx.export("amqpQueueId1", ids.applyValue(getQueuesResult -> getQueuesResult.queues()[0].id()));
     *         final var nameRegex = AmqpFunctions.getQueues(GetQueuesArgs.builder()
     *             .instanceId("amqp-abc12345")
     *             .virtualHostName("my-VirtualHost")
     *             .nameRegex("^my-Queue")
     *             .build());
     *         ctx.export("amqpQueueId2", nameRegex.applyValue(getQueuesResult -> getQueuesResult.queues()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:amqp:getQueues
     *       Arguments:
     *         instanceId: amqp-abc12345
     *         virtualHostName: my-VirtualHost
     *         ids:
     *           - my-Queue-1
     *           - my-Queue-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:amqp:getQueues
     *       Arguments:
     *         instanceId: amqp-abc12345
     *         virtualHostName: my-VirtualHost
     *         nameRegex: ^my-Queue
     * outputs:
     *   amqpQueueId1: ${ids.queues[0].id}
     *   amqpQueueId2: ${nameRegex.queues[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getQueues.
     * @return A collection of values returned by getQueues.
     */
    public suspend fun getQueues(argument: GetQueuesPlainArgs): GetQueuesResult =
        getQueuesResultToKotlin(getQueuesPlain(argument.toJava()).await())

    /**
     * @see [getQueues].
     * @param ids A list of Queue IDs. Its element value is same as Queue Name.
     * @param instanceId The ID of the instance.
     * @param nameRegex A regex string to filter results by Queue name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param virtualHostName The name of the virtual host.
     * @return A collection of values returned by getQueues.
     */
    public suspend fun getQueues(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        virtualHostName: String,
    ): GetQueuesResult {
        val argument = GetQueuesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            virtualHostName = virtualHostName,
        )
        return getQueuesResultToKotlin(getQueuesPlain(argument.toJava()).await())
    }

    /**
     * @see [getQueues].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;amqp&#46;kotlin&#46;inputs&#46;GetQueuesPlainArgs].
     * @return A collection of values returned by getQueues.
     */
    public suspend fun getQueues(argument: suspend GetQueuesPlainArgsBuilder.() -> Unit): GetQueuesResult {
        val builder = GetQueuesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueuesResultToKotlin(getQueuesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Amqp Static Account available to the user.[What is Static Account](https://help.aliyun.com/document_detail/184399.html)
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.amqp.getStaticAccounts({
     *     instanceId: "amqp-cn-0ju2y01zs001",
     * });
     * export const alicloudAmqpStaticAccountExampleId = _default.then(_default => _default.accounts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.amqp.get_static_accounts(instance_id="amqp-cn-0ju2y01zs001")
     * pulumi.export("alicloudAmqpStaticAccountExampleId", default.accounts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Amqp.GetStaticAccounts.Invoke(new()
     *     {
     *         InstanceId = "amqp-cn-0ju2y01zs001",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudAmqpStaticAccountExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getStaticAccountsResult => getStaticAccountsResult&#46;Accounts[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := amqp.GetStaticAccounts(ctx, &amqp.GetStaticAccountsArgs{
     * 			InstanceId: pulumi.StringRef("amqp-cn-0ju2y01zs001"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudAmqpStaticAccountExampleId", _default.Accounts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.amqp.AmqpFunctions;
     * import com.pulumi.alicloud.amqp.inputs.GetStaticAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = AmqpFunctions.getStaticAccounts(GetStaticAccountsArgs.builder()
     *             .instanceId("amqp-cn-0ju2y01zs001")
     *             .build());
     *         ctx.export("alicloudAmqpStaticAccountExampleId", default_.accounts()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:amqp:getStaticAccounts
     *       Arguments:
     *         instanceId: amqp-cn-0ju2y01zs001
     * outputs:
     *   alicloudAmqpStaticAccountExampleId: ${default.accounts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getStaticAccounts.
     * @return A collection of values returned by getStaticAccounts.
     */
    public suspend fun getStaticAccounts(argument: GetStaticAccountsPlainArgs): GetStaticAccountsResult =
        getStaticAccountsResultToKotlin(getStaticAccountsPlain(argument.toJava()).await())

    /**
     * @see [getStaticAccounts].
     * @param ids The `key` of the resource supplied above.The value is formulated as `<instance_id>:<access_key>`.
     * @param instanceId InstanceId
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getStaticAccounts.
     */
    public suspend fun getStaticAccounts(
        ids: List<String>? = null,
        instanceId: String? = null,
        outputFile: String? = null,
    ): GetStaticAccountsResult {
        val argument = GetStaticAccountsPlainArgs(
            ids = ids,
            instanceId = instanceId,
            outputFile = outputFile,
        )
        return getStaticAccountsResultToKotlin(getStaticAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getStaticAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;amqp&#46;kotlin&#46;inputs&#46;GetStaticAccountsPlainArgs].
     * @return A collection of values returned by getStaticAccounts.
     */
    public suspend fun getStaticAccounts(argument: suspend GetStaticAccountsPlainArgsBuilder.() -> Unit): GetStaticAccountsResult {
        val builder = GetStaticAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStaticAccountsResultToKotlin(getStaticAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Amqp Virtual Hosts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.126.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.amqp.getVirtualHosts({
     *     instanceId: "amqp-abc12345",
     *     ids: [
     *         "my-VirtualHost-1",
     *         "my-VirtualHost-2",
     *     ],
     * });
     * export const amqpVirtualHostId1 = ids.then(ids => ids.hosts?.[0]?.id);
     * const nameRegex = alicloud.amqp.getVirtualHosts({
     *     instanceId: "amqp-abc12345",
     *     nameRegex: "^my-VirtualHost",
     * });
     * export const amqpVirtualHostId2 = nameRegex.then(nameRegex => nameRegex.hosts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.amqp.get_virtual_hosts(instance_id="amqp-abc12345",
     *     ids=[
     *         "my-VirtualHost-1",
     *         "my-VirtualHost-2",
     *     ])
     * pulumi.export("amqpVirtualHostId1", ids.hosts[0].id)
     * name_regex = alicloud.amqp.get_virtual_hosts(instance_id="amqp-abc12345",
     *     name_regex="^my-VirtualHost")
     * pulumi.export("amqpVirtualHostId2", name_regex.hosts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Amqp.GetVirtualHosts.Invoke(new()
     *     {
     *         InstanceId = "amqp-abc12345",
     *         Ids = new[]
     *         {
     *             "my-VirtualHost-1",
     *             "my-VirtualHost-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Amqp.GetVirtualHosts.Invoke(new()
     *     {
     *         InstanceId = "amqp-abc12345",
     *         NameRegex = "^my-VirtualHost",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["amqpVirtualHostId1"] = ids&#46;Apply(getVirtualHostsResult => getVirtualHostsResult&#46;Hosts[0]?.Id),
     *         ["amqpVirtualHostId2"] = nameRegex&#46;Apply(getVirtualHostsResult => getVirtualHostsResult&#46;Hosts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := amqp.GetVirtualHosts(ctx, &amqp.GetVirtualHostsArgs{
     * 			InstanceId: "amqp-abc12345",
     * 			Ids: []string{
     * 				"my-VirtualHost-1",
     * 				"my-VirtualHost-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("amqpVirtualHostId1", ids.Hosts[0].Id)
     * 		nameRegex, err := amqp.GetVirtualHosts(ctx, &amqp.GetVirtualHostsArgs{
     * 			InstanceId: "amqp-abc12345",
     * 			NameRegex:  pulumi.StringRef("^my-VirtualHost"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("amqpVirtualHostId2", nameRegex.Hosts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.amqp.AmqpFunctions;
     * import com.pulumi.alicloud.amqp.inputs.GetVirtualHostsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AmqpFunctions.getVirtualHosts(GetVirtualHostsArgs.builder()
     *             .instanceId("amqp-abc12345")
     *             .ids(
     *                 "my-VirtualHost-1",
     *                 "my-VirtualHost-2")
     *             .build());
     *         ctx.export("amqpVirtualHostId1", ids.applyValue(getVirtualHostsResult -> getVirtualHostsResult.hosts()[0].id()));
     *         final var nameRegex = AmqpFunctions.getVirtualHosts(GetVirtualHostsArgs.builder()
     *             .instanceId("amqp-abc12345")
     *             .nameRegex("^my-VirtualHost")
     *             .build());
     *         ctx.export("amqpVirtualHostId2", nameRegex.applyValue(getVirtualHostsResult -> getVirtualHostsResult.hosts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:amqp:getVirtualHosts
     *       Arguments:
     *         instanceId: amqp-abc12345
     *         ids:
     *           - my-VirtualHost-1
     *           - my-VirtualHost-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:amqp:getVirtualHosts
     *       Arguments:
     *         instanceId: amqp-abc12345
     *         nameRegex: ^my-VirtualHost
     * outputs:
     *   amqpVirtualHostId1: ${ids.hosts[0].id}
     *   amqpVirtualHostId2: ${nameRegex.hosts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVirtualHosts.
     * @return A collection of values returned by getVirtualHosts.
     */
    public suspend fun getVirtualHosts(argument: GetVirtualHostsPlainArgs): GetVirtualHostsResult =
        getVirtualHostsResultToKotlin(getVirtualHostsPlain(argument.toJava()).await())

    /**
     * @see [getVirtualHosts].
     * @param ids A list of Virtual Host IDs. Its element value is same as Virtual Host Name.
     * @param instanceId InstanceId.
     * @param nameRegex A regex string to filter results by Virtual Host name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getVirtualHosts.
     */
    public suspend fun getVirtualHosts(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetVirtualHostsResult {
        val argument = GetVirtualHostsPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getVirtualHostsResultToKotlin(getVirtualHostsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualHosts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;amqp&#46;kotlin&#46;inputs&#46;GetVirtualHostsPlainArgs].
     * @return A collection of values returned by getVirtualHosts.
     */
    public suspend fun getVirtualHosts(argument: suspend GetVirtualHostsPlainArgsBuilder.() -> Unit): GetVirtualHostsResult {
        val builder = GetVirtualHostsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualHostsResultToKotlin(getVirtualHostsPlain(builtArgument.toJava()).await())
    }
}
