@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Binding].
 */
@PulumiTagMarker
public class BindingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BindingArgs = BindingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BindingArgsBuilder.() -> Unit) {
        val builder = BindingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Binding {
        val builtJavaResource = com.pulumi.alicloud.amqp.Binding(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Binding(builtJavaResource)
    }
}

/**
 * Provides a RabbitMQ (AMQP) Binding resource.
 * For information about RabbitMQ (AMQP) Binding and how to use it, see [What is Binding](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createbinding).
 * > **NOTE:** Available since v1.135.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.amqp.Instance("default", {
 *     instanceType: "enterprise",
 *     maxTps: "3000",
 *     queueCapacity: "200",
 *     storageSize: "700",
 *     supportEip: false,
 *     maxEipTps: "128",
 *     paymentType: "Subscription",
 * });
 * const defaultVirtualHost = new alicloud.amqp.VirtualHost("default", {
 *     instanceId: _default.id,
 *     virtualHostName: name,
 * });
 * const defaultExchange = new alicloud.amqp.Exchange("default", {
 *     instanceId: _default.id,
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 *     exchangeName: name,
 *     exchangeType: "HEADERS",
 *     autoDeleteState: false,
 *     internal: false,
 * });
 * const defaultQueue = new alicloud.amqp.Queue("default", {
 *     instanceId: _default.id,
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 *     queueName: name,
 * });
 * const defaultBinding = new alicloud.amqp.Binding("default", {
 *     instanceId: _default.id,
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 *     sourceExchange: defaultExchange.exchangeName,
 *     destinationName: name,
 *     bindingType: "QUEUE",
 *     bindingKey: defaultQueue.queueName,
 *     argument: "x-match:all",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.amqp.Instance("default",
 *     instance_type="enterprise",
 *     max_tps="3000",
 *     queue_capacity="200",
 *     storage_size="700",
 *     support_eip=False,
 *     max_eip_tps="128",
 *     payment_type="Subscription")
 * default_virtual_host = alicloud.amqp.VirtualHost("default",
 *     instance_id=default.id,
 *     virtual_host_name=name)
 * default_exchange = alicloud.amqp.Exchange("default",
 *     instance_id=default.id,
 *     virtual_host_name=default_virtual_host.virtual_host_name,
 *     exchange_name=name,
 *     exchange_type="HEADERS",
 *     auto_delete_state=False,
 *     internal=False)
 * default_queue = alicloud.amqp.Queue("default",
 *     instance_id=default.id,
 *     virtual_host_name=default_virtual_host.virtual_host_name,
 *     queue_name=name)
 * default_binding = alicloud.amqp.Binding("default",
 *     instance_id=default.id,
 *     virtual_host_name=default_virtual_host.virtual_host_name,
 *     source_exchange=default_exchange.exchange_name,
 *     destination_name=name,
 *     binding_type="QUEUE",
 *     binding_key=default_queue.queue_name,
 *     argument="x-match:all")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Amqp.Instance("default", new()
 *     {
 *         InstanceType = "enterprise",
 *         MaxTps = "3000",
 *         QueueCapacity = "200",
 *         StorageSize = "700",
 *         SupportEip = false,
 *         MaxEipTps = "128",
 *         PaymentType = "Subscription",
 *     });
 *     var defaultVirtualHost = new AliCloud.Amqp.VirtualHost("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = name,
 *     });
 *     var defaultExchange = new AliCloud.Amqp.Exchange("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *         ExchangeName = name,
 *         ExchangeType = "HEADERS",
 *         AutoDeleteState = false,
 *         Internal = false,
 *     });
 *     var defaultQueue = new AliCloud.Amqp.Queue("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *         QueueName = name,
 *     });
 *     var defaultBinding = new AliCloud.Amqp.Binding("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *         SourceExchange = defaultExchange.ExchangeName,
 *         DestinationName = name,
 *         BindingType = "QUEUE",
 *         BindingKey = defaultQueue.QueueName,
 *         Argument = "x-match:all",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := amqp.NewInstance(ctx, "default", &amqp.InstanceArgs{
 * 			InstanceType:  pulumi.String("enterprise"),
 * 			MaxTps:        pulumi.String("3000"),
 * 			QueueCapacity: pulumi.String("200"),
 * 			StorageSize:   pulumi.String("700"),
 * 			SupportEip:    pulumi.Bool(false),
 * 			MaxEipTps:     pulumi.String("128"),
 * 			PaymentType:   pulumi.String("Subscription"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVirtualHost, err := amqp.NewVirtualHost(ctx, "default", &amqp.VirtualHostArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultExchange, err := amqp.NewExchange(ctx, "default", &amqp.ExchangeArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 			ExchangeName:    pulumi.String(name),
 * 			ExchangeType:    pulumi.String("HEADERS"),
 * 			AutoDeleteState: pulumi.Bool(false),
 * 			Internal:        pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultQueue, err := amqp.NewQueue(ctx, "default", &amqp.QueueArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 			QueueName:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amqp.NewBinding(ctx, "default", &amqp.BindingArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 			SourceExchange:  defaultExchange.ExchangeName,
 * 			DestinationName: pulumi.String(name),
 * 			BindingType:     pulumi.String("QUEUE"),
 * 			BindingKey:      defaultQueue.QueueName,
 * 			Argument:        pulumi.String("x-match:all"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.amqp.Instance;
 * import com.pulumi.alicloud.amqp.InstanceArgs;
 * import com.pulumi.alicloud.amqp.VirtualHost;
 * import com.pulumi.alicloud.amqp.VirtualHostArgs;
 * import com.pulumi.alicloud.amqp.Exchange;
 * import com.pulumi.alicloud.amqp.ExchangeArgs;
 * import com.pulumi.alicloud.amqp.Queue;
 * import com.pulumi.alicloud.amqp.QueueArgs;
 * import com.pulumi.alicloud.amqp.Binding;
 * import com.pulumi.alicloud.amqp.BindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .instanceType("enterprise")
 *             .maxTps(3000)
 *             .queueCapacity(200)
 *             .storageSize(700)
 *             .supportEip(false)
 *             .maxEipTps(128)
 *             .paymentType("Subscription")
 *             .build());
 *         var defaultVirtualHost = new VirtualHost("defaultVirtualHost", VirtualHostArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName(name)
 *             .build());
 *         var defaultExchange = new Exchange("defaultExchange", ExchangeArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .exchangeName(name)
 *             .exchangeType("HEADERS")
 *             .autoDeleteState(false)
 *             .internal(false)
 *             .build());
 *         var defaultQueue = new Queue("defaultQueue", QueueArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .queueName(name)
 *             .build());
 *         var defaultBinding = new Binding("defaultBinding", BindingArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .sourceExchange(defaultExchange.exchangeName())
 *             .destinationName(name)
 *             .bindingType("QUEUE")
 *             .bindingKey(defaultQueue.queueName())
 *             .argument("x-match:all")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:amqp:Instance
 *     properties:
 *       instanceType: enterprise
 *       maxTps: 3000
 *       queueCapacity: 200
 *       storageSize: 700
 *       supportEip: false
 *       maxEipTps: 128
 *       paymentType: Subscription
 *   defaultVirtualHost:
 *     type: alicloud:amqp:VirtualHost
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: ${name}
 *   defaultExchange:
 *     type: alicloud:amqp:Exchange
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 *       exchangeName: ${name}
 *       exchangeType: HEADERS
 *       autoDeleteState: false
 *       internal: false
 *   defaultQueue:
 *     type: alicloud:amqp:Queue
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 *       queueName: ${name}
 *   defaultBinding:
 *     type: alicloud:amqp:Binding
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 *       sourceExchange: ${defaultExchange.exchangeName}
 *       destinationName: ${name}
 *       bindingType: QUEUE
 *       bindingKey: ${defaultQueue.queueName}
 *       argument: x-match:all
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RabbitMQ (AMQP) Binding can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:amqp/binding:Binding example <instance_id>:<virtual_host_name>:<source_exchange>:<destination_name>
 * ```
 */
public class Binding internal constructor(
    override val javaResource: com.pulumi.alicloud.amqp.Binding,
) : KotlinCustomResource(javaResource, BindingMapper) {
    /**
     * The key-value pairs that are configured for the headers attributes of a message. Default value: `x-match:all`. Valid values:
     * - `x-match:all`: A headers exchange routes a message to a queue only if all binding attributes of the queue except for x-match match the headers attributes of the message.
     * - `x-match:any`: A headers exchange routes a message to a queue if one or more binding attributes of the queue except for x-match match the headers attributes of the message.
     * - > **NOTE:** If the exchange type is not 'HEADERS', the `argument` should not been set, otherwise, there are always "forces replacement" changes.
     */
    public val argument: Output<String>
        get() = javaResource.argument().applyValue({ args0 -> args0 })

    /**
     * The Binding Key.
     * * For a non-topic source exchange: The binding key can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     * The binding key must be 1 to 255 characters in length.
     * * For a topic source exchange: The binding key can contain letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     * If the binding key contains a number sign (#), the binding key must start with a number sign (#) followed by a period (.) or end with a number sign (#) that follows a period (.).
     * The binding key must be 1 to 255 characters in length.
     */
    public val bindingKey: Output<String>
        get() = javaResource.bindingKey().applyValue({ args0 -> args0 })

    /**
     * The type of the object that you want to bind to the source exchange. Valid values: `EXCHANGE`, `QUEUE`.
     */
    public val bindingType: Output<String>
        get() = javaResource.bindingType().applyValue({ args0 -> args0 })

    /**
     * The name of the object that you want to bind to the source exchange.
     */
    public val destinationName: Output<String>
        get() = javaResource.destinationName().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The name of the source exchange.
     */
    public val sourceExchange: Output<String>
        get() = javaResource.sourceExchange().applyValue({ args0 -> args0 })

    /**
     * The name of the vhost.
     */
    public val virtualHostName: Output<String>
        get() = javaResource.virtualHostName().applyValue({ args0 -> args0 })
}

public object BindingMapper : ResourceMapper<Binding> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.amqp.Binding::class == javaResource::class

    override fun map(javaResource: Resource): Binding = Binding(
        javaResource as
            com.pulumi.alicloud.amqp.Binding,
    )
}

/**
 * @see [Binding].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Binding].
 */
public suspend fun binding(name: String, block: suspend BindingResourceBuilder.() -> Unit): Binding {
    val builder = BindingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Binding].
 * @param name The _unique_ name of the resulting resource.
 */
public fun binding(name: String): Binding {
    val builder = BindingResourceBuilder()
    builder.name(name)
    return builder.build()
}
