@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin

import com.pulumi.alicloud.amqp.BindingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RabbitMQ (AMQP) Binding resource.
 * For information about RabbitMQ (AMQP) Binding and how to use it, see [What is Binding](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createbinding).
 * > **NOTE:** Available since v1.135.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.amqp.Instance("default", {
 *     instanceType: "enterprise",
 *     maxTps: "3000",
 *     queueCapacity: "200",
 *     storageSize: "700",
 *     supportEip: false,
 *     maxEipTps: "128",
 *     paymentType: "Subscription",
 * });
 * const defaultVirtualHost = new alicloud.amqp.VirtualHost("default", {
 *     instanceId: _default.id,
 *     virtualHostName: name,
 * });
 * const defaultExchange = new alicloud.amqp.Exchange("default", {
 *     instanceId: _default.id,
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 *     exchangeName: name,
 *     exchangeType: "HEADERS",
 *     autoDeleteState: false,
 *     internal: false,
 * });
 * const defaultQueue = new alicloud.amqp.Queue("default", {
 *     instanceId: _default.id,
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 *     queueName: name,
 * });
 * const defaultBinding = new alicloud.amqp.Binding("default", {
 *     instanceId: _default.id,
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 *     sourceExchange: defaultExchange.exchangeName,
 *     destinationName: name,
 *     bindingType: "QUEUE",
 *     bindingKey: defaultQueue.queueName,
 *     argument: "x-match:all",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.amqp.Instance("default",
 *     instance_type="enterprise",
 *     max_tps="3000",
 *     queue_capacity="200",
 *     storage_size="700",
 *     support_eip=False,
 *     max_eip_tps="128",
 *     payment_type="Subscription")
 * default_virtual_host = alicloud.amqp.VirtualHost("default",
 *     instance_id=default.id,
 *     virtual_host_name=name)
 * default_exchange = alicloud.amqp.Exchange("default",
 *     instance_id=default.id,
 *     virtual_host_name=default_virtual_host.virtual_host_name,
 *     exchange_name=name,
 *     exchange_type="HEADERS",
 *     auto_delete_state=False,
 *     internal=False)
 * default_queue = alicloud.amqp.Queue("default",
 *     instance_id=default.id,
 *     virtual_host_name=default_virtual_host.virtual_host_name,
 *     queue_name=name)
 * default_binding = alicloud.amqp.Binding("default",
 *     instance_id=default.id,
 *     virtual_host_name=default_virtual_host.virtual_host_name,
 *     source_exchange=default_exchange.exchange_name,
 *     destination_name=name,
 *     binding_type="QUEUE",
 *     binding_key=default_queue.queue_name,
 *     argument="x-match:all")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Amqp.Instance("default", new()
 *     {
 *         InstanceType = "enterprise",
 *         MaxTps = "3000",
 *         QueueCapacity = "200",
 *         StorageSize = "700",
 *         SupportEip = false,
 *         MaxEipTps = "128",
 *         PaymentType = "Subscription",
 *     });
 *     var defaultVirtualHost = new AliCloud.Amqp.VirtualHost("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = name,
 *     });
 *     var defaultExchange = new AliCloud.Amqp.Exchange("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *         ExchangeName = name,
 *         ExchangeType = "HEADERS",
 *         AutoDeleteState = false,
 *         Internal = false,
 *     });
 *     var defaultQueue = new AliCloud.Amqp.Queue("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *         QueueName = name,
 *     });
 *     var defaultBinding = new AliCloud.Amqp.Binding("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *         SourceExchange = defaultExchange.ExchangeName,
 *         DestinationName = name,
 *         BindingType = "QUEUE",
 *         BindingKey = defaultQueue.QueueName,
 *         Argument = "x-match:all",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := amqp.NewInstance(ctx, "default", &amqp.InstanceArgs{
 * 			InstanceType:  pulumi.String("enterprise"),
 * 			MaxTps:        pulumi.String("3000"),
 * 			QueueCapacity: pulumi.String("200"),
 * 			StorageSize:   pulumi.String("700"),
 * 			SupportEip:    pulumi.Bool(false),
 * 			MaxEipTps:     pulumi.String("128"),
 * 			PaymentType:   pulumi.String("Subscription"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVirtualHost, err := amqp.NewVirtualHost(ctx, "default", &amqp.VirtualHostArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultExchange, err := amqp.NewExchange(ctx, "default", &amqp.ExchangeArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 			ExchangeName:    pulumi.String(name),
 * 			ExchangeType:    pulumi.String("HEADERS"),
 * 			AutoDeleteState: pulumi.Bool(false),
 * 			Internal:        pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultQueue, err := amqp.NewQueue(ctx, "default", &amqp.QueueArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 			QueueName:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amqp.NewBinding(ctx, "default", &amqp.BindingArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 			SourceExchange:  defaultExchange.ExchangeName,
 * 			DestinationName: pulumi.String(name),
 * 			BindingType:     pulumi.String("QUEUE"),
 * 			BindingKey:      defaultQueue.QueueName,
 * 			Argument:        pulumi.String("x-match:all"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.amqp.Instance;
 * import com.pulumi.alicloud.amqp.InstanceArgs;
 * import com.pulumi.alicloud.amqp.VirtualHost;
 * import com.pulumi.alicloud.amqp.VirtualHostArgs;
 * import com.pulumi.alicloud.amqp.Exchange;
 * import com.pulumi.alicloud.amqp.ExchangeArgs;
 * import com.pulumi.alicloud.amqp.Queue;
 * import com.pulumi.alicloud.amqp.QueueArgs;
 * import com.pulumi.alicloud.amqp.Binding;
 * import com.pulumi.alicloud.amqp.BindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .instanceType("enterprise")
 *             .maxTps(3000)
 *             .queueCapacity(200)
 *             .storageSize(700)
 *             .supportEip(false)
 *             .maxEipTps(128)
 *             .paymentType("Subscription")
 *             .build());
 *         var defaultVirtualHost = new VirtualHost("defaultVirtualHost", VirtualHostArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName(name)
 *             .build());
 *         var defaultExchange = new Exchange("defaultExchange", ExchangeArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .exchangeName(name)
 *             .exchangeType("HEADERS")
 *             .autoDeleteState(false)
 *             .internal(false)
 *             .build());
 *         var defaultQueue = new Queue("defaultQueue", QueueArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .queueName(name)
 *             .build());
 *         var defaultBinding = new Binding("defaultBinding", BindingArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .sourceExchange(defaultExchange.exchangeName())
 *             .destinationName(name)
 *             .bindingType("QUEUE")
 *             .bindingKey(defaultQueue.queueName())
 *             .argument("x-match:all")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:amqp:Instance
 *     properties:
 *       instanceType: enterprise
 *       maxTps: 3000
 *       queueCapacity: 200
 *       storageSize: 700
 *       supportEip: false
 *       maxEipTps: 128
 *       paymentType: Subscription
 *   defaultVirtualHost:
 *     type: alicloud:amqp:VirtualHost
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: ${name}
 *   defaultExchange:
 *     type: alicloud:amqp:Exchange
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 *       exchangeName: ${name}
 *       exchangeType: HEADERS
 *       autoDeleteState: false
 *       internal: false
 *   defaultQueue:
 *     type: alicloud:amqp:Queue
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 *       queueName: ${name}
 *   defaultBinding:
 *     type: alicloud:amqp:Binding
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 *       sourceExchange: ${defaultExchange.exchangeName}
 *       destinationName: ${name}
 *       bindingType: QUEUE
 *       bindingKey: ${defaultQueue.queueName}
 *       argument: x-match:all
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RabbitMQ (AMQP) Binding can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:amqp/binding:Binding example <instance_id>:<virtual_host_name>:<source_exchange>:<destination_name>
 * ```
 * @property argument The key-value pairs that are configured for the headers attributes of a message. Default value: `x-match:all`. Valid values:
 * - `x-match:all`: A headers exchange routes a message to a queue only if all binding attributes of the queue except for x-match match the headers attributes of the message.
 * - `x-match:any`: A headers exchange routes a message to a queue if one or more binding attributes of the queue except for x-match match the headers attributes of the message.
 * - > **NOTE:** If the exchange type is not 'HEADERS', the `argument` should not been set, otherwise, there are always "forces replacement" changes.
 * @property bindingKey The Binding Key.
 * * For a non-topic source exchange: The binding key can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
 * The binding key must be 1 to 255 characters in length.
 * * For a topic source exchange: The binding key can contain letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
 * If the binding key contains a number sign (#), the binding key must start with a number sign (#) followed by a period (.) or end with a number sign (#) that follows a period (.).
 * The binding key must be 1 to 255 characters in length.
 * @property bindingType The type of the object that you want to bind to the source exchange. Valid values: `EXCHANGE`, `QUEUE`.
 * @property destinationName The name of the object that you want to bind to the source exchange.
 * @property instanceId The ID of the instance.
 * @property sourceExchange The name of the source exchange.
 * @property virtualHostName The name of the vhost.
 */
public data class BindingArgs(
    public val argument: Output<String>? = null,
    public val bindingKey: Output<String>? = null,
    public val bindingType: Output<String>? = null,
    public val destinationName: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val sourceExchange: Output<String>? = null,
    public val virtualHostName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.amqp.BindingArgs> {
    override fun toJava(): com.pulumi.alicloud.amqp.BindingArgs =
        com.pulumi.alicloud.amqp.BindingArgs.builder()
            .argument(argument?.applyValue({ args0 -> args0 }))
            .bindingKey(bindingKey?.applyValue({ args0 -> args0 }))
            .bindingType(bindingType?.applyValue({ args0 -> args0 }))
            .destinationName(destinationName?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .sourceExchange(sourceExchange?.applyValue({ args0 -> args0 }))
            .virtualHostName(virtualHostName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BindingArgs].
 */
@PulumiTagMarker
public class BindingArgsBuilder internal constructor() {
    private var argument: Output<String>? = null

    private var bindingKey: Output<String>? = null

    private var bindingType: Output<String>? = null

    private var destinationName: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var sourceExchange: Output<String>? = null

    private var virtualHostName: Output<String>? = null

    /**
     * @param value The key-value pairs that are configured for the headers attributes of a message. Default value: `x-match:all`. Valid values:
     * - `x-match:all`: A headers exchange routes a message to a queue only if all binding attributes of the queue except for x-match match the headers attributes of the message.
     * - `x-match:any`: A headers exchange routes a message to a queue if one or more binding attributes of the queue except for x-match match the headers attributes of the message.
     * - > **NOTE:** If the exchange type is not 'HEADERS', the `argument` should not been set, otherwise, there are always "forces replacement" changes.
     */
    @JvmName("eytkpxxavncoddmn")
    public suspend fun argument(`value`: Output<String>) {
        this.argument = value
    }

    /**
     * @param value The Binding Key.
     * * For a non-topic source exchange: The binding key can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     * The binding key must be 1 to 255 characters in length.
     * * For a topic source exchange: The binding key can contain letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     * If the binding key contains a number sign (#), the binding key must start with a number sign (#) followed by a period (.) or end with a number sign (#) that follows a period (.).
     * The binding key must be 1 to 255 characters in length.
     */
    @JvmName("pnoikpmwdbeeppdw")
    public suspend fun bindingKey(`value`: Output<String>) {
        this.bindingKey = value
    }

    /**
     * @param value The type of the object that you want to bind to the source exchange. Valid values: `EXCHANGE`, `QUEUE`.
     */
    @JvmName("riwemassuceehlby")
    public suspend fun bindingType(`value`: Output<String>) {
        this.bindingType = value
    }

    /**
     * @param value The name of the object that you want to bind to the source exchange.
     */
    @JvmName("youfwfqsdhhyhmqa")
    public suspend fun destinationName(`value`: Output<String>) {
        this.destinationName = value
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("jtcupvgqykntcdvd")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of the source exchange.
     */
    @JvmName("avoxxsokrkxkriba")
    public suspend fun sourceExchange(`value`: Output<String>) {
        this.sourceExchange = value
    }

    /**
     * @param value The name of the vhost.
     */
    @JvmName("gubwfkjgtfajjhpp")
    public suspend fun virtualHostName(`value`: Output<String>) {
        this.virtualHostName = value
    }

    /**
     * @param value The key-value pairs that are configured for the headers attributes of a message. Default value: `x-match:all`. Valid values:
     * - `x-match:all`: A headers exchange routes a message to a queue only if all binding attributes of the queue except for x-match match the headers attributes of the message.
     * - `x-match:any`: A headers exchange routes a message to a queue if one or more binding attributes of the queue except for x-match match the headers attributes of the message.
     * - > **NOTE:** If the exchange type is not 'HEADERS', the `argument` should not been set, otherwise, there are always "forces replacement" changes.
     */
    @JvmName("pjalotwlvoychnuf")
    public suspend fun argument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.argument = mapped
    }

    /**
     * @param value The Binding Key.
     * * For a non-topic source exchange: The binding key can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     * The binding key must be 1 to 255 characters in length.
     * * For a topic source exchange: The binding key can contain letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     * If the binding key contains a number sign (#), the binding key must start with a number sign (#) followed by a period (.) or end with a number sign (#) that follows a period (.).
     * The binding key must be 1 to 255 characters in length.
     */
    @JvmName("uavshfuqsabqmtcn")
    public suspend fun bindingKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindingKey = mapped
    }

    /**
     * @param value The type of the object that you want to bind to the source exchange. Valid values: `EXCHANGE`, `QUEUE`.
     */
    @JvmName("uvisnqsnhuudgccf")
    public suspend fun bindingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindingType = mapped
    }

    /**
     * @param value The name of the object that you want to bind to the source exchange.
     */
    @JvmName("lbegwysyarobhjcm")
    public suspend fun destinationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationName = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("tdlyfsbcdykvkmwi")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the source exchange.
     */
    @JvmName("glyxrsvwkgvarqwn")
    public suspend fun sourceExchange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceExchange = mapped
    }

    /**
     * @param value The name of the vhost.
     */
    @JvmName("eiljrhaembreyvvf")
    public suspend fun virtualHostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHostName = mapped
    }

    internal fun build(): BindingArgs = BindingArgs(
        argument = argument,
        bindingKey = bindingKey,
        bindingType = bindingType,
        destinationName = destinationName,
        instanceId = instanceId,
        sourceExchange = sourceExchange,
        virtualHostName = virtualHostName,
    )
}
