@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Exchange].
 */
@PulumiTagMarker
public class ExchangeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExchangeArgs = ExchangeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExchangeArgsBuilder.() -> Unit) {
        val builder = ExchangeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Exchange {
        val builtJavaResource = com.pulumi.alicloud.amqp.Exchange(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Exchange(builtJavaResource)
    }
}

/**
 * Provides a RabbitMQ (AMQP) Exchange resource.
 * For information about RabbitMQ (AMQP) Exchange and how to use it, see [What is Exchange](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createexchange).
 * > **NOTE:** Available since v1.128.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.amqp.Instance("default", {
 *     instanceType: "professional",
 *     maxTps: "1000",
 *     queueCapacity: "50",
 *     supportEip: true,
 *     maxEipTps: "128",
 *     paymentType: "Subscription",
 *     period: 1,
 * });
 * const defaultVirtualHost = new alicloud.amqp.VirtualHost("default", {
 *     instanceId: _default.id,
 *     virtualHostName: "tf-example",
 * });
 * const defaultExchange = new alicloud.amqp.Exchange("default", {
 *     autoDeleteState: false,
 *     exchangeName: "tf-example",
 *     exchangeType: "DIRECT",
 *     instanceId: _default.id,
 *     internal: false,
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.amqp.Instance("default",
 *     instance_type="professional",
 *     max_tps="1000",
 *     queue_capacity="50",
 *     support_eip=True,
 *     max_eip_tps="128",
 *     payment_type="Subscription",
 *     period=1)
 * default_virtual_host = alicloud.amqp.VirtualHost("default",
 *     instance_id=default.id,
 *     virtual_host_name="tf-example")
 * default_exchange = alicloud.amqp.Exchange("default",
 *     auto_delete_state=False,
 *     exchange_name="tf-example",
 *     exchange_type="DIRECT",
 *     instance_id=default.id,
 *     internal=False,
 *     virtual_host_name=default_virtual_host.virtual_host_name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Amqp.Instance("default", new()
 *     {
 *         InstanceType = "professional",
 *         MaxTps = "1000",
 *         QueueCapacity = "50",
 *         SupportEip = true,
 *         MaxEipTps = "128",
 *         PaymentType = "Subscription",
 *         Period = 1,
 *     });
 *     var defaultVirtualHost = new AliCloud.Amqp.VirtualHost("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = "tf-example",
 *     });
 *     var defaultExchange = new AliCloud.Amqp.Exchange("default", new()
 *     {
 *         AutoDeleteState = false,
 *         ExchangeName = "tf-example",
 *         ExchangeType = "DIRECT",
 *         InstanceId = @default.Id,
 *         Internal = false,
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amqp.NewInstance(ctx, "default", &amqp.InstanceArgs{
 * 			InstanceType:  pulumi.String("professional"),
 * 			MaxTps:        pulumi.String("1000"),
 * 			QueueCapacity: pulumi.String("50"),
 * 			SupportEip:    pulumi.Bool(true),
 * 			MaxEipTps:     pulumi.String("128"),
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVirtualHost, err := amqp.NewVirtualHost(ctx, "default", &amqp.VirtualHostArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amqp.NewExchange(ctx, "default", &amqp.ExchangeArgs{
 * 			AutoDeleteState: pulumi.Bool(false),
 * 			ExchangeName:    pulumi.String("tf-example"),
 * 			ExchangeType:    pulumi.String("DIRECT"),
 * 			InstanceId:      _default.ID(),
 * 			Internal:        pulumi.Bool(false),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.amqp.Instance;
 * import com.pulumi.alicloud.amqp.InstanceArgs;
 * import com.pulumi.alicloud.amqp.VirtualHost;
 * import com.pulumi.alicloud.amqp.VirtualHostArgs;
 * import com.pulumi.alicloud.amqp.Exchange;
 * import com.pulumi.alicloud.amqp.ExchangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .instanceType("professional")
 *             .maxTps(1000)
 *             .queueCapacity(50)
 *             .supportEip(true)
 *             .maxEipTps(128)
 *             .paymentType("Subscription")
 *             .period(1)
 *             .build());
 *         var defaultVirtualHost = new VirtualHost("defaultVirtualHost", VirtualHostArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName("tf-example")
 *             .build());
 *         var defaultExchange = new Exchange("defaultExchange", ExchangeArgs.builder()
 *             .autoDeleteState(false)
 *             .exchangeName("tf-example")
 *             .exchangeType("DIRECT")
 *             .instanceId(default_.id())
 *             .internal(false)
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:amqp:Instance
 *     properties:
 *       instanceType: professional
 *       maxTps: 1000
 *       queueCapacity: 50
 *       supportEip: true
 *       maxEipTps: 128
 *       paymentType: Subscription
 *       period: 1
 *   defaultVirtualHost:
 *     type: alicloud:amqp:VirtualHost
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: tf-example
 *   defaultExchange:
 *     type: alicloud:amqp:Exchange
 *     name: default
 *     properties:
 *       autoDeleteState: false
 *       exchangeName: tf-example
 *       exchangeType: DIRECT
 *       instanceId: ${default.id}
 *       internal: false
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RabbitMQ (AMQP) Exchange can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:amqp/exchange:Exchange example <instance_id>:<virtual_host_name>:<exchange_name>
 * ```
 */
public class Exchange internal constructor(
    override val javaResource: com.pulumi.alicloud.amqp.Exchange,
) : KotlinCustomResource(javaResource, ExchangeMapper) {
    /**
     * The alternate exchange. An alternate exchange is configured for an existing exchange. It is used to receive messages that fail to be routed to queues from the existing exchange.
     */
    public val alternateExchange: Output<String>?
        get() = javaResource.alternateExchange().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the Auto Delete attribute is configured. Valid values:
     * * true: The Auto Delete attribute is configured. If the last queue that is bound to an exchange is unbound, the exchange is automatically deleted.
     * * false: The Auto Delete attribute is not configured. If the last queue that is bound to an exchange is unbound, the exchange is not automatically deleted.
     */
    public val autoDeleteState: Output<Boolean>
        get() = javaResource.autoDeleteState().applyValue({ args0 -> args0 })

    /**
     * The name of the exchange. It must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     */
    public val exchangeName: Output<String>
        get() = javaResource.exchangeName().applyValue({ args0 -> args0 })

    /**
     * The type of the exchange. Valid values:
     * * FANOUT: An exchange of this type routes all the received messages to all the queues bound to this exchange. You can use a fanout exchange to broadcast messages.
     * * DIRECT: An exchange of this type routes a message to the queue whose binding key is exactly the same as the routing key of the message.
     * * TOPIC: This type is similar to the direct exchange type. An exchange of this type routes a message to one or more queues based on the fuzzy match or multi-condition match result between the routing key of the message and the binding keys of the current exchange.
     * * HEADERS: Headers Exchange uses the Headers property instead of Routing Key for routing matching.
     * When binding Headers Exchange and Queue, set the key-value pair of the binding property;
     * when sending a message to the Headers Exchange, set the message's Headers property key-value pair and use the message Headers
     * The message is routed to the bound Queue by comparing the attribute key-value pair and the bound attribute key-value pair.
     */
    public val exchangeType: Output<String>
        get() = javaResource.exchangeType().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether an exchange is an internal exchange. Valid values:
     * * false: The exchange is not an internal exchange.
     * * true: The exchange is an internal exchange.
     */
    public val `internal`: Output<Boolean>
        get() = javaResource.`internal`().applyValue({ args0 -> args0 })

    /**
     * The name of virtual host where an exchange resides.
     */
    public val virtualHostName: Output<String>
        get() = javaResource.virtualHostName().applyValue({ args0 -> args0 })
}

public object ExchangeMapper : ResourceMapper<Exchange> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.amqp.Exchange::class == javaResource::class

    override fun map(javaResource: Resource): Exchange = Exchange(
        javaResource as
            com.pulumi.alicloud.amqp.Exchange,
    )
}

/**
 * @see [Exchange].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Exchange].
 */
public suspend fun exchange(name: String, block: suspend ExchangeResourceBuilder.() -> Unit): Exchange {
    val builder = ExchangeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Exchange].
 * @param name The _unique_ name of the resulting resource.
 */
public fun exchange(name: String): Exchange {
    val builder = ExchangeResourceBuilder()
    builder.name(name)
    return builder.build()
}
