@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin

import com.pulumi.alicloud.amqp.ExchangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RabbitMQ (AMQP) Exchange resource.
 * For information about RabbitMQ (AMQP) Exchange and how to use it, see [What is Exchange](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createexchange).
 * > **NOTE:** Available since v1.128.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.amqp.Instance("default", {
 *     instanceType: "professional",
 *     maxTps: "1000",
 *     queueCapacity: "50",
 *     supportEip: true,
 *     maxEipTps: "128",
 *     paymentType: "Subscription",
 *     period: 1,
 * });
 * const defaultVirtualHost = new alicloud.amqp.VirtualHost("default", {
 *     instanceId: _default.id,
 *     virtualHostName: "tf-example",
 * });
 * const defaultExchange = new alicloud.amqp.Exchange("default", {
 *     autoDeleteState: false,
 *     exchangeName: "tf-example",
 *     exchangeType: "DIRECT",
 *     instanceId: _default.id,
 *     internal: false,
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.amqp.Instance("default",
 *     instance_type="professional",
 *     max_tps="1000",
 *     queue_capacity="50",
 *     support_eip=True,
 *     max_eip_tps="128",
 *     payment_type="Subscription",
 *     period=1)
 * default_virtual_host = alicloud.amqp.VirtualHost("default",
 *     instance_id=default.id,
 *     virtual_host_name="tf-example")
 * default_exchange = alicloud.amqp.Exchange("default",
 *     auto_delete_state=False,
 *     exchange_name="tf-example",
 *     exchange_type="DIRECT",
 *     instance_id=default.id,
 *     internal=False,
 *     virtual_host_name=default_virtual_host.virtual_host_name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Amqp.Instance("default", new()
 *     {
 *         InstanceType = "professional",
 *         MaxTps = "1000",
 *         QueueCapacity = "50",
 *         SupportEip = true,
 *         MaxEipTps = "128",
 *         PaymentType = "Subscription",
 *         Period = 1,
 *     });
 *     var defaultVirtualHost = new AliCloud.Amqp.VirtualHost("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = "tf-example",
 *     });
 *     var defaultExchange = new AliCloud.Amqp.Exchange("default", new()
 *     {
 *         AutoDeleteState = false,
 *         ExchangeName = "tf-example",
 *         ExchangeType = "DIRECT",
 *         InstanceId = @default.Id,
 *         Internal = false,
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amqp.NewInstance(ctx, "default", &amqp.InstanceArgs{
 * 			InstanceType:  pulumi.String("professional"),
 * 			MaxTps:        pulumi.String("1000"),
 * 			QueueCapacity: pulumi.String("50"),
 * 			SupportEip:    pulumi.Bool(true),
 * 			MaxEipTps:     pulumi.String("128"),
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVirtualHost, err := amqp.NewVirtualHost(ctx, "default", &amqp.VirtualHostArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amqp.NewExchange(ctx, "default", &amqp.ExchangeArgs{
 * 			AutoDeleteState: pulumi.Bool(false),
 * 			ExchangeName:    pulumi.String("tf-example"),
 * 			ExchangeType:    pulumi.String("DIRECT"),
 * 			InstanceId:      _default.ID(),
 * 			Internal:        pulumi.Bool(false),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.amqp.Instance;
 * import com.pulumi.alicloud.amqp.InstanceArgs;
 * import com.pulumi.alicloud.amqp.VirtualHost;
 * import com.pulumi.alicloud.amqp.VirtualHostArgs;
 * import com.pulumi.alicloud.amqp.Exchange;
 * import com.pulumi.alicloud.amqp.ExchangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .instanceType("professional")
 *             .maxTps(1000)
 *             .queueCapacity(50)
 *             .supportEip(true)
 *             .maxEipTps(128)
 *             .paymentType("Subscription")
 *             .period(1)
 *             .build());
 *         var defaultVirtualHost = new VirtualHost("defaultVirtualHost", VirtualHostArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName("tf-example")
 *             .build());
 *         var defaultExchange = new Exchange("defaultExchange", ExchangeArgs.builder()
 *             .autoDeleteState(false)
 *             .exchangeName("tf-example")
 *             .exchangeType("DIRECT")
 *             .instanceId(default_.id())
 *             .internal(false)
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:amqp:Instance
 *     properties:
 *       instanceType: professional
 *       maxTps: 1000
 *       queueCapacity: 50
 *       supportEip: true
 *       maxEipTps: 128
 *       paymentType: Subscription
 *       period: 1
 *   defaultVirtualHost:
 *     type: alicloud:amqp:VirtualHost
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: tf-example
 *   defaultExchange:
 *     type: alicloud:amqp:Exchange
 *     name: default
 *     properties:
 *       autoDeleteState: false
 *       exchangeName: tf-example
 *       exchangeType: DIRECT
 *       instanceId: ${default.id}
 *       internal: false
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RabbitMQ (AMQP) Exchange can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:amqp/exchange:Exchange example <instance_id>:<virtual_host_name>:<exchange_name>
 * ```
 * @property alternateExchange The alternate exchange. An alternate exchange is configured for an existing exchange. It is used to receive messages that fail to be routed to queues from the existing exchange.
 * @property autoDeleteState Specifies whether the Auto Delete attribute is configured. Valid values:
 * * true: The Auto Delete attribute is configured. If the last queue that is bound to an exchange is unbound, the exchange is automatically deleted.
 * * false: The Auto Delete attribute is not configured. If the last queue that is bound to an exchange is unbound, the exchange is not automatically deleted.
 * @property exchangeName The name of the exchange. It must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
 * @property exchangeType The type of the exchange. Valid values:
 * * FANOUT: An exchange of this type routes all the received messages to all the queues bound to this exchange. You can use a fanout exchange to broadcast messages.
 * * DIRECT: An exchange of this type routes a message to the queue whose binding key is exactly the same as the routing key of the message.
 * * TOPIC: This type is similar to the direct exchange type. An exchange of this type routes a message to one or more queues based on the fuzzy match or multi-condition match result between the routing key of the message and the binding keys of the current exchange.
 * * HEADERS: Headers Exchange uses the Headers property instead of Routing Key for routing matching.
 * When binding Headers Exchange and Queue, set the key-value pair of the binding property;
 * when sending a message to the Headers Exchange, set the message's Headers property key-value pair and use the message Headers
 * The message is routed to the bound Queue by comparing the attribute key-value pair and the bound attribute key-value pair.
 * @property instanceId The ID of the instance.
 * @property internal Specifies whether an exchange is an internal exchange. Valid values:
 * * false: The exchange is not an internal exchange.
 * * true: The exchange is an internal exchange.
 * @property virtualHostName The name of virtual host where an exchange resides.
 */
public data class ExchangeArgs(
    public val alternateExchange: Output<String>? = null,
    public val autoDeleteState: Output<Boolean>? = null,
    public val exchangeName: Output<String>? = null,
    public val exchangeType: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val `internal`: Output<Boolean>? = null,
    public val virtualHostName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.amqp.ExchangeArgs> {
    override fun toJava(): com.pulumi.alicloud.amqp.ExchangeArgs =
        com.pulumi.alicloud.amqp.ExchangeArgs.builder()
            .alternateExchange(alternateExchange?.applyValue({ args0 -> args0 }))
            .autoDeleteState(autoDeleteState?.applyValue({ args0 -> args0 }))
            .exchangeName(exchangeName?.applyValue({ args0 -> args0 }))
            .exchangeType(exchangeType?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .`internal`(`internal`?.applyValue({ args0 -> args0 }))
            .virtualHostName(virtualHostName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExchangeArgs].
 */
@PulumiTagMarker
public class ExchangeArgsBuilder internal constructor() {
    private var alternateExchange: Output<String>? = null

    private var autoDeleteState: Output<Boolean>? = null

    private var exchangeName: Output<String>? = null

    private var exchangeType: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var `internal`: Output<Boolean>? = null

    private var virtualHostName: Output<String>? = null

    /**
     * @param value The alternate exchange. An alternate exchange is configured for an existing exchange. It is used to receive messages that fail to be routed to queues from the existing exchange.
     */
    @JvmName("tlaqbhbopsqjtswh")
    public suspend fun alternateExchange(`value`: Output<String>) {
        this.alternateExchange = value
    }

    /**
     * @param value Specifies whether the Auto Delete attribute is configured. Valid values:
     * * true: The Auto Delete attribute is configured. If the last queue that is bound to an exchange is unbound, the exchange is automatically deleted.
     * * false: The Auto Delete attribute is not configured. If the last queue that is bound to an exchange is unbound, the exchange is not automatically deleted.
     */
    @JvmName("ifvubypmjoadfswg")
    public suspend fun autoDeleteState(`value`: Output<Boolean>) {
        this.autoDeleteState = value
    }

    /**
     * @param value The name of the exchange. It must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     */
    @JvmName("kckgxtcgtvqxoniu")
    public suspend fun exchangeName(`value`: Output<String>) {
        this.exchangeName = value
    }

    /**
     * @param value The type of the exchange. Valid values:
     * * FANOUT: An exchange of this type routes all the received messages to all the queues bound to this exchange. You can use a fanout exchange to broadcast messages.
     * * DIRECT: An exchange of this type routes a message to the queue whose binding key is exactly the same as the routing key of the message.
     * * TOPIC: This type is similar to the direct exchange type. An exchange of this type routes a message to one or more queues based on the fuzzy match or multi-condition match result between the routing key of the message and the binding keys of the current exchange.
     * * HEADERS: Headers Exchange uses the Headers property instead of Routing Key for routing matching.
     * When binding Headers Exchange and Queue, set the key-value pair of the binding property;
     * when sending a message to the Headers Exchange, set the message's Headers property key-value pair and use the message Headers
     * The message is routed to the bound Queue by comparing the attribute key-value pair and the bound attribute key-value pair.
     */
    @JvmName("agvmhnryhxcqqkvb")
    public suspend fun exchangeType(`value`: Output<String>) {
        this.exchangeType = value
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("qwvetwlixmwoycei")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies whether an exchange is an internal exchange. Valid values:
     * * false: The exchange is not an internal exchange.
     * * true: The exchange is an internal exchange.
     */
    @JvmName("kpbewvjyypjyxuny")
    public suspend fun `internal`(`value`: Output<Boolean>) {
        this.`internal` = value
    }

    /**
     * @param value The name of virtual host where an exchange resides.
     */
    @JvmName("bwbpetgjrjcxlnwe")
    public suspend fun virtualHostName(`value`: Output<String>) {
        this.virtualHostName = value
    }

    /**
     * @param value The alternate exchange. An alternate exchange is configured for an existing exchange. It is used to receive messages that fail to be routed to queues from the existing exchange.
     */
    @JvmName("kuxhpeophrvkrquq")
    public suspend fun alternateExchange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternateExchange = mapped
    }

    /**
     * @param value Specifies whether the Auto Delete attribute is configured. Valid values:
     * * true: The Auto Delete attribute is configured. If the last queue that is bound to an exchange is unbound, the exchange is automatically deleted.
     * * false: The Auto Delete attribute is not configured. If the last queue that is bound to an exchange is unbound, the exchange is not automatically deleted.
     */
    @JvmName("ntpfyonngsvqnfqw")
    public suspend fun autoDeleteState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeleteState = mapped
    }

    /**
     * @param value The name of the exchange. It must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     */
    @JvmName("qwsvjpxvcqqpgfib")
    public suspend fun exchangeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exchangeName = mapped
    }

    /**
     * @param value The type of the exchange. Valid values:
     * * FANOUT: An exchange of this type routes all the received messages to all the queues bound to this exchange. You can use a fanout exchange to broadcast messages.
     * * DIRECT: An exchange of this type routes a message to the queue whose binding key is exactly the same as the routing key of the message.
     * * TOPIC: This type is similar to the direct exchange type. An exchange of this type routes a message to one or more queues based on the fuzzy match or multi-condition match result between the routing key of the message and the binding keys of the current exchange.
     * * HEADERS: Headers Exchange uses the Headers property instead of Routing Key for routing matching.
     * When binding Headers Exchange and Queue, set the key-value pair of the binding property;
     * when sending a message to the Headers Exchange, set the message's Headers property key-value pair and use the message Headers
     * The message is routed to the bound Queue by comparing the attribute key-value pair and the bound attribute key-value pair.
     */
    @JvmName("qclypjokqsxfumki")
    public suspend fun exchangeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exchangeType = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("kaxjjiafamvjfnfi")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies whether an exchange is an internal exchange. Valid values:
     * * false: The exchange is not an internal exchange.
     * * true: The exchange is an internal exchange.
     */
    @JvmName("pjyrdjlvtifxmote")
    public suspend fun `internal`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`internal` = mapped
    }

    /**
     * @param value The name of virtual host where an exchange resides.
     */
    @JvmName("oevmjrwxbdfrahml")
    public suspend fun virtualHostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHostName = mapped
    }

    internal fun build(): ExchangeArgs = ExchangeArgs(
        alternateExchange = alternateExchange,
        autoDeleteState = autoDeleteState,
        exchangeName = exchangeName,
        exchangeType = exchangeType,
        instanceId = instanceId,
        `internal` = `internal`,
        virtualHostName = virtualHostName,
    )
}
