@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin

import com.pulumi.alicloud.amqp.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Amqp Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:amqp/instance:Instance example <id>
 * ```
 * @property autoRenew Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
 * @property instanceName The instance name.
 * @property instanceType Instance type. Valid values are as follows:  professional: professional Edition enterprise: enterprise Edition vip: Platinum Edition.
 * @property maxConnections The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
 * @property maxEipTps Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
 * @property maxTps Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
 * @property modifyType Type of instance lifting and lowering:
 * - Upgrade: Upgrade
 * - Downgrade: Downgrading.
 * @property paymentType The Payment type. Valid value: Subscription: prepaid. PayAsYouGo: Post-paid.
 * @property period Prepayment cycle, unit: periodCycle.  This parameter is valid when PaymentType is set to Subscription.
 * @property periodCycle Prepaid cycle units. Value: Month. Year: Year.
 * @property queueCapacity Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
 * @property renewalDuration The number of automatic renewal cycles.
 * @property renewalDurationUnit Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
 * @property renewalStatus The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
 * @property serverlessChargeType The billing type of the serverless instance. Value: onDemand.
 * @property storageSize Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
 * @property supportEip Whether to support public network.
 * @property supportTracing Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
 * @property tracingStorageTime Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
 */
public data class InstanceArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val maxConnections: Output<Int>? = null,
    public val maxEipTps: Output<String>? = null,
    public val maxTps: Output<String>? = null,
    public val modifyType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodCycle: Output<String>? = null,
    public val queueCapacity: Output<String>? = null,
    public val renewalDuration: Output<Int>? = null,
    public val renewalDurationUnit: Output<String>? = null,
    public val renewalStatus: Output<String>? = null,
    public val serverlessChargeType: Output<String>? = null,
    public val storageSize: Output<String>? = null,
    public val supportEip: Output<Boolean>? = null,
    public val supportTracing: Output<Boolean>? = null,
    public val tracingStorageTime: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.amqp.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.amqp.InstanceArgs =
        com.pulumi.alicloud.amqp.InstanceArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .maxConnections(maxConnections?.applyValue({ args0 -> args0 }))
            .maxEipTps(maxEipTps?.applyValue({ args0 -> args0 }))
            .maxTps(maxTps?.applyValue({ args0 -> args0 }))
            .modifyType(modifyType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodCycle(periodCycle?.applyValue({ args0 -> args0 }))
            .queueCapacity(queueCapacity?.applyValue({ args0 -> args0 }))
            .renewalDuration(renewalDuration?.applyValue({ args0 -> args0 }))
            .renewalDurationUnit(renewalDurationUnit?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .serverlessChargeType(serverlessChargeType?.applyValue({ args0 -> args0 }))
            .storageSize(storageSize?.applyValue({ args0 -> args0 }))
            .supportEip(supportEip?.applyValue({ args0 -> args0 }))
            .supportTracing(supportTracing?.applyValue({ args0 -> args0 }))
            .tracingStorageTime(tracingStorageTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var maxConnections: Output<Int>? = null

    private var maxEipTps: Output<String>? = null

    private var maxTps: Output<String>? = null

    private var modifyType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodCycle: Output<String>? = null

    private var queueCapacity: Output<String>? = null

    private var renewalDuration: Output<Int>? = null

    private var renewalDurationUnit: Output<String>? = null

    private var renewalStatus: Output<String>? = null

    private var serverlessChargeType: Output<String>? = null

    private var storageSize: Output<String>? = null

    private var supportEip: Output<Boolean>? = null

    private var supportTracing: Output<Boolean>? = null

    private var tracingStorageTime: Output<Int>? = null

    /**
     * @param value Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
     */
    @JvmName("rauvuqepsdbqgfax")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The instance name.
     */
    @JvmName("eyjkqxbuitsobujo")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Instance type. Valid values are as follows:  professional: professional Edition enterprise: enterprise Edition vip: Platinum Edition.
     */
    @JvmName("whxkgbussghwjdqf")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
     */
    @JvmName("ngwlohytjvdsblis")
    public suspend fun maxConnections(`value`: Output<Int>) {
        this.maxConnections = value
    }

    /**
     * @param value Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
     */
    @JvmName("lywsrxruwokewcfh")
    public suspend fun maxEipTps(`value`: Output<String>) {
        this.maxEipTps = value
    }

    /**
     * @param value Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
     */
    @JvmName("asduaesvvscbdywx")
    public suspend fun maxTps(`value`: Output<String>) {
        this.maxTps = value
    }

    /**
     * @param value Type of instance lifting and lowering:
     * - Upgrade: Upgrade
     * - Downgrade: Downgrading.
     */
    @JvmName("cehnblunccsfvmmq")
    public suspend fun modifyType(`value`: Output<String>) {
        this.modifyType = value
    }

    /**
     * @param value The Payment type. Valid value: Subscription: prepaid. PayAsYouGo: Post-paid.
     */
    @JvmName("nqaytwtjsjdxmcrm")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Prepayment cycle, unit: periodCycle.  This parameter is valid when PaymentType is set to Subscription.
     */
    @JvmName("fsirqxsqdvulohhj")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Prepaid cycle units. Value: Month. Year: Year.
     */
    @JvmName("huuryptjbliymniu")
    public suspend fun periodCycle(`value`: Output<String>) {
        this.periodCycle = value
    }

    /**
     * @param value Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
     */
    @JvmName("ocgbjxhexwxaywdr")
    public suspend fun queueCapacity(`value`: Output<String>) {
        this.queueCapacity = value
    }

    /**
     * @param value The number of automatic renewal cycles.
     */
    @JvmName("vulcxeigswhiiilj")
    public suspend fun renewalDuration(`value`: Output<Int>) {
        this.renewalDuration = value
    }

    /**
     * @param value Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
     */
    @JvmName("jjauvnjdrutoqxet")
    public suspend fun renewalDurationUnit(`value`: Output<String>) {
        this.renewalDurationUnit = value
    }

    /**
     * @param value The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
     */
    @JvmName("nfbpoqxhgdlockmj")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The billing type of the serverless instance. Value: onDemand.
     */
    @JvmName("qfffnxlysrwedsyr")
    public suspend fun serverlessChargeType(`value`: Output<String>) {
        this.serverlessChargeType = value
    }

    /**
     * @param value Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
     */
    @JvmName("fubyktgtpjwifckg")
    public suspend fun storageSize(`value`: Output<String>) {
        this.storageSize = value
    }

    /**
     * @param value Whether to support public network.
     */
    @JvmName("ihmtfcsjgsytmpfw")
    public suspend fun supportEip(`value`: Output<Boolean>) {
        this.supportEip = value
    }

    /**
     * @param value Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
     */
    @JvmName("uyfpmxdefijvbuil")
    public suspend fun supportTracing(`value`: Output<Boolean>) {
        this.supportTracing = value
    }

    /**
     * @param value Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
     */
    @JvmName("alaoabqblehvfpxs")
    public suspend fun tracingStorageTime(`value`: Output<Int>) {
        this.tracingStorageTime = value
    }

    /**
     * @param value Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
     */
    @JvmName("fkuaxqnwlfxwdfsy")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The instance name.
     */
    @JvmName("hpaexbftxpbkxtah")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Instance type. Valid values are as follows:  professional: professional Edition enterprise: enterprise Edition vip: Platinum Edition.
     */
    @JvmName("ysvwwfhdmpttrpao")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
     */
    @JvmName("eridierjasducxvh")
    public suspend fun maxConnections(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConnections = mapped
    }

    /**
     * @param value Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
     */
    @JvmName("byijhkagjioofclg")
    public suspend fun maxEipTps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxEipTps = mapped
    }

    /**
     * @param value Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
     */
    @JvmName("vsjmwgiajbukajhs")
    public suspend fun maxTps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTps = mapped
    }

    /**
     * @param value Type of instance lifting and lowering:
     * - Upgrade: Upgrade
     * - Downgrade: Downgrading.
     */
    @JvmName("wovabvlmkqbwlstu")
    public suspend fun modifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyType = mapped
    }

    /**
     * @param value The Payment type. Valid value: Subscription: prepaid. PayAsYouGo: Post-paid.
     */
    @JvmName("aeyfrptaylcugqeh")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Prepayment cycle, unit: periodCycle.  This parameter is valid when PaymentType is set to Subscription.
     */
    @JvmName("ojqerfhtyhofgenu")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Prepaid cycle units. Value: Month. Year: Year.
     */
    @JvmName("wbfoxhtmiwbwpqqg")
    public suspend fun periodCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodCycle = mapped
    }

    /**
     * @param value Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
     */
    @JvmName("wrpoosavtfqxarfw")
    public suspend fun queueCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueCapacity = mapped
    }

    /**
     * @param value The number of automatic renewal cycles.
     */
    @JvmName("shnnoxlwomckhdgb")
    public suspend fun renewalDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalDuration = mapped
    }

    /**
     * @param value Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
     */
    @JvmName("hphwhmrgbvgpxmms")
    public suspend fun renewalDurationUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalDurationUnit = mapped
    }

    /**
     * @param value The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
     */
    @JvmName("gtgahxgpdsrtysyg")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The billing type of the serverless instance. Value: onDemand.
     */
    @JvmName("srsbcisimtagftga")
    public suspend fun serverlessChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessChargeType = mapped
    }

    /**
     * @param value Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
     */
    @JvmName("fanpuydjyhaktevr")
    public suspend fun storageSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSize = mapped
    }

    /**
     * @param value Whether to support public network.
     */
    @JvmName("gevmkvcmgoqfkwek")
    public suspend fun supportEip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportEip = mapped
    }

    /**
     * @param value Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
     */
    @JvmName("bvtbivkkoemmyhtw")
    public suspend fun supportTracing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportTracing = mapped
    }

    /**
     * @param value Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
     */
    @JvmName("bpqqqpmabarhpqmh")
    public suspend fun tracingStorageTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingStorageTime = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        autoRenew = autoRenew,
        instanceName = instanceName,
        instanceType = instanceType,
        maxConnections = maxConnections,
        maxEipTps = maxEipTps,
        maxTps = maxTps,
        modifyType = modifyType,
        paymentType = paymentType,
        period = period,
        periodCycle = periodCycle,
        queueCapacity = queueCapacity,
        renewalDuration = renewalDuration,
        renewalDurationUnit = renewalDurationUnit,
        renewalStatus = renewalStatus,
        serverlessChargeType = serverlessChargeType,
        storageSize = storageSize,
        supportEip = supportEip,
        supportTracing = supportTracing,
        tracingStorageTime = tracingStorageTime,
    )
}
